/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFunction;

public class PhysicsFunction
implements ParticleFunction {
    private double deltaTime = 0.025;
    private Vector3d position = new Vector3d();
    private Vector3d acceleration = new Vector3d();
    private double frictionForce = 0.9;
    private double frictionVelocity = 0.95;
    private long startTime = System.currentTimeMillis();
    private static final int recalculateInterval = 50;
    private static long invokeCount = 0L;
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean newFrame() {
        if (++invokeCount == 50L) {
            long l = System.currentTimeMillis();
            double d = (double)(l - this.startTime) / 1000.0;
            this.deltaTime = d / 50.0;
            System.out.println("PhysicsFunction FPS: " + 1.0 / this.deltaTime);
            invokeCount = 0L;
            this.startTime = l;
        }
        return true;
    }

    public boolean apply(Particle particle) {
        this.acceleration.set((Tuple3d)particle.resultantForce);
        this.acceleration.scale(this.deltaTime / particle.mass);
        particle.velocity.add((Tuple3d)this.acceleration);
        particle.getPosition((Tuple3d)this.position);
        this.acceleration.set((Tuple3d)particle.velocity);
        this.acceleration.scale(this.deltaTime);
        this.position.add((Tuple3d)this.acceleration);
        particle.setPosition((float)this.position.x, (float)this.position.y, (float)this.position.z);
        return true;
    }
}

