/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d.parser.handlers;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import org.j3d.loaders.ac3d.models.Ac3dMaterial;
import org.j3d.loaders.ac3d.models.Ac3dObject;
import org.j3d.loaders.ac3d.models.Ac3dSurface;
import org.j3d.loaders.ac3d.parser.LineTokenizer;
import org.j3d.loaders.ac3d.parser.TokenHandler;
import org.j3d.loaders.ac3d.parser.exceptions.AC3DParseException;
import org.j3d.loaders.ac3d.parser.exceptions.InvalidTokenOrderingException;

public abstract class Ac3dTokenHandlerBase
extends TokenHandler {
    private BufferedReader bufferedReader;
    protected int materialIndexPtr;
    protected int surfaceIndex;
    protected Stack callStack;
    protected Vector materials;
    protected Vector displayList;
    public static final int SUPPORTED_FORMAT_VERSION = 11;

    public Ac3dTokenHandlerBase() {
        this.setVersion(11);
    }

    public void token_MATERIAL(String[] stringArray) throws AC3DParseException {
        Ac3dMaterial ac3dMaterial = new Ac3dMaterial();
        int n = 0;
        while (++n < stringArray.length) {
            if (n == 1) {
                ac3dMaterial.setName(stringArray[n]);
                continue;
            }
            if (stringArray[n].equals("rgb")) {
                ac3dMaterial.setRgb(Ac3dTokenHandlerBase.parseFloats(stringArray, ++n, 3));
                n += 3;
                continue;
            }
            if (stringArray[n].equals("amb")) {
                ac3dMaterial.setAmb(Ac3dTokenHandlerBase.parseFloats(stringArray, ++n, 3));
                n += 3;
                continue;
            }
            if (stringArray[n].equals("emis")) {
                ac3dMaterial.setEmis(Ac3dTokenHandlerBase.parseFloats(stringArray, ++n, 3));
                n += 3;
                continue;
            }
            if (stringArray[n].equals("spec")) {
                ac3dMaterial.setSpec(Ac3dTokenHandlerBase.parseFloats(stringArray, ++n, 3));
                n += 3;
                continue;
            }
            if (stringArray[n].equals("shi")) {
                ac3dMaterial.setShi(Ac3dTokenHandlerBase.parseDecimal(stringArray[++n]));
                ++n;
                continue;
            }
            if (!stringArray[n].equals("trans")) continue;
            ac3dMaterial.setTrans(Ac3dTokenHandlerBase.parseFloat(stringArray[++n]));
            ++n;
        }
        ac3dMaterial.setIndex(this.materialIndexPtr);
        this.materials.addElement(ac3dMaterial);
        ++this.materialIndexPtr;
    }

    public void token_OBJECT(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = new Ac3dObject();
        if (stringArray.length == 2) {
            ac3dObject.setType(stringArray[1]);
            this.callStack.push(ac3dObject);
            this.surfaceIndex = -1;
        }
    }

    public void token_kids(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setNumKids(Ac3dTokenHandlerBase.parseDecimal(stringArray[1]));
        this.displayList.addElement(this.callStack.pop());
    }

    public void token_numvert(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setNumvert(Ac3dTokenHandlerBase.parseDecimal(stringArray[1]));
        try {
            int n = 0;
            while (n < ac3dObject.getNumvert()) {
                String[] stringArray2 = LineTokenizer.enumerateTokens(this.bufferedReader.readLine());
                ac3dObject.addVertex(n, Ac3dTokenHandlerBase.parseFloats(stringArray2, 0, 3));
                ++n;
            }
        }
        catch (IOException iOException) {
            this.error(iOException, "Could not read all of the verticies.");
            throw new AC3DParseException(iOException.getMessage());
        }
    }

    public void token_name(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setName(stringArray[1]);
    }

    public void token_loc(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = this.qualifyTagByAC3DObject(stringArray, 4);
        ac3dObject.setLoc(Ac3dTokenHandlerBase.parseFloats(stringArray, 1, 3));
    }

    public void token_rot(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = this.qualifyTagByAC3DObject(stringArray, 10);
        ac3dObject.setRot(Ac3dTokenHandlerBase.parseFloats(stringArray, 1, 9));
    }

    public void token_numsurf(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setNumsurf(Ac3dTokenHandlerBase.parseDecimal(stringArray[1]));
        this.surfaceIndex = 0;
    }

    public void token_SURF(String[] stringArray) throws AC3DParseException {
        this.qualifyTagByAC3DObject(stringArray, 2);
        Ac3dSurface ac3dSurface = new Ac3dSurface();
        ac3dSurface.setFlags(Ac3dTokenHandlerBase.parseHexidecimal(stringArray[1]));
        this.callStack.push(ac3dSurface);
    }

    public void token_refs(String[] stringArray) throws AC3DParseException {
        Ac3dSurface ac3dSurface = this.qualifyTagByAC3DSurface(stringArray, 2);
        ac3dSurface.setNumrefs(Ac3dTokenHandlerBase.parseDecimal(stringArray[1]));
        try {
            int n = 0;
            while (n < ac3dSurface.getNumrefs()) {
                String[] stringArray2 = LineTokenizer.enumerateTokens(this.bufferedReader.readLine());
                ac3dSurface.addRef(n, Ac3dTokenHandlerBase.parseDecimal(stringArray2[0]), Ac3dTokenHandlerBase.parseFloats(stringArray2, 1, 2));
                ++n;
            }
            this.debug("SURFACE defined as: " + ac3dSurface.toString());
            this.callStack.pop();
            Object e = this.callStack.peek();
            if (e instanceof Ac3dObject) {
                Ac3dObject ac3dObject = (Ac3dObject)e;
                ac3dObject.addSurface(this.surfaceIndex, ac3dSurface);
            }
            ++this.surfaceIndex;
        }
        catch (IOException iOException) {
            this.error(iOException, "Could not read all of the refs.");
            throw new AC3DParseException(iOException.getMessage());
        }
    }

    public void token_mat(String[] stringArray) throws AC3DParseException {
        Ac3dSurface ac3dSurface = this.qualifyTagByAC3DSurface(stringArray, 2);
        ac3dSurface.setMat(Ac3dTokenHandlerBase.parseDecimal(stringArray[1]));
    }

    public void token_texture(String[] stringArray) throws AC3DParseException {
        Ac3dObject ac3dObject = new Ac3dObject();
        ac3dObject = this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setTexture(stringArray[1]);
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    public void reset() {
        this.materialIndexPtr = 0;
        this.surfaceIndex = -1;
        this.callStack = new Stack();
        this.materials = new Vector();
        this.displayList = new Vector();
    }

    private final Ac3dObject qualifyTagByAC3DObject(String[] stringArray, int n) throws AC3DParseException {
        Object object = null;
        if (stringArray.length != n) {
            throw new AC3DParseException("Wrong number of args for " + stringArray[0] + "; expecting " + n + ", got " + stringArray.length);
        }
        if (this.callStack.size() <= 0) {
            throw new AC3DParseException("Parent not found on stack!");
        }
        object = this.callStack.peek();
        if (!(object instanceof Ac3dObject)) {
            throw new InvalidTokenOrderingException("Was expecting: \"Ac3dObject, instead got: \"" + object.getClass().getName() + "\".");
        }
        return (Ac3dObject)object;
    }

    private final Ac3dSurface qualifyTagByAC3DSurface(String[] stringArray, int n) throws AC3DParseException {
        Object object = null;
        if (stringArray.length != n) {
            throw new AC3DParseException("Wrong number of args for " + stringArray[0] + "; expecting " + n + ", got " + stringArray.length);
        }
        if (this.callStack.size() <= 0) {
            throw new AC3DParseException("Parent not found on stack!");
        }
        object = this.callStack.peek();
        if (!(object instanceof Ac3dSurface)) {
            throw new InvalidTokenOrderingException("Was expecting: \"Ac3dSurface, instead got: \"" + object.getClass().getName() + "\".");
        }
        return (Ac3dSurface)object;
    }

    private static final float[] parseFloats(String[] stringArray, int n, int n2) {
        float[] fArray = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3] = Ac3dTokenHandlerBase.parseFloat(stringArray[n + n3]);
            ++n3;
        }
        return fArray;
    }

    private static final int parseDecimal(String string) {
        return Integer.valueOf(string);
    }

    private static final int parseHexidecimal(String string) {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            string = string.substring(2, string.length());
        }
        return Integer.valueOf(string, 16);
    }

    private static final float parseFloat(String string) {
        if (string.indexOf(".") < 0) {
            string = string + ".0";
        }
        float f = Float.valueOf(string).floatValue();
        return f;
    }
}

