/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import org.j3d.loaders.stl.STLFileReader;

public class STLLoader
extends LoaderBase {
    private final Component itsParentComponent;
    private boolean itsShowProgress = false;

    public STLLoader() {
        this.itsParentComponent = null;
    }

    public STLLoader(Component component) {
        this.itsParentComponent = component;
        this.itsShowProgress = true;
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            return this.load(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException();
        }
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        STLFileReader sTLFileReader = null;
        try {
            sTLFileReader = this.itsShowProgress ? new STLFileReader(uRL, this.itsParentComponent) : new STLFileReader(uRL);
            return STLLoader.createScene(sTLFileReader);
        }
        catch (InterruptedIOException interruptedIOException) {
            return null;
        }
        catch (IOException iOException) {
            throw new IncorrectFormatException(iOException.toString());
        }
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        return null;
    }

    /*
     * Loose catch block
     */
    public static Scene createScene(STLFileReader sTLFileReader) throws IncorrectFormatException, ParsingErrorException {
        SceneBase sceneBase;
        SceneBase sceneBase2 = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        int n = sTLFileReader.getNumOfObjects();
        int[] nArray = sTLFileReader.getNumOfFacets();
        String[] stringArray = sTLFileReader.getObjectNames();
        double[] dArray = new double[3];
        float[] fArray = new float[3];
        double[][] dArray2 = new double[3][3];
        int n2 = 0;
        while (n2 < n) {
            sceneBase = new TriangleArray(3 * nArray[n2], 3);
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray[n2]) {
                boolean bl = sTLFileReader.getNextFacet(dArray, dArray2);
                if (bl) {
                    fArray[0] = (float)dArray[0];
                    fArray[1] = (float)dArray[1];
                    fArray[2] = (float)dArray[2];
                    int n5 = 0;
                    while (n5 < 3) {
                        sceneBase.setNormal(n3, fArray);
                        sceneBase.setCoordinate(n3, dArray2[n5]);
                        ++n3;
                        ++n5;
                    }
                } else {
                    throw new ParsingErrorException();
                }
                ++n4;
            }
            Shape3D shape3D = new Shape3D((Geometry)sceneBase);
            branchGroup.addChild((Node)shape3D);
            String string = stringArray[n2];
            if (string == null) {
                string = new String("Unknown_" + n2);
            }
            sceneBase2.addNamedObject(string, (Object)shape3D);
            ++n2;
        }
        sceneBase2.setSceneGroup(branchGroup);
        sceneBase = sceneBase2;
        Object var16_20 = null;
        try {
            sTLFileReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return sceneBase;
        catch (InterruptedIOException interruptedIOException) {
            Scene scene = null;
            Object var16_21 = null;
            try {
                sTLFileReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return scene;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.toString());
            {
                catch (Throwable throwable) {
                    Object var16_22 = null;
                    try {
                        sTLFileReader.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
    }
}

