/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import org.j3d.terrain.roam.QueueItem;

class FastQueue {
    private static final int BUCKETS = 2048;
    private static final float TOP = 0.2f;
    private boolean diamondQueue = false;
    private QueueItem[] queueBuckets;
    private int largest = 0;
    private int smallest = 2048;
    private int currentBucket;

    public FastQueue(boolean bl) {
        this.diamondQueue = bl;
        this.queueBuckets = new QueueItem[2049];
    }

    public void add(QueueItem queueItem) {
        QueueItem queueItem2;
        queueItem.next = queueItem2 = this.getList(queueItem);
        if (queueItem2 != null) {
            queueItem2.prev = queueItem;
        }
        queueItem.prev = null;
        this.queueBuckets[this.currentBucket] = queueItem;
        this.largest = Math.max(this.largest, this.currentBucket);
        this.smallest = Math.min(this.smallest, this.currentBucket);
    }

    public void remove(QueueItem queueItem) {
        if (queueItem.prev == null) {
            QueueItem queueItem2 = this.getList(queueItem);
            if (queueItem2 == null || queueItem2 != queueItem) {
                return;
            }
            this.queueBuckets[this.currentBucket] = queueItem.next;
            if (queueItem.next != null) {
                queueItem.next.prev = null;
            }
            queueItem.prev = null;
            queueItem.next = null;
        } else {
            queueItem.prev.next = queueItem.next;
            if (queueItem.next != null) {
                queueItem.next.prev = queueItem.prev;
            }
            queueItem.prev = null;
            queueItem.next = null;
        }
    }

    public QueueItem last() {
        QueueItem queueItem = this.queueBuckets[this.largest];
        while (queueItem == null && this.largest >= this.smallest) {
            --this.largest;
            queueItem = this.queueBuckets[this.largest];
        }
        return queueItem;
    }

    public QueueItem first() {
        QueueItem queueItem = this.queueBuckets[this.smallest];
        while (queueItem == null && this.smallest <= this.largest) {
            ++this.smallest;
            queueItem = this.queueBuckets[this.smallest];
        }
        return queueItem;
    }

    public void clear() {
        int n = 0;
        while (n < this.queueBuckets.length) {
            this.queueBuckets[n] = null;
            ++n;
        }
    }

    private QueueItem getList(QueueItem queueItem) {
        float f = queueItem.variance;
        this.currentBucket = f > 0.2f ? 2048 : (int)(f / 0.2f * 2048.0f);
        return this.queueBuckets[this.currentBucket];
    }
}

