/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.terrain.AppearanceGenerator;
import org.j3d.terrain.FreeFormTerrainData;
import org.j3d.terrain.Landscape;
import org.j3d.terrain.StaticTerrainData;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.TiledTerrainData;
import org.j3d.terrain.roam.DefaultAppearanceGenerator;
import org.j3d.terrain.roam.Patch;
import org.j3d.terrain.roam.PatchGrid;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.TreeQueueManager;
import org.j3d.util.frustum.ViewFrustum;

public class SplitMergeLandscape
extends Landscape {
    private static final String NEG_PATCH_SIZE_MSG = "The patch size provided is negative or zero.";
    private static final String NOT_POW2_MSG = "The patchSize is not a power of two";
    private static final String GRID_W_SIZE_MSG = "The grid width is not (n * patchSize + 1) in size: ";
    private static final String GRID_D_SIZE_MSG = "The grid depth is not (n * patchSize + 1) in size: ";
    private static final int DEFAULT_PATCH_SIZE = 65;
    private static final int AXIS_TILE_COUNT = 7;
    private final int patchSize;
    private final int invPatchSize;
    private final int terrainDataType;
    private final float accuracy;
    private ArrayList patches = new ArrayList();
    private TreeQueueManager queueManager = new TreeQueueManager();
    private int triCount = 0;
    private AppearanceGenerator defaultAppGenerator;
    private Point3d maxViewBound;
    private Point3d minViewBound;
    private Rectangle oldTileBounds;
    private Rectangle reqdBounds;
    private LinkedList freePatchList;
    private ArrayList tempPatchList;
    private PatchGrid patchGrid;

    public SplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData) {
        super(viewFrustum, terrainData);
        this.terrainDataType = terrainData.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(terrainData, 65);
        this.invPatchSize = 1 / this.patchSize;
    }

    public SplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData, int n) {
        super(viewFrustum, terrainData);
        if (n <= 0) {
            throw new IllegalArgumentException(NEG_PATCH_SIZE_MSG);
        }
        if (!this.power2Check(n - 1)) {
            throw new IllegalArgumentException(NOT_POW2_MSG);
        }
        this.terrainDataType = terrainData.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(terrainData, n);
        this.invPatchSize = 1 / n;
    }

    public SplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData, AppearanceGenerator appearanceGenerator) {
        super(viewFrustum, terrainData, appearanceGenerator);
        this.terrainDataType = terrainData.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(terrainData, 65);
        this.invPatchSize = 1 / this.patchSize;
    }

    public SplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData, int n, AppearanceGenerator appearanceGenerator) {
        super(viewFrustum, terrainData, appearanceGenerator);
        if (n <= 0) {
            throw new IllegalArgumentException(NEG_PATCH_SIZE_MSG);
        }
        if (!this.power2Check(n - 1)) {
            throw new IllegalArgumentException(NOT_POW2_MSG);
        }
        this.terrainDataType = terrainData.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(terrainData, n);
        this.invPatchSize = 1 / n;
    }

    public void initialize(Tuple3f tuple3f, Vector3f vector3f) {
        this.landscapeView.viewingPlatformMoved();
        switch (this.terrainDataType) {
            case 1: {
                this.createStaticPatches();
                break;
            }
            case 2: {
                this.minViewBound = new Point3d();
                this.maxViewBound = new Point3d();
                this.reqdBounds = new Rectangle();
                this.oldTileBounds = new Rectangle();
                this.freePatchList = new LinkedList();
                this.tempPatchList = new ArrayList();
                this.createTiledPatches(tuple3f, vector3f);
                break;
            }
            case 3: {
                this.createFreeFormPatches();
            }
        }
        this.setView(tuple3f, vector3f);
    }

    public void setView(Tuple3f tuple3f, Vector3f vector3f) {
        this.queueManager.clear();
        this.landscapeView.viewingPlatformMoved();
        switch (this.terrainDataType) {
            case 2: {
                if (this.calculateViewTileBounds(tuple3f, vector3f)) break;
                this.patchGrid.prepareNewBounds(this.reqdBounds);
                this.clearOldTiledPatches();
                this.loadNewTiles(tuple3f);
                this.oldTileBounds.setBounds(this.reqdBounds);
                break;
            }
        }
        int n = this.patches.size();
        int n2 = 0;
        while (n2 < n) {
            Patch patch = (Patch)this.patches.get(n2);
            patch.setView(tuple3f, this.landscapeView, this.queueManager);
            ++n2;
        }
        boolean bl = false;
        while (!bl) {
            TreeNode treeNode = this.queueManager.getSplitCandidate();
            TreeNode treeNode2 = this.queueManager.getMergeCandidate();
            if (treeNode2 == null && treeNode != null) {
                if (treeNode.variance > this.accuracy) {
                    treeNode.forceSplit(tuple3f, this.landscapeView, this.queueManager);
                    continue;
                }
                bl = true;
                continue;
            }
            if (treeNode2 != null && treeNode == null) {
                if (treeNode2.variance < this.accuracy) {
                    treeNode2.merge(this.queueManager);
                    continue;
                }
                bl = true;
                continue;
            }
            if (treeNode2 != null && treeNode != null && (treeNode.variance > this.accuracy || treeNode.variance > treeNode2.variance)) {
                if (treeNode.variance > this.accuracy) {
                    treeNode.forceSplit(tuple3f, this.landscapeView, this.queueManager);
                    continue;
                }
                if (!(treeNode2.variance < this.accuracy)) continue;
                treeNode2.merge(this.queueManager);
                continue;
            }
            bl = true;
        }
        int n3 = 0;
        while (n3 < n) {
            Patch patch = (Patch)this.patches.get(n3);
            patch.updateGeometry();
            ++n3;
        }
        this.queueManager.clear();
    }

    private int init(TerrainData terrainData, int n) {
        int n2 = n;
        switch (this.terrainDataType) {
            case 1: {
                StaticTerrainData staticTerrainData = (StaticTerrainData)terrainData;
                int n3 = staticTerrainData.getGridWidth();
                int n4 = staticTerrainData.getGridDepth();
                if (!this.checkPatchSide(n3, n)) {
                    throw new IllegalArgumentException(GRID_W_SIZE_MSG + n3);
                }
                if (this.checkPatchSide(n4, n)) break;
                throw new IllegalArgumentException(GRID_D_SIZE_MSG + n4);
            }
            case 3: {
                break;
            }
            case 2: {
                n2 = ((TiledTerrainData)terrainData).getTileSize();
                break;
            }
            default: {
                n2 = 0;
                System.out.println("Unknown terrain type");
            }
        }
        return n2;
    }

    private void createTiledPatches(Tuple3f tuple3f, Vector3f vector3f) {
        TiledTerrainData tiledTerrainData = (TiledTerrainData)this.terrainData;
        this.calculateViewTileBounds(tuple3f, vector3f);
        tiledTerrainData.setActiveBounds(this.reqdBounds);
        this.oldTileBounds.setBounds(this.reqdBounds);
        this.patchGrid = new PatchGrid(this.reqdBounds);
        AppearanceGenerator appearanceGenerator = this.getAppGenerator();
        Patch patch = null;
        int n = this.reqdBounds.x * this.patchSize;
        int n2 = this.reqdBounds.x;
        int n3 = n;
        int n4 = 0;
        while (n4 < this.reqdBounds.width) {
            int n5 = this.reqdBounds.y * this.patchSize;
            int n6 = this.reqdBounds.y;
            int n7 = n5;
            int n8 = 0;
            while (n8 < this.reqdBounds.height) {
                Appearance appearance = appearanceGenerator.createAppearance();
                appearance.setCapability(3);
                appearance.setTexture(tiledTerrainData.getTexture(n2, n6));
                patch = new Patch(this.terrainData, this.patchSize, appearance, this.landscapeView, n4, n8);
                patch.setOrigin(n3, n7);
                this.patchGrid.addPatch(patch, n2, n6);
                patch.makeActive();
                this.patches.add(patch);
                this.triCount += 2;
                this.addChild((Node)patch.getShape3D());
                ++n6;
                ++n5;
                n7 += this.patchSize;
                ++n8;
            }
            ++n2;
            ++n;
            n3 += this.patchSize;
            ++n4;
        }
    }

    private void createFreeFormPatches() {
        FreeFormTerrainData freeFormTerrainData = (FreeFormTerrainData)this.terrainData;
        System.out.println("Free-form terrain not implemented yet");
    }

    private void createStaticPatches() {
        StaticTerrainData staticTerrainData = (StaticTerrainData)this.terrainData;
        int n = staticTerrainData.getGridDepth() - this.patchSize;
        int n2 = staticTerrainData.getGridWidth() - this.patchSize;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Patch size is greater than the grid cell size");
        }
        Patch[] patchArray = new Patch[n2];
        Patch patch = null;
        Patch patch2 = null;
        AppearanceGenerator appearanceGenerator = this.getAppGenerator();
        Appearance appearance = appearanceGenerator.createAppearance();
        appearance.setTexture(staticTerrainData.getTexture());
        if (n2 == 0) {
            int n3 = 0;
            while (n3 <= n) {
                patch2 = new Patch(this.terrainData, this.patchSize, appearance, this.landscapeView, 0, n3);
                patch2.setOrigin(0, n3);
                patch2.setSouthNeighbour(patch);
                patch2.makeActive();
                this.patches.add(patch2);
                this.triCount += 2;
                this.addChild((Node)patch2.getShape3D());
                patch = patch2;
                n3 += this.patchSize;
            }
            patch = null;
        } else {
            int n4 = 0;
            while (n4 <= n2) {
                int n5 = 0;
                while (n5 <= n) {
                    int n6 = n5 * this.invPatchSize;
                    patch2 = new Patch(this.terrainData, this.patchSize, appearance, this.landscapeView, n4, n5);
                    patch2.setOrigin(n4, n5);
                    patch2.setWestNeighbour(patchArray[n6]);
                    patch2.setSouthNeighbour(patch);
                    patch2.makeActive();
                    this.patches.add(patch2);
                    this.triCount += 2;
                    this.addChild((Node)patch2.getShape3D());
                    patch = patch2;
                    patchArray[n6] = patch2;
                    n5 += this.patchSize;
                }
                patch = null;
                n4 += this.patchSize;
            }
        }
    }

    private boolean power2Check(int n) {
        int n2 = n;
        while ((n2 & 1) == 0) {
            n2 >>= 1;
        }
        return (n2 | 1) == 1;
    }

    private boolean checkPatchSide(int n, int n2) {
        int n3 = n - 1;
        return n3 % n2 == 0;
    }

    private boolean calculateViewTileBounds(Tuple3f tuple3f, Vector3f vector3f) {
        TiledTerrainData tiledTerrainData = (TiledTerrainData)this.terrainData;
        float f = (float)tiledTerrainData.getGridXStep();
        float f2 = (float)tiledTerrainData.getGridYStep();
        int n = tiledTerrainData.getTileSize();
        float[] fArray = new float[3];
        tiledTerrainData.getCoordinate(fArray, 0, 0);
        float f3 = tuple3f.x - fArray[0];
        float f4 = fArray[2] - tuple3f.z;
        int n2 = (int)Math.floor(f3 / (f * (float)n));
        int n3 = (int)Math.floor(f4 / (f2 * (float)n));
        if (vector3f.x == 0.0f && vector3f.z == 0.0f) {
            n2 -= 3;
            n3 -= 3;
        } else {
            float f5 = Math.abs(vector3f.x / vector3f.z);
            if (vector3f.x >= 0.0f) {
                if (vector3f.z <= 0.0f) {
                    if (f5 < 0.5f) {
                        --n2;
                    } else if (f5 > 2.0f) {
                        --n3;
                    }
                } else {
                    --n3;
                    if (f5 < 0.5f) {
                        --n2;
                    }
                }
            } else if (vector3f.z <= 0.0f) {
                --n2;
                if (f5 > 2.0f) {
                    --n3;
                }
            } else {
                --n2;
                --n3;
            }
            this.reqdBounds.x = n2;
            this.reqdBounds.y = n3;
            this.reqdBounds.width = 7;
            this.reqdBounds.height = 7;
        }
        return this.oldTileBounds.equals(this.reqdBounds);
    }

    private void clearOldTiledPatches() {
        int n = this.patches.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            Patch patch = (Patch)this.patches.get(n2);
            if (!this.reqdBounds.contains(patch.getTileOrigin())) {
                patch.clear();
                this.freePatchList.add(patch);
                this.tempPatchList.add(patch);
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            this.patches.removeAll(this.tempPatchList);
            this.tempPatchList.clear();
        }
    }

    private void loadNewTiles(Tuple3f tuple3f) {
        Appearance appearance;
        int n;
        int n2;
        int n3;
        int n4;
        TiledTerrainData tiledTerrainData;
        Patch patch = null;
        AppearanceGenerator appearanceGenerator = this.getAppGenerator();
        float f = 1.0f / (float)this.patchSize;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.reqdBounds.x - this.oldTileBounds.x;
        n5 = n7 <= 0 ? this.reqdBounds.x : this.reqdBounds.x + this.reqdBounds.width - n7;
        int n8 = Math.abs(n7);
        n7 = this.reqdBounds.y - this.oldTileBounds.y;
        n6 = n7 <= 0 ? this.reqdBounds.y : this.reqdBounds.y + this.reqdBounds.height - n7;
        int n9 = Math.abs(n7);
        int n10 = 0;
        int n11 = 0;
        if (n9 != 0) {
            tiledTerrainData = (TiledTerrainData)this.terrainData;
            n4 = this.oldTileBounds.x - 1;
            n3 = n4 * this.patchSize;
            n10 = 0;
            while (n10 < this.reqdBounds.width) {
                n3 += this.patchSize;
                ++n4;
                n2 = n6;
                n = (n2 - 1) * this.patchSize;
                n11 = 0;
                while (n11 < n9) {
                    n += this.patchSize;
                    if (this.freePatchList.size() == 0) {
                        appearance = appearanceGenerator.createAppearance();
                        appearance.setCapability(3);
                        appearance.setTexture(tiledTerrainData.getTexture(n4, n2));
                        System.out.println("North: creating new Patch");
                        patch = new Patch(this.terrainData, this.patchSize, appearance, this.landscapeView, n10, n11);
                        this.addChild((Node)patch.getShape3D());
                    } else {
                        System.out.println("North: reusing Patch");
                        patch = (Patch)this.freePatchList.remove(0);
                        appearance = patch.getAppearance();
                        appearance.setTexture(tiledTerrainData.getTexture(n4, n2));
                    }
                    this.tempPatchList.add(patch);
                    patch.setOrigin(n3, n);
                    this.patchGrid.addPatch(patch, n4, n2);
                    patch.makeActive();
                    patch.reset();
                    this.patches.add(patch);
                    this.triCount += 2;
                    ++n2;
                    ++n11;
                }
                ++n10;
            }
        }
        if (n8 != 0) {
            n4 = n5 - 1;
            n9 = this.reqdBounds.height;
            tiledTerrainData = (TiledTerrainData)this.terrainData;
            n3 = n4 * this.patchSize;
            n10 = 0;
            while (n10 < n8) {
                n3 += this.patchSize;
                n2 = n6;
                n = (n2 - 1) * this.patchSize;
                ++n4;
                n11 = 0;
                while (n11 < n9) {
                    int n12 = (int)((float)n2 * f);
                    n += this.patchSize;
                    if (this.freePatchList.size() == 0) {
                        appearance = appearanceGenerator.createAppearance();
                        appearance.setCapability(3);
                        appearance.setTexture(tiledTerrainData.getTexture(n4, n2));
                        patch = new Patch(this.terrainData, this.patchSize, appearance, this.landscapeView, n10, n11);
                        BranchGroup branchGroup = new BranchGroup();
                        this.addChild((Node)patch.getShape3D());
                    } else {
                        patch = (Patch)this.freePatchList.remove(0);
                        appearance = patch.getAppearance();
                        appearance.setTexture(tiledTerrainData.getTexture(n4, n2));
                    }
                    this.tempPatchList.add(patch);
                    patch.setOrigin(n3, n);
                    this.patchGrid.addPatch(patch, n4, n2);
                    patch.makeActive();
                    patch.reset();
                    this.patches.add(patch);
                    this.triCount += 2;
                    ++n2;
                    ++n11;
                }
                ++n10;
            }
        }
        int n13 = this.tempPatchList.size();
        n10 = 0;
        while (n10 < n13) {
            patch = (Patch)this.tempPatchList.get(n10);
            patch.updateEdges(tuple3f, this.queueManager);
            ++n10;
        }
        this.tempPatchList.clear();
    }

    private AppearanceGenerator getAppGenerator() {
        AppearanceGenerator appearanceGenerator = null;
        if (this.appearanceGenerator == null) {
            if (this.defaultAppGenerator == null) {
                this.defaultAppGenerator = new DefaultAppearanceGenerator();
            }
            appearanceGenerator = this.defaultAppGenerator;
        } else {
            appearanceGenerator = this.appearanceGenerator;
        }
        return appearanceGenerator;
    }
}

