/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.util.LinkedList;
import javax.vecmath.Tuple3f;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.roam.QueueItem;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.VarianceTree;
import org.j3d.terrain.roam.VertexData;
import org.j3d.util.frustum.ViewFrustum;

class TreeNode
extends QueueItem {
    public static final int UNDEFINED = -1;
    public static final int BASE_TO_BASE = 1;
    public static final int LEFT_TO_RIGHT = 2;
    public static final int RIGHT_TO_LEFT = 3;
    TreeNode leftChild;
    TreeNode rightChild;
    TreeNode baseNeighbour;
    TreeNode leftNeighbour;
    TreeNode rightNeighbour;
    TreeNode parent;
    private int leftX;
    private int leftY;
    private int rightX;
    private int rightY;
    private int apexX;
    private int apexY;
    private int node;
    private int depth;
    int visible = -1;
    private float p1X;
    private float p1Y;
    private float p1Z;
    private float p2X;
    private float p2Y;
    private float p2Z;
    private float p3X;
    private float p3Y;
    private float p3Z;
    private float p1tS;
    private float p1tT;
    private float p2tS;
    private float p2tT;
    private float p3tS;
    private float p3tT;
    private float p1R;
    private float p1G;
    private float p1B;
    private float p2R;
    private float p2G;
    private float p2B;
    private float p3R;
    private float p3G;
    private float p3B;
    private TerrainData terrainData;
    private VarianceTree varianceTree;
    boolean diamond = false;
    private boolean textured;
    private int patchX;
    private int patchY;
    private static LinkedList nodeCache = new LinkedList();

    private TreeNode() {
    }

    void newNode(int n, int n2, int n3, int n4, int n5, int n6, int n7, TerrainData terrainData, ViewFrustum viewFrustum, int n8, int n9, VarianceTree varianceTree, int n10, int n11) {
        this.leftX = n;
        this.leftY = n2;
        this.rightX = n3;
        this.rightY = n4;
        this.apexX = n5;
        this.apexY = n6;
        this.node = n7;
        this.terrainData = terrainData;
        this.depth = n9;
        this.varianceTree = varianceTree;
        this.patchX = n10;
        this.patchY = n11;
        this.init(viewFrustum, n8);
    }

    boolean isLeaf() {
        return this.leftChild == null;
    }

    void reset(ViewFrustum viewFrustum) {
        if (this.leftChild != null) {
            this.leftChild.freeNode();
            this.leftChild = null;
        }
        if (this.rightChild != null) {
            this.rightChild.freeNode();
            this.rightChild = null;
        }
        this.baseNeighbour = null;
        this.leftNeighbour = null;
        this.rightNeighbour = null;
        this.visible = this.checkVisibility(viewFrustum);
    }

    void freeNode() {
        if (this.leftChild != null) {
            this.leftChild.freeNode();
            this.leftChild = null;
        }
        if (this.rightChild != null) {
            this.rightChild.freeNode();
            this.rightChild = null;
        }
        this.baseNeighbour = null;
        this.leftNeighbour = null;
        this.rightNeighbour = null;
        this.parent = null;
        this.diamond = false;
        this.visible = -1;
        nodeCache.add(this);
    }

    void computeVariance(Tuple3f tuple3f) {
        float f = (this.p1X + this.p2X) * 0.5f;
        float f2 = -(this.p1Y + this.p2Y) * 0.5f;
        float f3 = (tuple3f.x - f) * (tuple3f.x - f);
        float f4 = (tuple3f.z - f2) * (tuple3f.z - f2);
        float f5 = (float)Math.sqrt(f3 + f4);
        float f6 = (float)this.varianceTree.getVariance(this.node) / f5;
        this.variance = (float)Math.abs(Math.atan(f6));
    }

    int edgeSplit(TreeNode treeNode, int n, Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        if (treeNode.leftChild == null) {
            return 0;
        }
        int n2 = 0;
        if (this.leftChild == null) {
            this.forceSplit(tuple3f, viewFrustum, queueManager);
            n2 = 2;
        }
        switch (n) {
            case 2: {
                n2 += this.rightChild.edgeSplit(treeNode.leftChild, 1, tuple3f, viewFrustum, queueManager);
                break;
            }
            case 3: {
                n2 += this.leftChild.edgeSplit(treeNode.rightChild, 1, tuple3f, viewFrustum, queueManager);
                break;
            }
            case 1: {
                n2 += this.rightChild.edgeSplit(treeNode.leftChild, 2, tuple3f, viewFrustum, queueManager);
                n2 += this.leftChild.edgeSplit(treeNode.rightChild, 3, tuple3f, viewFrustum, queueManager);
            }
        }
        return n2;
    }

    void forceSplit(Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        if (this.baseNeighbour != null) {
            if (this.baseNeighbour.baseNeighbour != this) {
                this.baseNeighbour.forceSplit(tuple3f, viewFrustum, queueManager);
            }
            queueManager.removeTriangle(this);
            queueManager.removeTriangle(this.baseNeighbour);
            if (this.parent != null && this.isDiamond(this.parent)) {
                queueManager.removeDiamond(this.parent);
            }
            if (this.baseNeighbour.parent != null && this.isDiamond(this.baseNeighbour)) {
                queueManager.removeDiamond(this.baseNeighbour.parent);
            }
            this.split(tuple3f, viewFrustum, queueManager);
            this.baseNeighbour.split(tuple3f, viewFrustum, queueManager);
            this.leftChild.rightNeighbour = this.baseNeighbour.rightChild;
            this.rightChild.leftNeighbour = this.baseNeighbour.leftChild;
            this.baseNeighbour.leftChild.rightNeighbour = this.rightChild;
            this.baseNeighbour.rightChild.leftNeighbour = this.leftChild;
            queueManager.addTriangle(this.leftChild);
            queueManager.addTriangle(this.rightChild);
            queueManager.addTriangle(this.baseNeighbour.leftChild);
            queueManager.addTriangle(this.baseNeighbour.rightChild);
            queueManager.addDiamond(this);
        } else {
            if (this.parent != null && this.isDiamond(this.parent)) {
                queueManager.removeDiamond(this.parent);
            }
            queueManager.removeTriangle(this);
            this.split(tuple3f, viewFrustum, queueManager);
            this.leftChild.rightNeighbour = null;
            this.rightChild.leftNeighbour = null;
            queueManager.addTriangle(this.leftChild);
            queueManager.addTriangle(this.rightChild);
        }
    }

    void split(Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        this.initChildren(viewFrustum);
        this.leftChild.leftNeighbour = this.rightChild;
        this.rightChild.rightNeighbour = this.leftChild;
        this.leftChild.baseNeighbour = this.leftNeighbour;
        if (this.leftNeighbour != null) {
            if (this.leftNeighbour.baseNeighbour == this) {
                this.leftNeighbour.baseNeighbour = this.leftChild;
            } else if (this.leftNeighbour.leftNeighbour == this) {
                this.leftNeighbour.leftNeighbour = this.leftChild;
            } else {
                this.leftNeighbour.rightNeighbour = this.leftChild;
            }
        }
        this.rightChild.baseNeighbour = this.rightNeighbour;
        if (this.rightNeighbour != null) {
            if (this.rightNeighbour.baseNeighbour == this) {
                this.rightNeighbour.baseNeighbour = this.rightChild;
            } else if (this.rightNeighbour.rightNeighbour == this) {
                this.rightNeighbour.rightNeighbour = this.rightChild;
            } else {
                this.rightNeighbour.leftNeighbour = this.rightChild;
            }
        }
        if (this.depth + 1 < this.varianceTree.getMaxDepth() && this.visible != 2) {
            this.rightChild.computeVariance(tuple3f);
            this.leftChild.computeVariance(tuple3f);
        }
    }

    int merge(QueueManager queueManager) {
        queueManager.removeDiamond(this);
        int n = this.internalMerge(queueManager);
        n += this.baseNeighbour.internalMerge(queueManager);
        if (this.parent != null && this.isDiamond(this.parent)) {
            queueManager.addDiamond(this.parent);
        }
        if (this.baseNeighbour.parent != null && this.isDiamond(this.baseNeighbour.parent)) {
            queueManager.addDiamond(this.baseNeighbour.parent);
        }
        queueManager.addTriangle(this);
        queueManager.addTriangle(this.baseNeighbour);
        return n;
    }

    void getTriangles(VertexData vertexData) {
        if (this.leftChild == null) {
            if (this.visible != 2 && this.visible != -1) {
                switch (vertexData.dataType) {
                    case 1: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z);
                        break;
                    }
                    case 2: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1R, this.p1G, this.p1B);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2R, this.p2G, this.p2B);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3R, this.p3G, this.p3B);
                        break;
                    }
                    case 3: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1tS, this.p1tT);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2tS, this.p2tT);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3tS, this.p3tT);
                        break;
                    }
                    case 4: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1R, this.p1G, this.p1B, this.p1tS, this.p1tT);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2R, this.p2G, this.p2B, this.p2tS, this.p2tT);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3R, this.p3G, this.p3B, this.p3tS, this.p3tT);
                    }
                }
            }
        } else {
            this.leftChild.getTriangles(vertexData);
            this.rightChild.getTriangles(vertexData);
        }
    }

    int checkVisibility(ViewFrustum viewFrustum) {
        return viewFrustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z);
    }

    void updateTree(Tuple3f tuple3f, ViewFrustum viewFrustum, VarianceTree varianceTree, int n, QueueManager queueManager) {
        this.visible = n == -1 || n == 4 ? viewFrustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z) : n;
        if (this.leftChild == null && this.rightChild == null && this.depth < varianceTree.getMaxDepth() && this.visible != 2) {
            this.computeVariance(tuple3f);
            queueManager.addTriangle(this);
        } else if (this.leftChild != null) {
            this.leftChild.updateTree(tuple3f, viewFrustum, varianceTree, this.visible, queueManager);
            this.rightChild.updateTree(tuple3f, viewFrustum, varianceTree, this.visible, queueManager);
        }
    }

    static TreeNode getTreeNode() {
        TreeNode treeNode = nodeCache.size() > 0 ? (TreeNode)nodeCache.removeFirst() : new TreeNode();
        return treeNode;
    }

    private void init(ViewFrustum viewFrustum, int n) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[3];
        int n2 = this.terrainData.hasTexture() ? 1 : 0;
        switch (n2 += this.terrainData.hasColor() ? 2 : 0) {
            case 0: {
                this.terrainData.getCoordinate(fArray, this.leftX, this.leftY);
                break;
            }
            case 1: {
                this.terrainData.getCoordinateWithTexture(fArray, fArray2, this.leftX, this.leftY, this.patchX, this.patchY);
                this.p1tS = fArray2[0];
                this.p1tT = fArray2[1];
                break;
            }
            case 2: {
                this.terrainData.getCoordinateWithColor(fArray, fArray3, this.leftX, this.leftY);
                this.p1R = fArray3[0];
                this.p1G = fArray3[1];
                this.p1B = fArray3[2];
                break;
            }
            case 3: {
                this.terrainData.getCoordinate(fArray, fArray2, fArray3, this.leftX, this.leftY);
                this.p1tS = fArray2[0];
                this.p1tT = fArray2[1];
                this.p1R = fArray3[0];
                this.p1G = fArray3[1];
                this.p1B = fArray3[2];
            }
        }
        this.p1X = fArray[0];
        this.p1Y = fArray[1];
        this.p1Z = fArray[2];
        switch (n2) {
            case 0: {
                this.terrainData.getCoordinate(fArray, this.rightX, this.rightY);
                break;
            }
            case 1: {
                this.terrainData.getCoordinateWithTexture(fArray, fArray2, this.rightX, this.rightY, this.patchX, this.patchY);
                this.p2tS = fArray2[0];
                this.p2tT = fArray2[1];
                break;
            }
            case 2: {
                this.terrainData.getCoordinateWithColor(fArray, fArray3, this.rightX, this.rightY);
                this.p2R = fArray3[0];
                this.p2G = fArray3[1];
                this.p2B = fArray3[2];
                break;
            }
            case 3: {
                this.terrainData.getCoordinate(fArray, fArray2, fArray3, this.rightX, this.rightY);
                this.p2tS = fArray2[0];
                this.p2tT = fArray2[1];
                this.p2R = fArray3[0];
                this.p2G = fArray3[1];
                this.p2B = fArray3[2];
            }
        }
        this.p2X = fArray[0];
        this.p2Y = fArray[1];
        this.p2Z = fArray[2];
        switch (n2) {
            case 0: {
                this.terrainData.getCoordinate(fArray, this.apexX, this.apexY);
                break;
            }
            case 1: {
                this.terrainData.getCoordinateWithTexture(fArray, fArray2, this.apexX, this.apexY, this.patchX, this.patchY);
                this.p3tS = fArray2[0];
                this.p3tT = fArray2[1];
                break;
            }
            case 2: {
                this.terrainData.getCoordinateWithColor(fArray, fArray3, this.apexX, this.apexY);
                this.p3R = fArray3[0];
                this.p3G = fArray3[1];
                this.p3B = fArray3[2];
                break;
            }
            case 3: {
                this.terrainData.getCoordinate(fArray, fArray2, fArray3, this.apexX, this.apexY);
                this.p3tS = fArray2[0];
                this.p3tT = fArray2[1];
                this.p3R = fArray3[0];
                this.p3G = fArray3[1];
                this.p3B = fArray3[2];
            }
        }
        this.p3X = fArray[0];
        this.p3Y = fArray[1];
        this.p3Z = fArray[2];
        this.visible = n == -1 || n == 4 ? viewFrustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z) : n;
        this.variance = 0.0f;
    }

    private int internalMerge(QueueManager queueManager) {
        TreeNode treeNode = this.leftChild.baseNeighbour;
        TreeNode treeNode2 = this.rightChild.baseNeighbour;
        this.leftNeighbour = treeNode;
        this.rightNeighbour = treeNode2;
        if (treeNode != null) {
            if (treeNode.baseNeighbour == this.leftChild) {
                treeNode.baseNeighbour = this;
            } else if (treeNode.leftNeighbour == this.leftChild) {
                treeNode.leftNeighbour = this;
            } else {
                treeNode.rightNeighbour = this;
            }
        }
        if (treeNode2 != null) {
            if (treeNode2.baseNeighbour == this.rightChild) {
                treeNode2.baseNeighbour = this;
            } else if (treeNode2.rightNeighbour == this.rightChild) {
                treeNode2.rightNeighbour = this;
            } else {
                treeNode2.leftNeighbour = this;
            }
        }
        queueManager.removeTriangle(this.leftChild);
        queueManager.removeTriangle(this.rightChild);
        this.leftChild.freeNode();
        this.rightChild.freeNode();
        this.leftChild = null;
        this.rightChild = null;
        this.diamond = true;
        return 2;
    }

    private boolean isDiamond(TreeNode treeNode) {
        return treeNode.isDiamond() && treeNode.baseNeighbour.isDiamond();
    }

    private boolean isDiamond() {
        this.diamond = this.baseNeighbour == null ? false : this.baseNeighbour.baseNeighbour == this && this.leftChild != null && this.baseNeighbour.leftChild != null && this.leftChild.leftChild == null && this.rightChild.leftChild == null && this.baseNeighbour.leftChild.leftChild == null && this.baseNeighbour.rightChild.leftChild == null;
        return this.diamond;
    }

    private void initChildren(ViewFrustum viewFrustum) {
        int n = this.leftX + this.rightX >> 1;
        int n2 = this.leftY + this.rightY >> 1;
        this.leftChild = TreeNode.getTreeNode();
        this.rightChild = TreeNode.getTreeNode();
        this.leftChild.newNode(this.apexX, this.apexY, this.leftX, this.leftY, n, n2, this.node << 1, this.terrainData, viewFrustum, this.visible, this.depth + 1, this.varianceTree, this.patchX, this.patchY);
        this.rightChild.newNode(this.rightX, this.rightY, this.apexX, this.apexY, n, n2, 1 + (this.node << 1), this.terrainData, viewFrustum, this.visible, this.depth + 1, this.varianceTree, this.patchX, this.patchY);
        this.leftChild.parent = this;
        this.rightChild.parent = this;
    }
}

