/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.texture;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import org.j3d.texture.TextureCache;
import org.j3d.util.ImageUtils;

public abstract class AbstractTextureCache
implements TextureCache {
    private static final Class[] CLASS_TYPES = new Class[]{class$java$awt$image$ImageProducer == null ? (class$java$awt$image$ImageProducer = AbstractTextureCache.class$("java.awt.image.ImageProducer")) : class$java$awt$image$ImageProducer, class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = AbstractTextureCache.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage, class$java$awt$Image == null ? (class$java$awt$Image = AbstractTextureCache.class$("java.awt.Image")) : class$java$awt$Image};
    static /* synthetic */ Class class$java$awt$image$ImageProducer;
    static /* synthetic */ Class class$java$awt$image$BufferedImage;
    static /* synthetic */ Class class$java$awt$Image;

    protected AbstractTextureCache() {
    }

    protected int getTextureFormat(ImageComponent imageComponent) {
        int n = 6;
        switch (imageComponent.getFormat()) {
            case 10: {
                n = 2;
                break;
            }
            case 7: 
            case 8: {
                n = 4;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                n = 5;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n = 6;
            }
        }
        return n;
    }

    protected ImageComponent2D load2DImage(String string) throws IOException {
        URL uRL;
        File file = new File(string);
        if (file.exists()) {
            uRL = file.toURL();
        } else {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            uRL = classLoader.getResource(string);
            if (uRL == null) {
                throw new FileNotFoundException("Couldn't find " + string);
            }
        }
        return this.load2DImage(uRL);
    }

    protected ImageComponent2D load2DImage(URL uRL) throws IOException {
        Object object = uRL.getContent(CLASS_TYPES);
        if (object == null) {
            throw new FileNotFoundException("No content for " + uRL);
        }
        BufferedImage bufferedImage = null;
        bufferedImage = object instanceof ImageProducer ? ImageUtils.createBufferedImage((ImageProducer)object) : (object instanceof BufferedImage ? (BufferedImage)object : ImageUtils.createBufferedImage((Image)object));
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.hasAlpha();
        int n = 2;
        switch (bufferedImage.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 12: {
                n = 1;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n = 2;
                break;
            }
            case 10: 
            case 11: {
                n = 10;
                break;
            }
            case 13: {
                if (bl) {
                    n = 2;
                    break;
                }
                n = 1;
                break;
            }
            case 9: {
                n = 3;
                break;
            }
            case 8: {
                n = 3;
            }
        }
        ImageComponent2D imageComponent2D = new ImageComponent2D(n, bufferedImage, true, false);
        return imageComponent2D;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

