/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.texture;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;
import org.j3d.texture.AbstractTextureCache;

class FixedTextureCache
extends AbstractTextureCache {
    private HashMap textureMap = new HashMap();
    private HashMap componentMap = new HashMap();

    FixedTextureCache() {
    }

    public Texture fetchTexture(String string) throws IOException {
        Object object = (Texture)this.textureMap.get(string);
        if (object == null) {
            ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
            if (imageComponent == null) {
                imageComponent = this.load2DImage(string);
                this.componentMap.put(string, imageComponent);
            }
            int n = this.getTextureFormat(imageComponent);
            object = imageComponent instanceof ImageComponent2D ? new Texture2D(1, n, imageComponent.getWidth(), imageComponent.getHeight()) : new Texture3D(1, n, imageComponent.getWidth(), imageComponent.getHeight(), ((ImageComponent3D)imageComponent).getDepth());
            object.setImage(0, imageComponent);
            this.textureMap.put(string, object);
        }
        return object;
    }

    public Texture fetchTexture(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        Object object = (Texture)this.textureMap.get(string);
        if (object == null) {
            ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
            if (imageComponent == null) {
                imageComponent = this.load2DImage(string);
                this.componentMap.put(string, imageComponent);
            }
            int n = this.getTextureFormat(imageComponent);
            object = imageComponent instanceof ImageComponent2D ? new Texture2D(1, n, imageComponent.getWidth(), imageComponent.getHeight()) : new Texture3D(1, n, imageComponent.getWidth(), imageComponent.getHeight(), ((ImageComponent3D)imageComponent).getDepth());
            object.setImage(0, imageComponent);
            this.textureMap.put(string, object);
        }
        return object;
    }

    public ImageComponent fetchImageComponent(String string) throws IOException {
        ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
        if (imageComponent == null) {
            imageComponent = this.load2DImage(string);
            this.componentMap.put(string, imageComponent);
        }
        return imageComponent;
    }

    public ImageComponent fetchImageComponent(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
        if (imageComponent == null) {
            imageComponent = this.load2DImage(string);
            this.componentMap.put(string, imageComponent);
        }
        return imageComponent;
    }

    public void releaseTexture(String string) {
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void releaseTexture(URL uRL) {
        String string = uRL.toExternalForm();
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void clearAll() {
        this.textureMap.clear();
        this.componentMap.clear();
    }

    public boolean checkTexture(String string) {
        return this.textureMap.containsKey(string);
    }

    public boolean checkImageComponent(String string) {
        return this.componentMap.containsKey(string);
    }

    public void registerTexture(Texture texture, String string) {
        this.textureMap.put(string, texture);
        try {
            ImageComponent imageComponent = texture.getImage(0);
            this.componentMap.put(string, imageComponent);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {}
    }

    public void registerImageComponent(ImageComponent imageComponent, String string) {
        this.componentMap.put(string, imageComponent);
    }
}

