/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.texture;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;
import org.j3d.texture.AbstractTextureCache;

class WeakRefTextureCache
extends AbstractTextureCache {
    private HashMap textureMap = new HashMap();
    private HashMap componentMap = new HashMap();

    WeakRefTextureCache() {
    }

    public Texture fetchTexture(String string) throws IOException {
        Object object = this.getTexture(string);
        if (object == null) {
            WeakReference<ImageComponent> weakReference;
            ImageComponent imageComponent = this.getImageComponent(string);
            if (imageComponent == null) {
                imageComponent = this.load2DImage(string);
                weakReference = new WeakReference<ImageComponent>(imageComponent);
                this.componentMap.put(string, weakReference);
            }
            int n = this.getTextureFormat(imageComponent);
            object = imageComponent instanceof ImageComponent2D ? new Texture2D(1, n, imageComponent.getWidth(), imageComponent.getHeight()) : new Texture3D(1, n, imageComponent.getWidth(), imageComponent.getHeight(), ((ImageComponent3D)imageComponent).getDepth());
            object.setImage(0, imageComponent);
            weakReference = new WeakReference<Texture>((Texture)object);
            this.textureMap.put(string, weakReference);
        }
        return object;
    }

    public Texture fetchTexture(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        Object object = this.getTexture(string);
        if (object == null) {
            WeakReference<ImageComponent> weakReference;
            ImageComponent imageComponent = this.getImageComponent(string);
            if (imageComponent == null) {
                imageComponent = this.load2DImage(string);
                weakReference = new WeakReference<ImageComponent>(imageComponent);
                this.componentMap.put(string, weakReference);
            }
            int n = this.getTextureFormat(imageComponent);
            object = imageComponent instanceof ImageComponent2D ? new Texture2D(1, n, imageComponent.getWidth(), imageComponent.getHeight()) : new Texture3D(1, n, imageComponent.getWidth(), imageComponent.getHeight(), ((ImageComponent3D)imageComponent).getDepth());
            object.setImage(0, imageComponent);
            weakReference = new WeakReference<Texture>((Texture)object);
            this.textureMap.put(string, weakReference);
        }
        return object;
    }

    public ImageComponent fetchImageComponent(String string) throws IOException {
        ImageComponent imageComponent = this.getImageComponent(string);
        if (imageComponent == null) {
            imageComponent = this.load2DImage(string);
            WeakReference<ImageComponent> weakReference = new WeakReference<ImageComponent>(imageComponent);
            this.componentMap.put(string, weakReference);
        }
        return imageComponent;
    }

    public ImageComponent fetchImageComponent(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        ImageComponent imageComponent = this.getImageComponent(string);
        if (imageComponent == null) {
            imageComponent = this.load2DImage(string);
            WeakReference<ImageComponent> weakReference = new WeakReference<ImageComponent>(imageComponent);
            this.componentMap.put(string, weakReference);
        }
        return imageComponent;
    }

    public void releaseTexture(String string) {
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void releaseTexture(URL uRL) {
        String string = uRL.toExternalForm();
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void clearAll() {
        this.textureMap.clear();
        this.componentMap.clear();
    }

    public boolean checkTexture(String string) {
        return this.textureMap.containsKey(string);
    }

    public boolean checkImageComponent(String string) {
        return this.componentMap.containsKey(string);
    }

    public void registerTexture(Texture texture, String string) {
        WeakReference<Texture> weakReference = new WeakReference<Texture>(texture);
        this.textureMap.put(string, weakReference);
        try {
            ImageComponent imageComponent = texture.getImage(0);
            weakReference = new WeakReference<ImageComponent>(imageComponent);
            this.componentMap.put(string, weakReference);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {}
    }

    public void registerImageComponent(ImageComponent imageComponent, String string) {
        WeakReference<ImageComponent> weakReference = new WeakReference<ImageComponent>(imageComponent);
        this.componentMap.put(string, weakReference);
    }

    private Texture getTexture(String string) {
        WeakReference weakReference = (WeakReference)this.textureMap.get(string);
        if (weakReference == null) {
            return null;
        }
        Texture texture = (Texture)weakReference.get();
        if (texture == null) {
            this.textureMap.remove(string);
        }
        return texture;
    }

    private ImageComponent getImageComponent(String string) {
        WeakReference weakReference = (WeakReference)this.componentMap.get(string);
        if (weakReference == null) {
            return null;
        }
        ImageComponent imageComponent = (ImageComponent)weakReference.get();
        if (imageComponent == null) {
            this.componentMap.remove(string);
        }
        return imageComponent;
    }
}

