/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.navigation;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Point3d;
import org.j3d.ui.navigation.CollisionListener;
import org.j3d.ui.navigation.FrameUpdateListener;
import org.j3d.ui.navigation.NavigationHandler;
import org.j3d.ui.navigation.NavigationStateListener;

public class MouseViewBehavior
extends Behavior {
    private WakeupOnAWTEvent criteria;
    private NavigationHandler inputHandler;

    public MouseViewBehavior() {
        this(null);
    }

    public MouseViewBehavior(NavigationHandler navigationHandler) {
        long l = 48L;
        this.criteria = new WakeupOnAWTEvent(l);
        this.inputHandler = navigationHandler != null ? navigationHandler : new NavigationHandler();
        Point3d point3d = new Point3d();
        BoundingSphere boundingSphere = new BoundingSphere(point3d, Double.POSITIVE_INFINITY);
        this.setSchedulingBounds((Bounds)boundingSphere);
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.criteria);
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            int n;
            WakeupOnAWTEvent wakeupOnAWTEvent;
            AWTEvent[] aWTEventArray;
            Object e = enumeration.nextElement();
            if (!(e instanceof WakeupOnAWTEvent) || !((aWTEventArray = (wakeupOnAWTEvent = (WakeupOnAWTEvent)e).getAWTEvent())[n = aWTEventArray.length - 1] instanceof MouseEvent)) continue;
            MouseEvent mouseEvent = (MouseEvent)aWTEventArray[n];
            int n2 = mouseEvent.getID();
            switch (n2) {
                case 501: {
                    this.inputHandler.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.inputHandler.mouseReleased(mouseEvent);
                    break;
                }
                case 506: {
                    this.inputHandler.mouseDragged(mouseEvent);
                    break;
                }
            }
        }
        this.wakeupOn((WakeupCondition)this.criteria);
    }

    public NavigationHandler getNavigationHandler() {
        return this.inputHandler;
    }

    public void setWorldInfo(BranchGroup branchGroup, BranchGroup branchGroup2) {
        this.inputHandler.setWorldInfo(branchGroup, branchGroup2);
    }

    public void setAvatarInfo(float f, float f2, float f3) {
        this.inputHandler.setAvatarInfo(f, f2, f3);
    }

    public void setNavigationSpeed(float f) {
        this.inputHandler.setNavigationSpeed(f);
    }

    public void setButtonNavigation(int n, int n2) {
        this.inputHandler.setButtonNavigation(n, n2);
    }

    public void setViewInfo(View view, TransformGroup transformGroup) {
        this.inputHandler.setViewInfo(view, transformGroup);
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.inputHandler.setFrameUpdateListener(frameUpdateListener);
    }

    public void setCollisionListener(CollisionListener collisionListener) {
        this.inputHandler.setCollisionListener(collisionListener);
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.inputHandler.setNavigationStateListener(navigationStateListener);
    }
}

