/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

public class CharHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public CharHashMap() {
        this(20, 0.75f);
    }

    public CharHashMap(int n) {
        this(n, 0.75f);
    }

    public CharHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(char c) {
        Entry[] entryArray = this.table;
        char c2 = c;
        int n = (c2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.hash == c2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(char c) {
        Entry[] entryArray = this.table;
        char c2 = c;
        int n = (c2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.hash == c2) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(char c, Object object) {
        Entry entry;
        Entry[] entryArray = this.table;
        char c2 = c;
        int n = (c2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry2 = entryArray[n];
        while (entry2 != null) {
            if (entry2.hash == c2) {
                Object object2 = entry2.value;
                entry2.value = object;
                return object2;
            }
            entry2 = entry2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n = (c2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n] = entry = new Entry(c2, c, object, entryArray[n]);
        ++this.count;
        return null;
    }

    public Object remove(char c) {
        Entry[] entryArray = this.table;
        char c2 = c;
        int n = (c2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == c2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                entry.value = null;
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private static class Entry {
        int hash;
        char key;
        Object value;
        Entry next;

        protected Entry(int n, char c, Object object, Entry entry) {
            this.hash = n;
            this.key = c;
            this.value = object;
            this.next = entry;
        }
    }
}

