/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class HashSet {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public HashSet() {
        this(20, 0.75f);
    }

    public HashSet(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public HashSet(int n) {
        this(n, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        int n = object.hashCode();
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && (object == entry.value || object.equals(entry.value))) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean add(Object object) {
        Entry entry;
        if (object == null) {
            return false;
        }
        int n = object.hashCode();
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry2 = entryArray[n2];
        while (entry2 != null) {
            if (entry2.hash == n && (object == entry2.value || object.equals(entry2.value))) {
                return false;
            }
            entry2 = entry2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, entryArray[n2]);
        ++this.count;
        return true;
    }

    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && (object == entry.value || object.equals(entry.value))) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                entry.value = null;
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean addAll(HashSet hashSet) {
        boolean bl = false;
        Entry[] entryArray = hashSet.table;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (this.add(entry.value)) {
                    bl = true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.remove(e)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(HashSet hashSet) {
        boolean bl = false;
        Entry[] entryArray = hashSet.table;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (this.remove(entry.value)) {
                    bl = true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return bl;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.count];
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            Entry entry = this.table[n2];
            while (entry != null) {
                objectArray[n++] = entry.value;
                entry = entry.next;
            }
            ++n2;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.count;
        if (objectArray.length < n) {
            Class<?> clazz = objectArray.getClass();
            objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.table.length) {
            Entry entry = this.table[n3];
            while (entry != null) {
                objectArray[n2++] = entry.value;
                entry = entry.next;
            }
            ++n3;
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HashSet)) {
            return false;
        }
        HashSet hashSet = (HashSet)object;
        if (hashSet.size() != this.size()) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                if (!hashSet.contains(entry.value)) {
                    bl = false;
                    break;
                }
                entry = entry.next;
            }
            ++n;
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            Entry entry = this.table[n2];
            while (entry != null) {
                n += entry.value.hashCode();
                entry = entry.next;
            }
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            Entry entry = this.table[n2];
            while (entry != null) {
                stringBuffer.append(entry.value);
                if (++n < this.count) {
                    stringBuffer.append(", ");
                }
                entry = entry.next;
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    private static class Entry {
        int hash;
        Object value;
        Entry next;

        protected Entry(int n, Object object, Entry entry) {
            this.hash = n;
            this.value = object;
            this.next = entry;
        }
    }
}

