/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

public class ObjectArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private Object[] array;

    public ObjectArray() {
        this(512);
    }

    public ObjectArray(int n) {
        this.array = new Object[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        int n = 0;
        while (n < this.valueCount) {
            this.array[n] = null;
            ++n;
        }
        this.valueCount = 0;
    }

    public void add(Object object) {
        if (this.valueCount == this.array.length) {
            Object[] objectArray = new Object[this.array.length + 256];
            System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
            this.array = objectArray;
        }
        this.array[this.valueCount++] = object;
    }

    public void add(Object[] objectArray) {
        int n = this.valueCount + objectArray.length;
        if (n >= this.array.length) {
            Object[] objectArray2 = new Object[n];
            System.arraycopy(this.array, 0, objectArray2, 0, this.array.length);
            this.array = objectArray2;
        }
        System.arraycopy(objectArray, 0, this.array, this.valueCount, objectArray.length);
        this.valueCount = n;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, Object object) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = object;
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return object;
    }

    public Object remove(Object object) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.valueCount && n != -1) {
            if (this.array[n2] == object || this.array[n2].equals(object)) {
                // empty if block
            }
            n = n2++;
        }
        Object object2 = null;
        if (n != -1) {
            object2 = this.remove(n);
        }
        return object2;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.valueCount];
        System.arraycopy(this.array, 0, objectArray, 0, this.valueCount);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = null;
        objectArray2 = objectArray.length >= this.valueCount ? objectArray : new Object[this.valueCount];
        System.arraycopy(this.array, 0, objectArray2, 0, this.valueCount);
        return objectArray2;
    }
}

