/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import org.j3d.util.interpolator.Interpolator;

public class IntegerInterpolator
extends Interpolator {
    private int[] keyValues;

    public IntegerInterpolator() {
        this(20, 1);
    }

    public IntegerInterpolator(int n) {
        this(n, 1);
    }

    public IntegerInterpolator(int n, int n2) {
        super(n, n2);
        this.keyValues = new int[n];
    }

    public void addKeyFrame(float f, int n) {
        int n2 = this.findKeyIndex(f);
        if (n2 < 0) {
            n2 = 0;
        }
        while (n2 < this.currentSize && this.keys[n2] <= f) {
            ++n2;
        }
        this.realloc();
        if (n2 >= this.currentSize) {
            this.keyValues[this.currentSize] = n;
        } else {
            int n3 = this.currentSize - n2;
            System.arraycopy(this.keyValues, n2, this.keyValues, n2 + 1, n3);
            System.arraycopy(this.keys, n2, this.keys, n2 + 1, n3);
            this.keyValues[n2] = n;
        }
        this.keys[n2] = f;
        ++this.currentSize;
    }

    public int intValue(float f) {
        int n;
        int n2 = this.findKeyIndex(f);
        if (n2 < 0) {
            n = this.keyValues[0];
        } else if (n2 >= this.currentSize - 1) {
            n = this.keyValues[this.currentSize - 1];
        } else {
            switch (this.interpolationType) {
                case 1: {
                    int n3 = this.keyValues[n2 + 1];
                    int n4 = this.keyValues[n2];
                    float f2 = 0.0f;
                    float f3 = this.keys[n2];
                    float f4 = this.keys[n2 + 1];
                    if (f4 != f3) {
                        f2 = (f - f3) / (f4 - f3);
                    }
                    if ((double)f2 <= 0.5) {
                        n = n4;
                        break;
                    }
                    n = n3;
                    break;
                }
                case 2: {
                    n = this.keyValues[n2];
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            int[] nArray = new int[n];
            System.arraycopy(this.keyValues, 0, nArray, 0, this.allocatedSize);
            float[] fArray = new float[n];
            System.arraycopy(this.keys, 0, fArray, 0, this.allocatedSize);
            this.keys = fArray;
            this.keyValues = nArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<integer interpolator>\n");
        int n = 0;
        while (n < this.currentSize) {
            stringBuffer.append(n);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[n]);
            stringBuffer.append(" value: ");
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("</integer interpolator>");
        return stringBuffer.toString();
    }
}

