/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xerces.dom3.DOMImplementationSource;
import org.w3c.dom.DOMImplementation;

public class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private Hashtable sources;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$xerces$dom3$DOMImplementationRegistry;

    private DOMImplementationRegistry() {
    }

    private DOMImplementationRegistry(Hashtable srcs) {
        this.sources = srcs;
    }

    public static DOMImplementationRegistry newInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Hashtable sources = new Hashtable();
        String p = System.getProperty(PROPERTY);
        if (p != null) {
            StringTokenizer st = new StringTokenizer(p);
            while (st.hasMoreTokens()) {
                String sourceName = st.nextToken();
                Object source = DOMImplementationRegistry.getClass(sourceName).newInstance();
                sources.put(sourceName, source);
            }
        }
        return new DOMImplementationRegistry(sources);
    }

    public void addSource(DOMImplementationSource s) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String sourceName = s.getClass().getName();
        this.sources.put(sourceName, s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static Class getClass(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Method m = null;
        ClassLoader cl = null;
        try {
            m = (class$java$lang$Thread == null ? (class$java$lang$Thread = DOMImplementationRegistry.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            cl = (class$org$apache$xerces$dom3$DOMImplementationRegistry == null ? (class$org$apache$xerces$dom3$DOMImplementationRegistry = DOMImplementationRegistry.class$("org.apache.xerces.dom3.DOMImplementationRegistry")) : class$org$apache$xerces$dom3$DOMImplementationRegistry).getClassLoader();
        }
        if (cl == null) {
            try {
                cl = (ClassLoader)m.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException e) {
                throw new UnknownError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new UnknownError(e.getMessage());
            }
        }
        if (cl == null) {
            return Class.forName(className);
        }
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(className);
        }
    }

    public DOMImplementation getDOMImplementation(String features) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        Enumeration names = this.sources.keys();
        String name = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            DOMImplementationSource source = (DOMImplementationSource)this.sources.get(name);
            DOMImplementation impl = source.getDOMImplementation(features);
            if (impl == null) continue;
            return impl;
        }
        return null;
    }
}

