/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.io.UCSReader;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;

public class XMLEntityScanner
implements XMLLocator {
    private static final boolean DEBUG_ENCODINGS = false;
    private static final boolean DEBUG_BUFFER = false;
    private XMLEntityManager fEntityManager = null;
    protected XMLEntityManager.ScannedEntity fCurrentEntity = null;
    protected SymbolTable fSymbolTable = null;
    protected int fBufferSize = 2048;

    public int getColumnNumber() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.columnNumber;
            }
            return this.fCurrentEntity.getColumnNumber();
        }
        return -1;
    }

    public int getLineNumber() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.lineNumber;
            }
            return this.fCurrentEntity.getLineNumber();
        }
        return -1;
    }

    public int peekChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (this.fCurrentEntity.isExternal()) {
            return c != 13 ? c : 10;
        }
        return c;
    }

    public int scanChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int c = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
        boolean external = false;
        if (c == 10 || c == 13 && (external = this.fCurrentEntity.isExternal())) {
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = (char)c;
                this.load(1, false);
            }
            if (c == 13 && external) {
                if (this.fCurrentEntity.ch[this.fCurrentEntity.position++] != '\n') {
                    --this.fCurrentEntity.position;
                }
                c = 10;
            }
        }
        ++this.fCurrentEntity.columnNumber;
        return c;
    }

    public boolean isExternal() {
        return this.fCurrentEntity.isExternal();
    }

    public boolean skipSpaces() throws IOException {
        char c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
            boolean external = this.fCurrentEntity.isExternal();
            do {
                boolean entityChanged = false;
                if (c == '\n' || external && c == '\r') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.fCurrentEntity.ch[0] = c;
                        entityChanged = this.load(1, true);
                        if (!entityChanged) {
                            this.fCurrentEntity.position = 0;
                        }
                    }
                    if (c == '\r' && external && this.fCurrentEntity.ch[++this.fCurrentEntity.position] != '\n') {
                        --this.fCurrentEntity.position;
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!entityChanged) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.load(0, true);
            } while (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position]));
            return true;
        }
        return false;
    }

    public void setBufferSize(int size) {
        this.fBufferSize = size;
    }

    public void setColumnNumber(int col) {
    }

    public void setLineNumber(int line) {
    }

    public boolean skipChar(int c) throws IOException {
        char cc;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if ((cc = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == c) {
            ++this.fCurrentEntity.position;
            if (c == 10) {
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
            } else {
                ++this.fCurrentEntity.columnNumber;
            }
            return true;
        }
        if (c == 10 && cc == '\r' && this.fCurrentEntity.isExternal()) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = cc;
                this.load(1, false);
            }
            ++this.fCurrentEntity.position;
            if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                ++this.fCurrentEntity.position;
            }
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            return true;
        }
        return false;
    }

    final boolean load(int offset, boolean changeEntity) throws IOException {
        int length = this.fCurrentEntity.mayReadChunks ? this.fCurrentEntity.ch.length - offset : 64;
        int count = this.fCurrentEntity.reader.read(this.fCurrentEntity.ch, offset, length);
        boolean entityChanged = false;
        if (count != -1) {
            if (count != 0) {
                this.fCurrentEntity.count = count + offset;
                this.fCurrentEntity.position = offset;
            }
        } else {
            this.fCurrentEntity.count = offset;
            this.fCurrentEntity.position = offset;
            entityChanged = true;
            if (changeEntity) {
                this.fEntityManager.endEntity();
                if (this.fCurrentEntity == null) {
                    throw new EOFException();
                }
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    this.load(0, true);
                }
            }
        }
        return entityChanged;
    }

    public String getBaseSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getExpandedSystemId() : null;
    }

    public String getExpandedSystemId() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.entityLocation != null && this.fCurrentEntity.entityLocation.getExpandedSystemId() != null) {
                return this.fCurrentEntity.entityLocation.getExpandedSystemId();
            }
            return this.fCurrentEntity.getExpandedSystemId();
        }
        return null;
    }

    public String getLiteralSystemId() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.entityLocation != null && this.fCurrentEntity.entityLocation.getLiteralSystemId() != null) {
                return this.fCurrentEntity.entityLocation.getLiteralSystemId();
            }
            return this.fCurrentEntity.getLiteralSystemId();
        }
        return null;
    }

    public String getPublicId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getPublicId() : null;
    }

    /*
     * Unable to fully structure code
     */
    public String scanName() throws IOException {
        block5: {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.load(0, true);
            }
            if (!XMLChar.isNameStart(this.fCurrentEntity.ch[offset = this.fCurrentEntity.position++])) break block5;
            if (this.fCurrentEntity.position != this.fCurrentEntity.count) ** GOTO lbl23
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[offset];
            offset = 0;
            if (!this.load(1, false)) ** GOTO lbl23
            ++this.fCurrentEntity.columnNumber;
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
            return symbol;
lbl-1000:
            // 1 sources

            {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                length = this.fCurrentEntity.position - offset;
                if (length == this.fBufferSize) {
                    tmp = new char[this.fBufferSize * 2];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                    this.fBufferSize *= 2;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (this.load(length, false)) break;
lbl23:
                // 4 sources

                ** while (XMLChar.isName((int)this.fCurrentEntity.ch[this.fCurrentEntity.position]))
            }
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        symbol = null;
        if (length > 0) {
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
        }
        return symbol;
    }

    public String scanNmtoken() throws IOException {
        int length;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int offset = this.fCurrentEntity.position;
        while (XMLChar.isName(this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            length = this.fCurrentEntity.position - offset;
            if (length == this.fBufferSize) {
                char[] tmp = new char[this.fBufferSize * 2];
                System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                this.fCurrentEntity.ch = tmp;
                this.fBufferSize *= 2;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
            }
            offset = 0;
            if (this.load(length, false)) break;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        String symbol = null;
        if (length > 0) {
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
        }
        return symbol;
    }

    public void setBaseSystemId(String systemId) {
    }

    public void setEncoding(String encoding) throws IOException {
        if (!(this.fCurrentEntity.stream == null || this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.equals(encoding))) {
            if (this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.startsWith("UTF-16")) {
                String ENCODING = encoding.toUpperCase(Locale.ENGLISH);
                if (ENCODING.equals("UTF-16")) {
                    return;
                }
                if (ENCODING.equals("ISO-10646-UCS-4")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 8) : new UCSReader(this.fCurrentEntity.stream, 4);
                    return;
                }
                if (ENCODING.equals("ISO-10646-UCS-2")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 2) : new UCSReader(this.fCurrentEntity.stream, 1);
                    return;
                }
            }
            this.fCurrentEntity.setReader(this.fCurrentEntity.stream, encoding, null);
        }
    }

    public void setExpandedSystemId(String systemId) {
    }

    public void setLiteralSystemId(String systemId) {
    }

    public void setPublicId(String publicId) {
    }

    public boolean skipString(String s) throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c;
            if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != s.charAt(i)) {
                this.fCurrentEntity.position -= i + 1;
                return false;
            }
            if (i < length - 1 && this.fCurrentEntity.position == this.fCurrentEntity.count) {
                System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.count - i - 1, this.fCurrentEntity.ch, 0, i + 1);
                if (this.load(i + 1, false)) {
                    this.fCurrentEntity.position -= i + 1;
                    return false;
                }
            }
            ++i;
        }
        this.fCurrentEntity.columnNumber += length;
        return true;
    }

    public void setCurrentEntity(XMLEntityManager.ScannedEntity ent) {
        this.fCurrentEntity = ent;
    }

    public boolean scanQName(QName qname) throws IOException {
        int offset;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isNameStart(this.fCurrentEntity.ch[offset = this.fCurrentEntity.position++])) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[offset];
                offset = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String name = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    qname.setValues(null, name, name, null);
                    return true;
                }
            }
            int index = -1;
            while (XMLChar.isName(this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                char c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
                if (c == ':') {
                    if (index != -1) break;
                    index = this.fCurrentEntity.position;
                }
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                int length = this.fCurrentEntity.position - offset;
                if (length == this.fBufferSize) {
                    char[] tmp = new char[this.fBufferSize * 2];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                    this.fBufferSize *= 2;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                if (index != -1) {
                    index -= offset;
                }
                offset = 0;
                if (this.load(length, false)) break;
            }
            int length = this.fCurrentEntity.position - offset;
            this.fCurrentEntity.columnNumber += length;
            if (length > 0) {
                String prefix = null;
                String localpart = null;
                String rawname = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
                if (index != -1) {
                    int prefixLength = index - offset;
                    prefix = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, prefixLength);
                    int len = length - prefixLength - 1;
                    localpart = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, index + 1, len);
                } else {
                    localpart = rawname;
                }
                qname.setValues(prefix, localpart, rawname, null);
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public int scanLiteral(int quote, XMLString content) throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
        }
        offset = this.fCurrentEntity.position;
        c = this.fCurrentEntity.ch[offset];
        newlines = 0;
        external = this.fCurrentEntity.isExternal();
        if (c != 10 && (c != 13 || !external)) ** GOTO lbl54
        do {
            if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && external) {
                ++newlines;
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    offset = 0;
                    this.fCurrentEntity.position = newlines;
                    if (this.load(newlines, false)) break;
                }
                if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                    ++this.fCurrentEntity.position;
                    ++offset;
                    continue;
                }
                ++newlines;
                continue;
            }
            if (c == 10) {
                ++newlines;
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                offset = 0;
                this.fCurrentEntity.position = newlines;
                if (!this.load(newlines, false)) continue;
                break;
            }
            --this.fCurrentEntity.position;
            break;
        } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
        i = offset;
        while (i < this.fCurrentEntity.position) {
            this.fCurrentEntity.ch[i] = 10;
            ++i;
        }
        length = this.fCurrentEntity.position - offset;
        if (this.fCurrentEntity.position != this.fCurrentEntity.count - 1) ** GOTO lbl54
        content.setValues(this.fCurrentEntity.ch, offset, length);
        return -1;
lbl-1000:
        // 1 sources

        {
            if (((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != quote || this.fCurrentEntity.literal && !external) && c != 37 && XMLChar.isContent(c)) continue;
            --this.fCurrentEntity.position;
            break;
lbl54:
            // 3 sources

            ** while (this.fCurrentEntity.position < this.fCurrentEntity.count)
        }
lbl55:
        // 2 sources

        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newlines;
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (c == quote && this.fCurrentEntity.literal) {
                c = -1;
            }
        } else {
            c = -1;
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    public int scanContent(XMLString content) throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
        }
        offset = this.fCurrentEntity.position;
        c = this.fCurrentEntity.ch[offset];
        newlines = 0;
        external = this.fCurrentEntity.isExternal();
        if (c != 10 && (c != 13 || !external)) ** GOTO lbl54
        do {
            if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && external) {
                ++newlines;
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    offset = 0;
                    this.fCurrentEntity.position = newlines;
                    if (this.load(newlines, false)) break;
                }
                if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                    ++this.fCurrentEntity.position;
                    ++offset;
                    continue;
                }
                ++newlines;
                continue;
            }
            if (c == 10) {
                ++newlines;
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                offset = 0;
                this.fCurrentEntity.position = newlines;
                if (!this.load(newlines, false)) continue;
                break;
            }
            --this.fCurrentEntity.position;
            break;
        } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
        i = offset;
        while (i < this.fCurrentEntity.position) {
            this.fCurrentEntity.ch[i] = 10;
            ++i;
        }
        length = this.fCurrentEntity.position - offset;
        if (this.fCurrentEntity.position != this.fCurrentEntity.count - 1) ** GOTO lbl54
        content.setValues(this.fCurrentEntity.ch, offset, length);
        return -1;
lbl-1000:
        // 1 sources

        {
            if (XMLChar.isContent(c = this.fCurrentEntity.ch[this.fCurrentEntity.position++])) continue;
            --this.fCurrentEntity.position;
            break;
lbl54:
            // 3 sources

            ** while (this.fCurrentEntity.position < this.fCurrentEntity.count)
        }
lbl55:
        // 2 sources

        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newlines;
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (c == 13 && external) {
                c = 10;
            }
        } else {
            c = -1;
        }
        return c;
    }

    public void reset(SymbolTable symbolTable, XMLEntityManager entityManager) {
        this.fCurrentEntity = null;
        this.fSymbolTable = symbolTable;
        this.fEntityManager = entityManager;
    }

    /*
     * Unable to fully structure code
     */
    public boolean scanData(String delimiter, XMLStringBuffer buffer) throws IOException {
        done = false;
        delimLen = delimiter.length();
        charAt0 = delimiter.charAt(0);
        external = this.fCurrentEntity.isExternal();
        do {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.load(0, true);
            }
            bNextEntity = false;
            while (this.fCurrentEntity.position >= this.fCurrentEntity.count - delimLen && !bNextEntity) {
                System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
                bNextEntity = this.load(this.fCurrentEntity.count - this.fCurrentEntity.position, false);
                this.fCurrentEntity.position = 0;
            }
            if (this.fCurrentEntity.position >= this.fCurrentEntity.count - delimLen) {
                length = this.fCurrentEntity.count - this.fCurrentEntity.position;
                buffer.append(this.fCurrentEntity.ch, this.fCurrentEntity.position, length);
                this.fCurrentEntity.columnNumber += this.fCurrentEntity.count;
                this.fCurrentEntity.position = this.fCurrentEntity.count;
                this.load(0, true);
                return false;
            }
            offset = this.fCurrentEntity.position;
            c = this.fCurrentEntity.ch[offset];
            newlines = 0;
            if (c != '\n' && (c != '\r' || !external)) ** GOTO lbl89
            do {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == '\r' && external) {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        offset = 0;
                        this.fCurrentEntity.position = newlines;
                        if (this.load(newlines, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == '\n') {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    offset = 0;
                    this.fCurrentEntity.position = newlines;
                    this.fCurrentEntity.count = newlines;
                    if (!this.load(newlines, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            i = offset;
            while (i < this.fCurrentEntity.position) {
                this.fCurrentEntity.ch[i] = 10;
                ++i;
            }
            length = this.fCurrentEntity.position - offset;
            if (this.fCurrentEntity.position != this.fCurrentEntity.count - 1) ** GOTO lbl89
            buffer.append(this.fCurrentEntity.ch, offset, length);
            return true;
lbl-1000:
            // 1 sources

            {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == charAt0) {
                    delimOffset = this.fCurrentEntity.position - 1;
                    i = 1;
                    while (i < delimLen) {
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                            this.fCurrentEntity.position -= i;
                            break block4;
                        }
                        c = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
                        if (delimiter.charAt(i) != c) {
                            --this.fCurrentEntity.position;
                            break;
                        }
                        ++i;
                    }
                    if (this.fCurrentEntity.position != delimOffset + delimLen) continue;
                    done = true;
                    break;
                }
                if (c == '\n' || external && c == '\r') {
                    --this.fCurrentEntity.position;
                    break;
                }
                if (!XMLChar.isInvalid(c)) continue;
                --this.fCurrentEntity.position;
                length = this.fCurrentEntity.position - offset;
                this.fCurrentEntity.columnNumber += length - newlines;
                buffer.append(this.fCurrentEntity.ch, offset, length);
                return true;
lbl89:
                // 4 sources

                ** while (this.fCurrentEntity.position < this.fCurrentEntity.count)
            }
lbl90:
            // 4 sources

            length = this.fCurrentEntity.position - offset;
            this.fCurrentEntity.columnNumber += length - newlines;
            if (done) {
                length -= delimLen;
            }
            buffer.append(this.fCurrentEntity.ch, offset, length);
        } while (!done);
        return done == false;
    }
}

