/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.dom;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.dom.DOMNodePool;
import org.apache.xerces.impl.xs.dom.DocumentImpl;
import org.apache.xerces.parsers.NonValidatingConfiguration;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Element;

public class DOMParser
extends org.apache.xerces.parsers.DOMParser {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String DOCUMENT_CLASS = "http://apache.org/xml/properties/dom/document-class-name";
    protected static final String DEFER_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected XMLLocator fLocator;
    public DocumentImpl fDocumentImpl;
    private DOMNodePool fNodePool;
    private int fAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;

    public DOMParser() {
        super(new NonValidatingConfiguration());
        try {
            this.setProperty(DOCUMENT_CLASS, "org.apache.xerces.impl.xs.dom.DocumentImpl");
            this.setFeature(DEFER_EXPANSION, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fNodePool = new DOMNodePool();
    }

    public void resetNodePool() {
        this.fNodePool.reset();
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
        if (this.fAnnotationDepth == this.fDepth) {
            this.fAnnotationDepth = -1;
        }
        --this.fDepth;
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth == -1) {
            int i = text.offset;
            while (i < text.offset + text.length) {
                if (!XMLChar.isSpace(text.ch[i])) {
                    if (this.fErrorReporter == null) {
                        try {
                            this.fErrorReporter = (XMLErrorReporter)this.getProperty(ERROR_REPORTER);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                            XSMessageFormatter xmft = new XSMessageFormatter();
                            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xmft);
                        }
                    }
                    String txt = new String(text.ch, i, text.length + text.offset - i);
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{txt}, (short)1);
                    break;
                }
                ++i;
            }
        } else {
            super.characters(text, augs);
        }
    }

    protected Element createElementNode(QName element) {
        return this.fDocumentImpl.createElementNS(element.uri, element.rawname, element.localpart, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        super.startElement(element, attributes, augs);
        ++this.fDepth;
        if (this.fAnnotationDepth == -1 && element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && (element.localpart == SchemaSymbols.ELT_APPINFO || element.localpart == SchemaSymbols.ELT_DOCUMENTATION)) {
            this.fAnnotationDepth = this.fDepth;
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        this.fDocumentImpl = (DocumentImpl)((org.apache.xerces.parsers.DOMParser)this).fDocumentImpl;
        this.fDocumentImpl.fNodePool = this.fNodePool;
        this.fLocator = locator;
    }
}

