/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDComplexTypeTraverser
extends XSDAbstractParticleTraverser {
    private static final int GLOBAL_NUM = 10;
    private String fName = null;
    private String fTargetNamespace = null;
    private short fDerivedBy = (short)2;
    private short fFinal = 0;
    private short fBlock = 0;
    private short fContentType = 0;
    private XSTypeDefinition fBaseType = null;
    private XSAttributeGroupDecl fAttrGrp = null;
    private XSSimpleType fXSSimpleType = null;
    private XSParticleDecl fParticle = null;
    private boolean fIsAbstract = false;
    private XSComplexTypeDecl fComplexTypeDecl = null;
    private XSParticleDecl fEmptyParticle = null;
    private Object[] fGlobalStore = null;
    private int fGlobalStorePos = 0;
    private static final boolean DEBUG = false;
    private SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();

    private void contentBackup() {
        if (this.fGlobalStore == null) {
            this.fGlobalStore = new Object[10];
            this.fGlobalStorePos = 0;
        }
        if (this.fGlobalStorePos == this.fGlobalStore.length) {
            Object[] newArray = new Object[this.fGlobalStorePos + 10];
            System.arraycopy(this.fGlobalStore, 0, newArray, 0, this.fGlobalStorePos);
            this.fGlobalStore = newArray;
        }
        this.fGlobalStore[this.fGlobalStorePos++] = this.fComplexTypeDecl;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fIsAbstract ? Boolean.TRUE : Boolean.FALSE;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fName;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fTargetNamespace;
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fDerivedBy << 16) + this.fFinal);
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fBlock << 16) + this.fContentType);
        this.fGlobalStore[this.fGlobalStorePos++] = this.fBaseType;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAttrGrp;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fParticle;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fXSSimpleType;
    }

    private void contentRestore() {
        this.fXSSimpleType = (XSSimpleType)this.fGlobalStore[--this.fGlobalStorePos];
        this.fParticle = (XSParticleDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fAttrGrp = (XSAttributeGroupDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBaseType = (XSTypeDefinition)this.fGlobalStore[--this.fGlobalStorePos];
        int i = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBlock = (short)(i >> 16);
        this.fContentType = (short)i;
        i = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fDerivedBy = (short)(i >> 16);
        this.fFinal = (short)i;
        this.fTargetNamespace = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fName = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fIsAbstract = (Boolean)this.fGlobalStore[--this.fGlobalStorePos];
        this.fComplexTypeDecl = (XSComplexTypeDecl)this.fGlobalStore[--this.fGlobalStorePos];
    }

    private XSParticleDecl getErrorContent() {
        XSParticleDecl particle = new XSParticleDecl();
        particle.fType = (short)2;
        particle.fValue = this.getErrorWildcard();
        particle.fMinOccurs = 0;
        particle.fMaxOccurs = -1;
        XSModelGroupImpl group = new XSModelGroupImpl();
        group.fCompositor = (short)102;
        group.fParticleCount = 1;
        group.fParticles = new XSParticleDecl[1];
        group.fParticles[0] = particle;
        XSParticleDecl errorContent = new XSParticleDecl();
        errorContent.fType = (short)3;
        errorContent.fValue = group;
        return errorContent;
    }

    private XSWildcardDecl getErrorWildcard() {
        XSWildcardDecl errorWildcard = new XSWildcardDecl();
        errorWildcard.fProcessContents = (short)2;
        return errorWildcard;
    }

    private void traverseSimpleContentDecl(Element simpleContentDecl) {
    }

    private boolean isAttrOrAttrGroup(Element e) {
        String elementName = DOMUtil.getLocalName(e);
        return elementName.equals(SchemaSymbols.ELT_ATTRIBUTE) || elementName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || elementName.equals(SchemaSymbols.ELT_ANYATTRIBUTE);
    }

    private void traverseComplexContentDecl(Element complexContentDecl, boolean mixedOnComplexTypeDecl) {
    }

    private String genAnonTypeName(Element complexTypeDecl) {
        Element node = DOMUtil.getParent(complexTypeDecl);
        String typeName = "#AnonType_";
        while (node != null && node != DOMUtil.getRoot(DOMUtil.getDocument(node))) {
            typeName = typeName + node.getAttribute(SchemaSymbols.ATT_NAME);
            node = DOMUtil.getParent(node);
        }
        return typeName;
    }

    XSDComplexTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    private void traverseSimpleContent(Element simpleContentElement, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        Object[] attrValues = this.fAttrChecker.checkAttributes(simpleContentElement, false, schemaDoc);
        this.fContentType = 1;
        this.fParticle = null;
        Element simpleContent = DOMUtil.getFirstChildElement(simpleContentElement);
        if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(simpleContent, attrValues, false, schemaDoc);
            simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (simpleContent == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{this.fName, SchemaSymbols.ELT_SIMPLECONTENT}, simpleContentElement);
        }
        String simpleContentName = DOMUtil.getLocalName(simpleContent);
        if (simpleContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (simpleContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, simpleContentName}, simpleContent);
        }
        Element elemTmp = DOMUtil.getNextSiblingElement(simpleContent);
        if (elemTmp != null) {
            String siblingName = DOMUtil.getLocalName(elemTmp);
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, siblingName}, elemTmp);
        }
        attrValues = this.fAttrChecker.checkAttributes(simpleContent, false, schemaDoc);
        QName baseTypeName = (QName)attrValues[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (baseTypeName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{this.fName}, simpleContent);
        }
        XSTypeDefinition type = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName, simpleContent);
        if (type == null) {
            throw new ComplexTypeRecoverableError();
        }
        this.fBaseType = type;
        XSSimpleType baseValidator = null;
        XSComplexTypeDecl baseComplexType = null;
        short baseFinalSet = 0;
        if (type.getTypeCategory() == 13) {
            baseComplexType = (XSComplexTypeDecl)type;
            if (baseComplexType.getContentType() != 1) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{this.fName}, simpleContent);
            }
            baseFinalSet = baseComplexType.getFinal();
            baseValidator = (XSSimpleType)baseComplexType.getSimpleType();
        } else {
            baseValidator = (XSSimpleType)type;
            if (this.fDerivedBy == 2) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{this.fName}, simpleContent);
            }
            baseFinalSet = baseValidator.getFinal();
        }
        if ((baseFinalSet & this.fDerivedBy) != 0) {
            String errorKey = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(errorKey, new Object[]{this.fName}, simpleContent);
        }
        if ((simpleContent = DOMUtil.getFirstChildElement(simpleContent)) != null) {
            if (DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(simpleContent, null, false, schemaDoc);
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            }
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, simpleContent);
            }
        }
        if (this.fDerivedBy == 2) {
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                XSSimpleType dv = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(simpleContent, schemaDoc, grammar);
                if (dv == null) {
                    throw new ComplexTypeRecoverableError();
                }
                if (!XSConstraints.checkSimpleDerivationOk(dv, baseValidator, baseValidator.getFinal())) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.1.2.1", new Object[]{this.fName}, simpleContent);
                }
                baseValidator = dv;
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            }
            Element attrNode = null;
            XSFacets facetData = null;
            short presentFacets = 0;
            short fixedFacets = 0;
            if (simpleContent != null) {
                XSDAbstractTraverser.FacetInfo fi = this.traverseFacets(simpleContent, baseValidator, schemaDoc);
                attrNode = fi.nodeAfterFacets;
                facetData = fi.facetdata;
                presentFacets = fi.fPresentFacets;
                fixedFacets = fi.fFixedFacets;
            }
            this.fXSSimpleType = this.schemaFactory.createTypeRestriction(null, schemaDoc.fTargetNamespace, (short)0, baseValidator);
            try {
                this.fValidationState.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                this.fXSSimpleType.applyFacets(facetData, presentFacets, fixedFacets, this.fValidationState);
            }
            catch (InvalidDatatypeFacetException ex) {
                this.reportSchemaError(ex.getKey(), ex.getArgs(), simpleContent);
            }
            if (attrNode != null) {
                if (!this.isAttrOrAttrGroup(attrNode)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(attrNode)}, attrNode);
                }
                Element node = this.traverseAttrsAndAttrGrps(attrNode, this.fAttrGrp, schemaDoc, grammar, this.fComplexTypeDecl);
                if (node != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(node)}, node);
                }
            }
            this.mergeAttributes(baseComplexType.getAttrGrp(), this.fAttrGrp, this.fName, false, simpleContentElement);
            this.fAttrGrp.removeProhibitedAttrs();
            String errorCode = this.fAttrGrp.validRestrictionOf(baseComplexType.getAttrGrp());
            if (errorCode != null) {
                throw new ComplexTypeRecoverableError(errorCode, new Object[]{this.fName}, attrNode);
            }
        } else {
            this.fXSSimpleType = baseValidator;
            if (simpleContent != null) {
                Element attrNode = simpleContent;
                if (!this.isAttrOrAttrGroup(attrNode)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(attrNode)}, attrNode);
                }
                Element node = this.traverseAttrsAndAttrGrps(attrNode, this.fAttrGrp, schemaDoc, grammar, this.fComplexTypeDecl);
                if (node != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(node)}, node);
                }
                this.fAttrGrp.removeProhibitedAttrs();
            }
            if (baseComplexType != null) {
                this.mergeAttributes(baseComplexType.getAttrGrp(), this.fAttrGrp, this.fName, true, simpleContentElement);
            }
        }
    }

    private void traverseComplexContent(Element complexContentElement, boolean mixedOnType, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexContentElement, false, schemaDoc);
        boolean mixedContent = mixedOnType;
        Boolean mixedAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_MIXED];
        if (mixedAtt != null) {
            mixedContent = mixedAtt;
        }
        this.fXSSimpleType = null;
        Element complexContent = DOMUtil.getFirstChildElement(complexContentElement);
        if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(complexContent, attrValues, false, schemaDoc);
            complexContent = DOMUtil.getNextSiblingElement(complexContent);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (complexContent == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{this.fName, SchemaSymbols.ELT_COMPLEXCONTENT}, complexContentElement);
        }
        String complexContentName = DOMUtil.getLocalName(complexContent);
        if (complexContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (complexContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, complexContentName}, complexContent);
        }
        Element elemTmp = DOMUtil.getNextSiblingElement(complexContent);
        if (elemTmp != null) {
            String siblingName = DOMUtil.getLocalName(elemTmp);
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, siblingName}, elemTmp);
        }
        attrValues = this.fAttrChecker.checkAttributes(complexContent, false, schemaDoc);
        QName baseTypeName = (QName)attrValues[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (baseTypeName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{this.fName}, complexContent);
        }
        XSTypeDefinition type = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName, complexContent);
        if (type == null) {
            throw new ComplexTypeRecoverableError();
        }
        if (!(type instanceof XSComplexTypeDecl)) {
            throw new ComplexTypeRecoverableError("src-ct.1", new Object[]{this.fName}, complexContent);
        }
        XSComplexTypeDecl baseType = (XSComplexTypeDecl)type;
        this.fBaseType = baseType;
        if ((baseType.getFinal() & this.fDerivedBy) != 0) {
            String errorKey = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(errorKey, new Object[]{this.fName}, complexContent);
        }
        if ((complexContent = DOMUtil.getFirstChildElement(complexContent)) != null) {
            if (DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(complexContent, null, false, schemaDoc);
                complexContent = DOMUtil.getNextSiblingElement(complexContent);
            }
            if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, complexContent);
            }
        }
        this.processComplexContent(complexContent, mixedContent, true, schemaDoc, grammar);
        XSParticleDecl baseContent = (XSParticleDecl)baseType.getParticle();
        if (this.fDerivedBy == 2) {
            String error;
            if (this.fContentType == 3 && baseType.getContentType() != 3) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.3.1.2", new Object[]{this.fName}, complexContent);
            }
            this.mergeAttributes(baseType.getAttrGrp(), this.fAttrGrp, this.fName, false, complexContent);
            if (baseType != SchemaGrammar.fAnyType && (error = this.fAttrGrp.validRestrictionOf(baseType.getAttrGrp())) != null) {
                throw new ComplexTypeRecoverableError(error, new Object[]{this.fName}, complexContent);
            }
            this.fAttrGrp.removeProhibitedAttrs();
        } else {
            if (this.fParticle == null) {
                this.fContentType = baseType.getContentType();
                this.fParticle = baseContent;
            } else if (baseType.getContentType() != 0) {
                if (this.fContentType == 2 && baseType.getContentType() != 2 || this.fContentType == 3 && baseType.getContentType() != 3) {
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.1", new Object[]{this.fName}, complexContent);
                }
                if (this.fParticle.fType == 3 && ((XSModelGroupImpl)this.fParticle.fValue).fCompositor == 103 || ((XSParticleDecl)baseType.getParticle()).fType == 3 && ((XSModelGroupImpl)((XSParticleDecl)baseType.getParticle()).fValue).fCompositor == 103) {
                    throw new ComplexTypeRecoverableError("cos-all-limited.1.2", null, complexContent);
                }
                XSModelGroupImpl group = new XSModelGroupImpl();
                group.fCompositor = (short)102;
                group.fParticleCount = 2;
                group.fParticles = new XSParticleDecl[2];
                group.fParticles[0] = (XSParticleDecl)baseType.getParticle();
                group.fParticles[1] = this.fParticle;
                XSParticleDecl particle = new XSParticleDecl();
                particle.fType = (short)3;
                particle.fValue = group;
                this.fParticle = particle;
            }
            this.fAttrGrp.removeProhibitedAttrs();
            this.mergeAttributes(baseType.getAttrGrp(), this.fAttrGrp, this.fName, true, complexContent);
        }
    }

    private void processComplexContent(Element complexContentChild, boolean isMixed, boolean isDerivation, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        Element attrNode = null;
        XSParticleDecl particle = null;
        if (complexContentChild != null) {
            String childName = DOMUtil.getLocalName(complexContentChild);
            if (childName.equals(SchemaSymbols.ELT_GROUP)) {
                particle = this.fSchemaHandler.fGroupTraverser.traverseLocal(complexContentChild, schemaDoc, grammar);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_SEQUENCE)) {
                particle = this.traverseSequence(complexContentChild, schemaDoc, grammar, 0, this.fComplexTypeDecl);
                if (particle != null) {
                    XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
                    if (group.fParticleCount == 0) {
                        particle = null;
                    }
                }
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_CHOICE)) {
                particle = this.traverseChoice(complexContentChild, schemaDoc, grammar, 0, this.fComplexTypeDecl);
                if (particle != null && particle.fMinOccurs == 0) {
                    XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
                    if (group.fParticleCount == 0) {
                        particle = null;
                    }
                }
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_ALL)) {
                particle = this.traverseAll(complexContentChild, schemaDoc, grammar, 8, this.fComplexTypeDecl);
                if (particle != null) {
                    XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
                    if (group.fParticleCount == 0) {
                        particle = null;
                    }
                }
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else {
                attrNode = complexContentChild;
            }
        }
        if (particle == null && isMixed) {
            if (this.fEmptyParticle == null) {
                XSModelGroupImpl group = new XSModelGroupImpl();
                group.fCompositor = (short)102;
                group.fParticleCount = 0;
                group.fParticles = null;
                this.fEmptyParticle = new XSParticleDecl();
                this.fEmptyParticle.fType = (short)3;
                this.fEmptyParticle.fValue = group;
            }
            particle = this.fEmptyParticle;
        }
        this.fParticle = particle;
        this.fContentType = this.fParticle == null ? (short)0 : (isMixed ? (short)3 : (short)2);
        if (attrNode != null) {
            if (!this.isAttrOrAttrGroup(attrNode)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(attrNode)}, attrNode);
            }
            Element node = this.traverseAttrsAndAttrGrps(attrNode, this.fAttrGrp, schemaDoc, grammar, this.fComplexTypeDecl);
            if (node != null) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(node)}, node);
            }
            if (!isDerivation) {
                this.fAttrGrp.removeProhibitedAttrs();
            }
        }
    }

    private void handleComplexTypeError(String messageId, Object[] args, Element e) {
        if (messageId != null) {
            this.reportSchemaError(messageId, args, e);
        }
        this.fContentType = (short)3;
        this.fParticle = this.getErrorContent();
        this.fAttrGrp.fAttributeWC = this.getErrorWildcard();
    }

    XSComplexTypeDecl traverseGlobal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, true, schemaDoc);
        String complexTypeName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        this.contentBackup();
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar);
        this.contentRestore();
        if (complexTypeName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ATT_NAME}, complexTypeNode);
        } else {
            grammar.addGlobalTypeDecl(type);
        }
        grammar.addComplexTypeDecl(type, this.fSchemaHandler.element2Locator(complexTypeNode));
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    XSComplexTypeDecl traverseLocal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, false, schemaDoc);
        String complexTypeName = this.genAnonTypeName(complexTypeNode);
        this.contentBackup();
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar);
        this.contentRestore();
        grammar.addComplexTypeDecl(type, this.fSchemaHandler.element2Locator(complexTypeNode));
        type.setIsAnonymous();
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    private void mergeAttributes(XSAttributeGroupDecl fromAttrGrp, XSAttributeGroupDecl toAttrGrp, String typeName, boolean extension, Element elem) throws ComplexTypeRecoverableError {
        XSObjectList attrUseS = fromAttrGrp.getAttributeUses();
        Object duplicateAttrUse = null;
        int attrCount = attrUseS.getLength();
        int i = 0;
        while (i < attrCount) {
            XSAttributeUseImpl oneAttrUse = (XSAttributeUseImpl)attrUseS.item(i);
            XSAttributeUseImpl existingAttrUse = toAttrGrp.getAttributeUse(oneAttrUse.fAttrDecl.getNamespace(), oneAttrUse.fAttrDecl.getName());
            if (existingAttrUse == null) {
                String idName = toAttrGrp.addAttributeUse(oneAttrUse);
                if (idName != null) {
                    throw new ComplexTypeRecoverableError("ct-props-correct.5", new Object[]{typeName, idName, oneAttrUse.fAttrDecl.getName()}, elem);
                }
            } else if (extension) {
                throw new ComplexTypeRecoverableError("ct-props-correct.4", new Object[]{typeName, existingAttrUse.fAttrDecl.getName()}, elem);
            }
            ++i;
        }
        if (extension) {
            if (toAttrGrp.fAttributeWC == null) {
                toAttrGrp.fAttributeWC = fromAttrGrp.fAttributeWC;
            } else if (fromAttrGrp.fAttributeWC != null) {
                toAttrGrp.fAttributeWC = toAttrGrp.fAttributeWC.performUnionWith(fromAttrGrp.fAttributeWC, toAttrGrp.fAttributeWC.fProcessContents);
            }
        }
    }

    private XSComplexTypeDecl traverseComplexTypeDecl(Element complexTypeDecl, String complexTypeName, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        this.fComplexTypeDecl = new XSComplexTypeDecl();
        this.fAttrGrp = new XSAttributeGroupDecl();
        Boolean abstractAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt blockAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_BLOCK];
        Boolean mixedAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_MIXED];
        XInt finalAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        this.fName = complexTypeName;
        this.fComplexTypeDecl.setName(this.fName);
        this.fTargetNamespace = schemaDoc.fTargetNamespace;
        this.fBlock = blockAtt == null ? schemaDoc.fBlockDefault : blockAtt.shortValue();
        short s = this.fFinal = finalAtt == null ? schemaDoc.fFinalDefault : finalAtt.shortValue();
        if (abstractAtt != null && abstractAtt.booleanValue()) {
            this.fIsAbstract = true;
        }
        Element child = null;
        try {
            child = DOMUtil.getFirstChildElement(complexTypeDecl);
            if (child != null) {
                if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                    child = DOMUtil.getNextSiblingElement(child);
                }
                if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, child);
                }
            }
            if (child == null) {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(child, mixedAtt, false, schemaDoc, grammar);
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_SIMPLECONTENT)) {
                this.traverseSimpleContent(child, schemaDoc, grammar);
                Element elemTmp = DOMUtil.getNextSiblingElement(child);
                if (elemTmp != null) {
                    String siblingName = DOMUtil.getLocalName(elemTmp);
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, siblingName}, elemTmp);
                }
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_COMPLEXCONTENT)) {
                this.traverseComplexContent(child, mixedAtt, schemaDoc, grammar);
                Element elemTmp = DOMUtil.getNextSiblingElement(child);
                if (elemTmp != null) {
                    String siblingName = DOMUtil.getLocalName(elemTmp);
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, siblingName}, elemTmp);
                }
            } else {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(child, mixedAtt, false, schemaDoc, grammar);
            }
        }
        catch (ComplexTypeRecoverableError e) {
            this.handleComplexTypeError(e.getMessage(), e.errorSubstText, e.errorElem);
        }
        this.fComplexTypeDecl.setValues(this.fName, this.fTargetNamespace, this.fBaseType, this.fDerivedBy, this.fFinal, this.fBlock, this.fContentType, this.fIsAbstract, this.fAttrGrp, this.fXSSimpleType, this.fParticle);
        return this.fComplexTypeDecl;
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        Object[] errorSubstText = null;
        Element errorElem = null;

        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String msgKey, Object[] args, Element e) {
            super(msgKey);
            this.errorSubstText = args;
            this.errorElem = e;
        }
    }
}

