/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.xerces.xni.Augmentations;

public class AugmentationsImpl
implements Augmentations {
    private AugmentationsItemsContainer fAugmentationsContainer = new SmallContainer();

    public void removeAllItems() {
        this.fAugmentationsContainer.clear();
    }

    public String toString() {
        return this.fAugmentationsContainer.toString();
    }

    public Enumeration keys() {
        return this.fAugmentationsContainer.keys();
    }

    public Object getItem(String key) {
        return this.fAugmentationsContainer.getItem(key);
    }

    public Object removeItem(String key) {
        return this.fAugmentationsContainer.removeItem(key);
    }

    public Object putItem(String key, Object item) {
        Object oldValue = this.fAugmentationsContainer.putItem(key, item);
        if (oldValue == null && this.fAugmentationsContainer.isFull()) {
            this.fAugmentationsContainer = this.fAugmentationsContainer.expand();
        }
        return oldValue;
    }

    abstract class AugmentationsItemsContainer {
        public abstract void clear();

        public abstract boolean isFull();

        public abstract Enumeration keys();

        AugmentationsItemsContainer() {
        }

        public abstract AugmentationsItemsContainer expand();

        public abstract Object getItem(Object var1);

        public abstract Object removeItem(Object var1);

        public abstract Object putItem(Object var1, Object var2);
    }

    class LargeContainer
    extends AugmentationsItemsContainer {
        final Hashtable fAugmentations = new Hashtable();

        public void clear() {
            this.fAugmentations.clear();
        }

        public boolean isFull() {
            return false;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("LargeContainer");
            Enumeration enumeration = this.fAugmentations.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                buff.append("\nkey == ");
                buff.append(key);
                buff.append("; value == ");
                buff.append(this.fAugmentations.get(key));
            }
            return buff.toString();
        }

        public Enumeration keys() {
            return this.fAugmentations.keys();
        }

        LargeContainer() {
        }

        public AugmentationsItemsContainer expand() {
            return this;
        }

        public Object getItem(Object key) {
            return this.fAugmentations.get(key);
        }

        public Object removeItem(Object key) {
            return this.fAugmentations.remove(key);
        }

        public Object putItem(Object key, Object item) {
            return this.fAugmentations.put(key, item);
        }
    }

    class SmallContainer
    extends AugmentationsItemsContainer {
        static final int SIZE_LIMIT = 10;
        final Object[] fAugmentations = new Object[20];
        int fNumEntries = 0;

        public void clear() {
            int i = 0;
            while (i < this.fNumEntries * 2) {
                this.fAugmentations[i] = null;
                this.fAugmentations[i + 1] = null;
                i += 2;
            }
            this.fNumEntries = 0;
        }

        public boolean isFull() {
            return this.fNumEntries == 10;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("SmallContainer - fNumEntries == " + this.fNumEntries);
            int i = 0;
            while (i < 20) {
                buff.append("\nfAugmentations[");
                buff.append(i);
                buff.append("] == ");
                buff.append(this.fAugmentations[i]);
                buff.append("; fAugmentations[");
                buff.append(i + 1);
                buff.append("] == ");
                buff.append(this.fAugmentations[i + 1]);
                i += 2;
            }
            return buff.toString();
        }

        public Enumeration keys() {
            return new SmallContainerKeyEnumeration();
        }

        SmallContainer() {
        }

        public AugmentationsItemsContainer expand() {
            LargeContainer expandedContainer = new LargeContainer();
            int i = 0;
            while (i < this.fNumEntries * 2) {
                expandedContainer.putItem(this.fAugmentations[i], this.fAugmentations[i + 1]);
                i += 2;
            }
            return expandedContainer;
        }

        public Object getItem(Object key) {
            int i = 0;
            while (i < this.fNumEntries * 2) {
                if (this.fAugmentations[i].equals(key)) {
                    return this.fAugmentations[i + 1];
                }
                i += 2;
            }
            return null;
        }

        public Object removeItem(Object key) {
            int i = 0;
            while (i < this.fNumEntries * 2) {
                if (this.fAugmentations[i].equals(key)) {
                    Object oldValue = this.fAugmentations[i + 1];
                    int j = i;
                    while (j < this.fNumEntries * 2 - 2) {
                        this.fAugmentations[j] = this.fAugmentations[j + 2];
                        this.fAugmentations[j + 1] = this.fAugmentations[j + 3];
                        j += 2;
                    }
                    this.fAugmentations[this.fNumEntries * 2 - 2] = null;
                    this.fAugmentations[this.fNumEntries * 2 - 1] = null;
                    --this.fNumEntries;
                    return oldValue;
                }
                i += 2;
            }
            return null;
        }

        public Object putItem(Object key, Object item) {
            int i = 0;
            while (i < this.fNumEntries * 2) {
                if (this.fAugmentations[i].equals(key)) {
                    Object oldValue = this.fAugmentations[i + 1];
                    this.fAugmentations[i + 1] = item;
                    return oldValue;
                }
                i += 2;
            }
            this.fAugmentations[this.fNumEntries * 2] = key;
            this.fAugmentations[this.fNumEntries * 2 + 1] = item;
            ++this.fNumEntries;
            return null;
        }

        class SmallContainerKeyEnumeration
        implements Enumeration {
            Object[] enumArray;
            int next;

            public boolean hasMoreElements() {
                return this.next < this.enumArray.length;
            }

            public Object nextElement() {
                if (this.next >= this.enumArray.length) {
                    throw new NoSuchElementException();
                }
                Object nextVal = this.enumArray[this.next];
                this.enumArray[this.next] = null;
                ++this.next;
                return nextVal;
            }

            SmallContainerKeyEnumeration() {
                this.enumArray = new Object[SmallContainer.this.fNumEntries];
                this.next = 0;
                int i = 0;
                while (i < SmallContainer.this.fNumEntries) {
                    this.enumArray[i] = SmallContainer.this.fAugmentations[i * 2];
                    ++i;
                }
            }
        }
    }
}

