/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.rahas.TokenCanceler;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.ws.security.util.Loader;

public class TokenRequestDispatcherConfig {
    public static final String CONFIG_PARAM_KEY = "token-dispatcher-configuration";
    public static final String CONFIG_FILE_KEY = "token-dispatcher-configuration-file";
    private static final QName DISPATCHER_CONFIG = new QName("token-dispatcher-configuration");
    private static final QName ISSUER = new QName("issuer");
    private static final QName CANCELER = new QName("canceler");
    private static final QName TOKEN_TYPE = new QName("tokenType");
    private static final QName CLASS_ATTR = new QName("class");
    private static final QName DEFAULT_ATTR = new QName("default");
    private static final QName CONFIGURATION_ELEMENT = new QName("configuration");
    private Map issuers;
    private Map configFiles = new Hashtable();
    private Map configElements = new Hashtable();
    private Map configParamNames = new Hashtable();
    private String defaultIssuerClassName;
    private String defaultCancelerClassName;

    public static TokenRequestDispatcherConfig load(OMElement configElem) throws TrustException {
        if (!DISPATCHER_CONFIG.equals(configElem.getQName())) {
            throw new TrustException("incorrectConfiguration");
        }
        TokenRequestDispatcherConfig conf = new TokenRequestDispatcherConfig();
        TokenRequestDispatcherConfig.handleIssuers(configElem, conf);
        TokenRequestDispatcherConfig.handleCancelers(configElem, conf);
        if (conf.defaultIssuerClassName == null) {
            throw new TrustException("defaultIssuerMissing");
        }
        return conf;
    }

    private static void handleCancelers(OMElement configElem, TokenRequestDispatcherConfig conf) throws TrustException {
        OMElement cancelerEle = configElem.getFirstChildWithName(CANCELER);
        if (cancelerEle != null) {
            String cancelerClass = cancelerEle.getAttributeValue(CLASS_ATTR);
            if (cancelerClass == null) {
                throw new TrustException("missingClassName");
            }
            conf.defaultCancelerClassName = cancelerClass;
            TokenRequestDispatcherConfig.processConfiguration(cancelerEle, conf, cancelerClass);
        }
    }

    private static void handleIssuers(OMElement configElem, TokenRequestDispatcherConfig conf) throws TrustException {
        Iterator issuerElems = configElem.getChildrenWithName(ISSUER);
        while (issuerElems.hasNext()) {
            OMElement element = (OMElement)issuerElems.next();
            String issuerClass = element.getAttributeValue(CLASS_ATTR);
            if (issuerClass == null) {
                throw new TrustException("missingClassName");
            }
            String isDefault = element.getAttributeValue(DEFAULT_ATTR);
            if (isDefault != null && "true".equalsIgnoreCase(isDefault)) {
                if (conf.defaultIssuerClassName == null) {
                    conf.defaultIssuerClassName = issuerClass;
                } else {
                    throw new TrustException("badDispatcherConfigMultipleDefaultIssuers");
                }
            }
            TokenRequestDispatcherConfig.processConfiguration(element, conf, issuerClass);
            Iterator tokenTypes = element.getChildrenWithName(TOKEN_TYPE);
            while (tokenTypes.hasNext()) {
                OMElement type = (OMElement)tokenTypes.next();
                String value = type.getText();
                if (value == null || value.trim().length() == 0) {
                    throw new TrustException("invalidTokenTypeDefinition", new String[]{"Issuer", issuerClass});
                }
                if (conf.issuers == null) {
                    conf.issuers = new Hashtable();
                }
                if (conf.issuers.keySet().contains(value)) continue;
                conf.issuers.put(value, issuerClass);
            }
        }
    }

    private static void processConfiguration(OMElement element, TokenRequestDispatcherConfig conf, String implClass) {
        Iterator configs = element.getChildrenWithName(CONFIGURATION_ELEMENT);
        while (configs.hasNext()) {
            OMElement configEle = (OMElement)configs.next();
            String configType = configEle.getAttribute(new QName("type")).getAttributeValue().trim();
            if (configType.equalsIgnoreCase("file")) {
                String issuerConfigFile = configEle.getText();
                if (issuerConfigFile == null) continue;
                conf.configFiles.put(implClass, issuerConfigFile);
                continue;
            }
            if (configType.equalsIgnoreCase("element")) {
                conf.configElements.put(implClass, configEle);
                continue;
            }
            if (!configType.equalsIgnoreCase("parameter")) continue;
            conf.configParamNames.put(implClass, configEle.getText());
        }
    }

    public static TokenRequestDispatcherConfig load(String configFilePath) throws TrustException {
        StAXOMBuilder builder;
        try {
            FileInputStream fis = new FileInputStream(configFilePath);
            builder = new StAXOMBuilder((InputStream)fis);
        }
        catch (Exception e) {
            throw new TrustException("errorLoadingConfigFile", new String[]{configFilePath});
        }
        return TokenRequestDispatcherConfig.load(builder.getDocumentElement());
    }

    public TokenIssuer getDefaultIssuerInstace() throws TrustException {
        if (this.defaultIssuerClassName != null) {
            try {
                return this.createIssuer(this.defaultIssuerClassName);
            }
            catch (Exception e) {
                throw new TrustException("cannotLoadClass", new String[]{this.defaultIssuerClassName}, e);
            }
        }
        return null;
    }

    public TokenCanceler getDefaultCancelerInstance() throws TrustException {
        if (this.defaultCancelerClassName != null) {
            try {
                return this.createCanceler(this.defaultCancelerClassName);
            }
            catch (Exception e) {
                throw new TrustException("cannotLoadClass", new String[]{this.defaultCancelerClassName}, e);
            }
        }
        return null;
    }

    public String getDefaultIssuerName() {
        return this.defaultIssuerClassName;
    }

    public TokenIssuer getIssuer(String tokenType) throws TrustException {
        String issuerClassName = null;
        if (this.issuers != null) {
            issuerClassName = (String)this.issuers.get(tokenType);
        }
        if (issuerClassName == null) {
            issuerClassName = this.defaultIssuerClassName;
        }
        try {
            return this.createIssuer(issuerClassName);
        }
        catch (Exception e) {
            throw new TrustException("cannotLoadClass", new String[]{this.defaultIssuerClassName}, e);
        }
    }

    private TokenIssuer createIssuer(String issuerClassName) throws Exception {
        TokenIssuer issuer = (TokenIssuer)Loader.loadClass((String)issuerClassName).newInstance();
        issuer.setConfigurationElement((OMElement)this.configElements.get(issuerClassName));
        issuer.setConfigurationFile((String)this.configFiles.get(issuerClassName));
        issuer.setConfigurationParamName((String)this.configParamNames.get(issuerClassName));
        return issuer;
    }

    private TokenCanceler createCanceler(String cancelerClassName) throws Exception {
        TokenCanceler canceler = (TokenCanceler)Loader.loadClass((String)cancelerClassName).newInstance();
        canceler.setConfigurationElement((OMElement)this.configElements.get(cancelerClassName));
        canceler.setConfigurationFile((String)this.configFiles.get(cancelerClassName));
        canceler.setConfigurationParamName((String)this.configParamNames.get(cancelerClassName));
        return canceler;
    }
}

