/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.account.model.hibernate;

import gov.nih.tbi.account.model.PermissionAuthority;
import gov.nih.tbi.account.model.hibernate.AccountRole;
import gov.nih.tbi.account.model.hibernate.Country;
import gov.nih.tbi.account.model.hibernate.EntityMap;
import gov.nih.tbi.account.model.hibernate.PermissionGroupMember;
import gov.nih.tbi.account.model.hibernate.State;
import gov.nih.tbi.commons.model.AbstractBricsObject;
import gov.nih.tbi.commons.model.AccountStatus;
import gov.nih.tbi.commons.model.RoleStatus;
import gov.nih.tbi.commons.model.RoleType;
import gov.nih.tbi.commons.model.hibernate.User;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ACCOUNT")
public class Account
extends AbstractBricsObject
implements Serializable,
PermissionAuthority {
    private static final long serialVersionUID = -288792190452003023L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_SEQ")
    @SequenceGenerator(name="ACCOUNT_SEQ", sequenceName="ACCOUNT_SEQ", allocationSize=1)
    private Long id;
    @Column(name="USER_NAME")
    private String userName;
    @Column(name="PASSWORD")
    private byte[] password;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="USER_ID")
    private User user = new User();
    @Column(name="AFFILIATED_INSTITUTION")
    private String affiliatedInstitution;
    @Column(name="ERA_COMMONS_ID")
    private String eraId;
    @Column(name="ADDRESS_1")
    private String address1;
    @Column(name="ADDRESS_2")
    private String address2;
    @Column(name="CITY")
    private String city;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="STATE_ID")
    private State state;
    @Column(name="POSTAL_CODE")
    private String postalCode;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="COUNTRY_ID")
    private Country country;
    @Column(name="PHONE")
    private String phone;
    @Column(name="INTEREST_IN_TBI")
    private String interestInTbi;
    @Column(name="RECOVERY_DATE")
    private Date recoveryDate;
    @Column(name="IS_ACTIVE")
    private Boolean isActive;
    @XmlTransient
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="account", targetEntity=AccountRole.class, orphanRemoval=true)
    private Set<AccountRole> accountRoleList = new HashSet<AccountRole>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="account", targetEntity=PermissionGroupMember.class, orphanRemoval=true)
    private Set<PermissionGroupMember> permissionGroupMemberList = new HashSet<PermissionGroupMember>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="account", targetEntity=EntityMap.class, orphanRemoval=true)
    private Set<EntityMap> entityMapList;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ACCOUNT_STATUS_ID")
    private AccountStatus accountStatus;
    @Column(name="ADMIN_NOTE")
    private String adminNote;
    @Column(name="APPLICATION_DATE")
    private Date applicationDate;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Long getUserId() {
        if (this.user != null) {
            return this.user.getId();
        }
        return null;
    }

    public String getAffiliatedInstitution() {
        return this.affiliatedInstitution;
    }

    public void setAffiliatedInstitution(String affiliatedInstitution) {
        this.affiliatedInstitution = affiliatedInstitution;
    }

    public String getEraId() {
        return this.eraId;
    }

    public void setEraId(String eraId) {
        this.eraId = eraId;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getInterestInTbi() {
        return this.interestInTbi;
    }

    public void setInterestInTbi(String interestInTbi) {
        this.interestInTbi = interestInTbi;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public void setAccountStatus(AccountStatus accountStatus) {
        this.accountStatus = accountStatus;
    }

    public Date getRecoveryDate() {
        return this.recoveryDate;
    }

    public void setRecoveryDate(Date recoveryDate) {
        this.recoveryDate = recoveryDate;
    }

    public Set<AccountRole> getAccountRoleList() {
        return this.accountRoleList;
    }

    public void setAccountRoleList(Set<AccountRole> accountRoleList) {
        if (this.accountRoleList == null) {
            this.accountRoleList = new HashSet<AccountRole>();
        }
        this.accountRoleList.clear();
        if (accountRoleList != null) {
            this.accountRoleList.addAll(accountRoleList);
        }
    }

    public Set<EntityMap> getEntityMapList() {
        return this.entityMapList;
    }

    public void setEntityMapList(Set<EntityMap> entityMapList) {
        if (this.entityMapList == null) {
            this.entityMapList = new HashSet<EntityMap>();
        }
        this.entityMapList.clear();
        if (entityMapList != null) {
            this.entityMapList.addAll(entityMapList);
        }
    }

    public Boolean getIsActive() {
        if (this.isActive != null) {
            return this.isActive;
        }
        return false;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Set<PermissionGroupMember> getPermissionGroupMemberList() {
        return this.permissionGroupMemberList;
    }

    public void setPermissionGroupMemberList(Set<PermissionGroupMember> permissionGroupMemberList) {
        if (this.permissionGroupMemberList == null) {
            this.permissionGroupMemberList = new HashSet<PermissionGroupMember>();
        }
        this.permissionGroupMemberList.clear();
        if (permissionGroupMemberList != null) {
            this.permissionGroupMemberList.addAll(permissionGroupMemberList);
        }
    }

    public String getAdminNote() {
        return this.adminNote;
    }

    public void setAdminNote(String adminNote) {
        this.adminNote = adminNote;
    }

    @Deprecated
    public boolean hasRole(RoleType testRole) {
        for (AccountRole ar : this.accountRoleList) {
            if (!ar.getRoleType().equals((Object)testRole) || !ar.getRoleStatus().equals((Object)RoleStatus.ACTIVE)) continue;
            return true;
        }
        return false;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public String getApplicationString() {
        if (this.applicationDate == null) {
            return "-";
        }
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        return df.format(this.applicationDate);
    }

    @Override
    public String getDisplayName() {
        return this.getUser().getFullName() + " (" + this.getUserName() + ")";
    }

    @Override
    public String getDisplayKey() {
        return "ACCOUNT:" + this.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountRoleList == null ? 0 : ((Object)this.accountRoleList).hashCode());
        result = 31 * result + (this.accountStatus == null ? 0 : this.accountStatus.hashCode());
        result = 31 * result + (this.address1 == null ? 0 : this.address1.hashCode());
        result = 31 * result + (this.address2 == null ? 0 : this.address2.hashCode());
        result = 31 * result + (this.adminNote == null ? 0 : this.adminNote.hashCode());
        result = 31 * result + (this.affiliatedInstitution == null ? 0 : this.affiliatedInstitution.hashCode());
        result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.entityMapList == null ? 0 : ((Object)this.entityMapList).hashCode());
        result = 31 * result + (this.eraId == null ? 0 : this.eraId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.interestInTbi == null ? 0 : this.interestInTbi.hashCode());
        result = 31 * result + (this.isActive == null ? 0 : this.isActive.hashCode());
        result = 31 * result + Arrays.hashCode(this.password);
        result = 31 * result + (this.permissionGroupMemberList == null ? 0 : ((Object)this.permissionGroupMemberList).hashCode());
        result = 31 * result + (this.phone == null ? 0 : this.phone.hashCode());
        result = 31 * result + (this.postalCode == null ? 0 : this.postalCode.hashCode());
        result = 31 * result + (this.recoveryDate == null ? 0 : this.recoveryDate.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        Account acc;
        if (obj instanceof Account && (acc = (Account)obj).getUserName().equals(this.getUserName())) {
            return true;
        }
        return super.equals(obj);
    }
}

