/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.account.model.hibernate;

import gov.nih.tbi.account.model.hibernate.Country;
import gov.nih.tbi.account.model.hibernate.State;
import gov.nih.tbi.commons.model.AbstractBricsObject;
import gov.nih.tbi.commons.model.AccountStatus;
import gov.nih.tbi.commons.model.hibernate.User;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="ACCOUNT")
public class BasicAccount
extends AbstractBricsObject
implements Serializable {
    private static final long serialVersionUID = -288792190452003023L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_SEQ")
    @SequenceGenerator(name="ACCOUNT_SEQ", sequenceName="ACCOUNT_SEQ", allocationSize=1)
    private Long id;
    @Column(name="USER_NAME")
    private String userName;
    @Column(name="PASSWORD")
    private byte[] password;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="USER_ID")
    private User user = new User();
    @Column(name="AFFILIATED_INSTITUTION")
    private String affiliatedInstitution;
    @Column(name="ERA_COMMONS_ID")
    private String eraId;
    @Column(name="ADDRESS_1")
    private String address1;
    @Column(name="ADDRESS_2")
    private String address2;
    @Column(name="CITY")
    private String city;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="STATE_ID")
    private State state;
    @Column(name="POSTAL_CODE")
    private String postalCode;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="COUNTRY_ID")
    private Country country;
    @Column(name="PHONE")
    private String phone;
    @Column(name="INTEREST_IN_TBI")
    private String interestInTbi;
    @Column(name="RECOVERY_DATE")
    private Date recoveryDate;
    @Column(name="IS_ACTIVE")
    private Boolean isActive;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ACCOUNT_STATUS_ID")
    private AccountStatus accountStatus;
    @Column(name="APPLICATION_DATE")
    private Date applicationDate;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Long getUserId() {
        if (this.user != null) {
            return this.user.getId();
        }
        return null;
    }

    public String getAffiliatedInstitution() {
        return this.affiliatedInstitution;
    }

    public void setAffiliatedInstitution(String affiliatedInstitution) {
        this.affiliatedInstitution = affiliatedInstitution;
    }

    public String getEraId() {
        return this.eraId;
    }

    public void setEraId(String eraId) {
        this.eraId = eraId;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getInterestInTbi() {
        return this.interestInTbi;
    }

    public void setInterestInTbi(String interestInTbi) {
        this.interestInTbi = interestInTbi;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public void setAccountStatus(AccountStatus accountStatus) {
        this.accountStatus = accountStatus;
    }

    public Date getRecoveryDate() {
        return this.recoveryDate;
    }

    public void setRecoveryDate(Date recoveryDate) {
        this.recoveryDate = recoveryDate;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public String getApplicationString() {
        if (this.applicationDate == null) {
            return "-";
        }
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        return df.format(this.applicationDate);
    }
}

