/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.commons.model;

import gov.nih.tbi.commons.model.DateStruct;
import gov.nih.tbi.commons.model.IdInfoStruct;
import gov.nih.tbi.commons.model.InvestigatorStruct;
import gov.nih.tbi.commons.model.RequiredHeaderStruct;
import gov.nih.tbi.commons.model.TextblockStruct;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"idInfo", "requiredHeader", "briefTitle", "acronym", "officialTitle", "source", "briefSummary", "detailedDescription", "overallStatus", "startDate", "endDate", "overallOfficial"})
@XmlRootElement(name="clinical_study")
public class ClinicalStudy {
    @XmlElement(name="required_header", required=true)
    protected RequiredHeaderStruct requiredHeader;
    @XmlElement(name="id_info", required=true)
    protected IdInfoStruct idInfo;
    @XmlElement(name="brief_title", required=true)
    protected String briefTitle;
    protected String acronym;
    @XmlElement(name="official_title")
    protected String officialTitle;
    @XmlElement(required=true)
    protected String source;
    @XmlElement(name="brief_summary")
    protected TextblockStruct briefSummary;
    @XmlElement(name="detailed_description")
    protected TextblockStruct detailedDescription;
    @XmlElement(name="overall_status", required=true)
    protected String overallStatus;
    @XmlElement(name="start_date")
    protected DateStruct startDate;
    @XmlElement(name="end_date")
    protected DateStruct endDate;
    @XmlElement(name="overall_official")
    protected List<InvestigatorStruct> overallOfficial;

    public String getBriefTitle() {
        return this.briefTitle;
    }

    public void setBriefTitle(String value) {
        this.briefTitle = value;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public void setAcronym(String value) {
        this.acronym = value;
    }

    public String getOfficialTitle() {
        return this.officialTitle;
    }

    public void setOfficialTitle(String value) {
        this.officialTitle = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public TextblockStruct getBriefSummary() {
        return this.briefSummary;
    }

    public void setBriefSummary(TextblockStruct value) {
        this.briefSummary = value;
    }

    public TextblockStruct getDetailedDescription() {
        return this.detailedDescription;
    }

    public void setDetailedDescription(TextblockStruct value) {
        this.detailedDescription = value;
    }

    public String getOverallStatus() {
        return this.overallStatus;
    }

    public void setOverallStatus(String value) {
        this.overallStatus = value;
    }

    public DateStruct getStartDate() {
        return this.startDate;
    }

    public void setStartDate(DateStruct value) {
        this.startDate = value;
    }

    public DateStruct getEndDate() {
        return this.endDate;
    }

    public void setEndDate(DateStruct value) {
        this.endDate = value;
    }

    public List<InvestigatorStruct> getOverallOfficial() {
        if (this.overallOfficial == null) {
            this.overallOfficial = new ArrayList<InvestigatorStruct>();
        }
        return this.overallOfficial;
    }

    public RequiredHeaderStruct getRequiredHeader() {
        return this.requiredHeader;
    }

    public void setRequiredHeader(RequiredHeaderStruct value) {
        this.requiredHeader = value;
    }

    public InvestigatorStruct getPrincipalInvestigator() {
        if (this.overallOfficial != null) {
            for (InvestigatorStruct official : this.overallOfficial) {
                if (!"Principal Investigator".equals(official.getRole())) continue;
                return official;
            }
        }
        return null;
    }

    public IdInfoStruct getIdInfo() {
        return this.idInfo;
    }

    public void setIdInfo(IdInfoStruct value) {
        this.idInfo = value;
    }
}

