/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.commons.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatasetStatus {
    PRIVATE(0L, "Private", "Private"),
    SHARED(1L, "Shared", "Share"),
    ARCHIVED(2L, "Archived", "Archive"),
    DELETED(3L, "Deleted", "Delete"),
    UPLOADING(4L, "Uploading", "Upload"),
    LOADING(5L, "Loading Data", "Load Data");

    private static final Map<Long, DatasetStatus> lookup;
    private Long id;
    private String name;
    private String verb;

    private DatasetStatus(Long id, String name, String verb) {
        this.id = id;
        this.name = name;
        this.verb = verb;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVerb() {
        return this.verb;
    }

    public static DatasetStatus getById(Long id) {
        return lookup.get(id);
    }

    static {
        lookup = new HashMap<Long, DatasetStatus>();
        for (DatasetStatus s : EnumSet.allOf(DatasetStatus.class)) {
            lookup.put(s.getId(), s);
        }
    }
}

