/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.commons.model;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ElementType {
    COMMON(1, "Common Data Element (CDE)"),
    NONCOMMON(2, "Data Element (DE)"),
    ALL(3, "All");

    private Integer id;
    private String label;
    private static final HashMap<Integer, ElementType> idToElementTypeMap;

    private ElementType(Integer id, String label) {
        this.id = id;
        this.label = label;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static ElementType lookup(int id) {
        return idToElementTypeMap.get(id);
    }

    static {
        idToElementTypeMap = new HashMap();
        for (ElementType elementType : ElementType.values()) {
            idToElementTypeMap.put(elementType.getId(), elementType);
        }
    }
}

