/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.model.hibernate;

import gov.nih.tbi.commons.model.DataType;
import gov.nih.tbi.commons.model.InputRestrictions;
import gov.nih.tbi.dictionary.model.AbstractDataElement;
import gov.nih.tbi.dictionary.model.hibernate.Alias;
import gov.nih.tbi.dictionary.model.hibernate.Classification;
import gov.nih.tbi.dictionary.model.hibernate.DataElement;
import gov.nih.tbi.dictionary.model.hibernate.DiseaseElement;
import gov.nih.tbi.dictionary.model.hibernate.Domain;
import gov.nih.tbi.dictionary.model.hibernate.ExternalId;
import gov.nih.tbi.dictionary.model.hibernate.KeywordElement;
import gov.nih.tbi.dictionary.model.hibernate.MapElement;
import gov.nih.tbi.dictionary.model.hibernate.SubDomain;
import gov.nih.tbi.dictionary.model.hibernate.ValidationPlugin;
import gov.nih.tbi.dictionary.model.hibernate.ValueRange;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DATA_ELEMENT")
@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BasicDataElement
extends AbstractDataElement
implements Serializable {
    private static final long serialVersionUID = -7323629892299647432L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_ELEMENT_SEQ")
    @SequenceGenerator(name="DATA_ELEMENT_SEQ", sequenceName="DATA_ELEMENT_SEQ", allocationSize=1)
    private Long id;
    @Column(name="TITLE")
    private String title;
    @Column(name="ELEMENT_NAME")
    private String name;
    @Column(name="ELEMENT_SIZE")
    private Integer size;
    @Column(name="MAXIMUM_VALUE")
    private Integer maximumValue;
    @Column(name="MINIMUM_VALUE")
    private Integer minimumValue;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="SHORT_DESCRIPTION")
    private String shortDescription;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ELEMENT_TYPE_ID")
    private DataType type;
    @Column(name="COMMON_DATA_ELEMENT_FLAG")
    private Boolean commonFlag;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataElement", targetEntity=DiseaseElement.class, orphanRemoval=true)
    private Set<DiseaseElement> diseaseList;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="DOMAIN_ID")
    private Domain domain;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="SUB_DOMAIN")
    private SubDomain subDomain;

    public BasicDataElement fromMapElement(MapElement mapElement) {
        this.setId(mapElement.getDataElement().getId());
        this.setName(mapElement.getName());
        this.setSize(mapElement.getSize());
        this.setDescription(mapElement.getDescription());
        this.setShortDescription(mapElement.getShortDescription());
        this.setType(mapElement.getType());
        this.setCommonFlag(mapElement.getCommonFlag());
        this.setDiseaseList(mapElement.getDiseaseList());
        this.setDomain(mapElement.getDomain());
        this.setSubdomain(mapElement.getSubdomain());
        return this;
    }

    public BasicDataElement fromDataElement(DataElement dataElement) {
        this.setId(dataElement.getId());
        this.setName(dataElement.getName());
        this.setSize(dataElement.getSize());
        this.setDescription(dataElement.getDescription());
        this.setShortDescription(dataElement.getShortDescription());
        this.setType(dataElement.getType());
        this.setCommonFlag(dataElement.getCommonFlag());
        this.setDiseaseList(dataElement.getDiseaseList());
        this.setDomain(dataElement.getDomain());
        this.setSubdomain(dataElement.getSubdomain());
        return this;
    }

    @Override
    public Long getDataElementId() {
        return this.getId();
    }

    @Override
    public Long getMapElementId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ValueRange> getValueRangeList() {
        throw new UnsupportedOperationException("ValueRangeList does not exist in BasicDataElement");
    }

    @Override
    public void setValueRangeList(Set<ValueRange> valueRangeList) {
        throw new UnsupportedOperationException("ValueRangeList does not exist in BasicDataElement");
    }

    @Override
    public Set<KeywordElement> getKeywordList() {
        throw new UnsupportedOperationException("KeywordList does not exist in BasicDataElement");
    }

    @Override
    public void setKeywordList(Set<KeywordElement> keywordList) {
        throw new UnsupportedOperationException("KeywordList does not exist in BasicDataElement");
    }

    @Override
    public ValidationPlugin getValidator() {
        throw new UnsupportedOperationException("Validator does not exist in BasicDataElement");
    }

    @Override
    public void setValidator(ValidationPlugin validator) {
        throw new UnsupportedOperationException("Validator does not exist in BasicDataElement");
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public Integer getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public void setMaximumValue(Integer maximumValue) {
        this.maximumValue = maximumValue;
    }

    @Override
    public Integer getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public void setMinimumValue(Integer minimumValue) {
        this.minimumValue = minimumValue;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public void setType(DataType type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setCommonFlag(Boolean commonFlag) {
        this.commonFlag = commonFlag;
    }

    @Override
    public Boolean getCommonFlag() {
        return this.commonFlag;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFormat() {
        throw new UnsupportedOperationException("Format does not exist in BasicDataElement");
    }

    @Override
    public void setFormat(String format) {
        throw new UnsupportedOperationException("Format does not exist in BasicDataElement");
    }

    @Override
    public String getNotes() {
        throw new UnsupportedOperationException("Notes does not exist in BasicDataElement");
    }

    @Override
    public void setNotes(String notes) {
        throw new UnsupportedOperationException("Notes does not exist in BasicDataElement");
    }

    @Override
    public String getGuidelines() {
        throw new UnsupportedOperationException("Guilelines does not exist in BasicDataElement");
    }

    @Override
    public void setGuidelines(String guidelines) {
        throw new UnsupportedOperationException("Guidelines does not exist in BasicDataElement");
    }

    @Override
    public String getReferences() {
        throw new UnsupportedOperationException("References does not exist in BasicDataElement");
    }

    @Override
    public void setReferences(String references) {
        throw new UnsupportedOperationException("References does not exist in BasicDataElement");
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Classification getClassification() {
        throw new UnsupportedOperationException("Classification does not exist in BasicDataElement");
    }

    @Override
    public void setClassification(Classification classification) {
        throw new UnsupportedOperationException("Classification does not exist in BasicDataElement");
    }

    @Override
    public Set<DiseaseElement> getDiseaseList() {
        return this.diseaseList;
    }

    @Override
    public void setDiseaseList(Set<DiseaseElement> diseaseList) {
        if (this.diseaseList == null) {
            this.diseaseList = new HashSet<DiseaseElement>();
        }
        this.diseaseList.clear();
        if (diseaseList != null) {
            this.diseaseList.addAll(diseaseList);
        }
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public SubDomain getSubdomain() {
        return this.subDomain;
    }

    @Override
    public void setSubdomain(SubDomain subDomain) {
        this.subDomain = subDomain;
    }

    @Override
    public String getDocumentationUrl() {
        throw new UnsupportedOperationException("DocumentationUrl does not exist in BasicDataElement");
    }

    @Override
    public void setDocumentationUrl(String documentationUrl) {
        throw new UnsupportedOperationException("DocumentationUrl does not exist in BasicDataElement");
    }

    @Override
    public Long getDocumentationFileId() {
        throw new UnsupportedOperationException("DocumentationFileId does not exist in BasicDataElement");
    }

    @Override
    public void setDocumentationFileId(Long documentationFileId) {
        throw new UnsupportedOperationException("DocumentationFileId does not exist in BasicDataElement");
    }

    @Override
    public String getMeasurementType() {
        throw new UnsupportedOperationException("MeasurementType does not exist in BasicDataElement");
    }

    @Override
    public void setMeasurementType(String measurementType) {
        throw new UnsupportedOperationException("MeasurementType does not exist in BasicDataElement");
    }

    @Override
    public InputRestrictions getRestrictions() {
        throw new UnsupportedOperationException("Restrictions does not exist in BasicDataElement");
    }

    @Override
    public void setRestrictions(InputRestrictions restrictions) {
        throw new UnsupportedOperationException("Restrictions does not exist in BasicDataElement");
    }

    @Override
    public Set<ExternalId> getExternalIdSet() {
        throw new UnsupportedOperationException("ExternalId does not exist in BasicDataElement");
    }

    @Override
    public void setExternalIdSet(Set<ExternalId> externalIdSet) {
        throw new UnsupportedOperationException("ExternalId does not exist in BasicDataElement");
    }

    @Override
    public String getSuggestedQuestion() {
        throw new UnsupportedOperationException("SuggestedQuestion does not exist in BasicDataElement");
    }

    @Override
    public void setSuggestedQuestion(String suggestedQuestion) {
        throw new UnsupportedOperationException("SuggestedQuestion does not exist in BasicDataElement");
    }

    @Override
    public Set<Alias> getAliasList() {
        throw new UnsupportedOperationException("AliasList does not exist in BasicDataElement");
    }

    @Override
    public void setAliasList(Set<Alias> aliasList) {
        throw new UnsupportedOperationException("AliasList does not exist in BasicDataElement");
    }
}

