/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.model.hibernate;

import gov.nih.tbi.commons.model.DataType;
import gov.nih.tbi.commons.model.ExternalType;
import gov.nih.tbi.commons.model.InputRestrictions;
import gov.nih.tbi.dictionary.model.AbstractDataElement;
import gov.nih.tbi.dictionary.model.hibernate.Alias;
import gov.nih.tbi.dictionary.model.hibernate.Classification;
import gov.nih.tbi.dictionary.model.hibernate.DiseaseElement;
import gov.nih.tbi.dictionary.model.hibernate.Domain;
import gov.nih.tbi.dictionary.model.hibernate.ExternalId;
import gov.nih.tbi.dictionary.model.hibernate.KeywordElement;
import gov.nih.tbi.dictionary.model.hibernate.MeasuringUnit;
import gov.nih.tbi.dictionary.model.hibernate.SubDomain;
import gov.nih.tbi.dictionary.model.hibernate.ValidationPlugin;
import gov.nih.tbi.dictionary.model.hibernate.ValueRange;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DATA_ELEMENT")
@XmlType(namespace="http://tbi.nih.gov/DictionarySchema")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataElement
extends AbstractDataElement
implements Serializable {
    private static final long serialVersionUID = 7823075404093090117L;
    public static final String DOCUMENTATION_URL = "documentationUrl";
    public static final String DOCUMENTATION_FILE_ID = "documentationFileId";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_ELEMENT_SEQ")
    @SequenceGenerator(name="DATA_ELEMENT_SEQ", sequenceName="DATA_ELEMENT_SEQ", allocationSize=1)
    private Long id;
    @Column(name="ELEMENT_NAME")
    private String name;
    @Column(name="ELEMENT_SIZE")
    private Integer size;
    @Column(name="MAXIMUM_VALUE")
    private Integer maximumValue;
    @Column(name="MINIMUM_VALUE")
    private Integer minimumValue;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ELEMENT_TYPE_ID")
    private DataType type;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="INPUT_RESTRICTION_ID")
    private InputRestrictions restrictions;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="SHORT_DESCRIPTION")
    private String shortDescription;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="VALIDATION_PLUGIN_ID")
    private ValidationPlugin validator;
    @Column(name="FORMAT")
    private String format;
    @Column(name="NOTES")
    private String notes;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataElement", targetEntity=ValueRange.class, orphanRemoval=true)
    private Set<ValueRange> valueRangeList;
    @Column(name="GUIDELINES")
    private String guidelines;
    @Column(name="QUESTION")
    private String suggestedQuestion;
    @Column(name="REFERENCE")
    private String references;
    @Column(name="TITLE")
    private String title;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="CLASSIFICATION")
    private Classification classification;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataElement", targetEntity=DiseaseElement.class, orphanRemoval=true)
    private Set<DiseaseElement> diseaseList;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="DOMAIN_ID")
    private Domain domain;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="SUB_DOMAIN")
    private SubDomain subDomain;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="MEASURING_UNIT_ID")
    private MeasuringUnit measuringUnit;
    @Column(name="MEASUREMENT_TYPE")
    private String measurementType;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataElement", targetEntity=KeywordElement.class, orphanRemoval=true)
    private Set<KeywordElement> keywordList;
    @Column(name="DOCUMENTATION_URL")
    private String documentationUrl;
    @Column(name="DOCUMENTATION_FILE_ID")
    private Long documentationFileId;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataElement", targetEntity=ExternalId.class, orphanRemoval=true)
    private Set<ExternalId> externalIdSet;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataElement", targetEntity=Alias.class, orphanRemoval=true)
    private Set<Alias> aliasList;
    @Column(name="COMMON_DATA_ELEMENT_FLAG")
    private Boolean commonFlag;

    @Override
    public Long getDataElementId() {
        return this.getId();
    }

    @Override
    public Boolean getCommonFlag() {
        return this.commonFlag;
    }

    @Override
    public void setCommonFlag(Boolean commonFlag) {
        this.commonFlag = commonFlag;
    }

    @Override
    public Set<ExternalId> getExternalIdSet() {
        return this.externalIdSet;
    }

    public void setLoinc(String loincId) {
        if (this.externalIdSet == null) {
            this.externalIdSet = new HashSet<ExternalId>();
        }
        this.externalIdSet.add(new ExternalId(this, ExternalType.LOINC, loincId));
    }

    public ExternalId getLoinc() {
        if (this.externalIdSet != null) {
            for (ExternalId externalId : this.externalIdSet) {
                if (!ExternalType.LOINC.equals((Object)externalId.getType())) continue;
                return externalId;
            }
        }
        return null;
    }

    public void setCadsr(String cadsrId) {
        if (this.externalIdSet == null) {
            this.externalIdSet = new HashSet<ExternalId>();
        }
        this.externalIdSet.add(new ExternalId(this, ExternalType.CADSR, cadsrId));
    }

    public ExternalId getCadsr() {
        if (this.externalIdSet != null) {
            for (ExternalId externalId : this.externalIdSet) {
                if (!ExternalType.CADSR.equals((Object)externalId.getType())) continue;
                return externalId;
            }
        }
        return null;
    }

    public void setSnomed(String snomedId) {
        if (this.externalIdSet == null) {
            this.externalIdSet = new HashSet<ExternalId>();
        }
        this.externalIdSet.add(new ExternalId(this, ExternalType.SNOMED, snomedId));
    }

    public ExternalId getSnomed() {
        if (this.externalIdSet != null) {
            for (ExternalId externalId : this.externalIdSet) {
                if (!ExternalType.SNOMED.equals((Object)externalId.getType())) continue;
                return externalId;
            }
        }
        return null;
    }

    @Override
    public void setExternalIdSet(Set<ExternalId> externalIdSet) {
        if (this.externalIdSet == null) {
            this.externalIdSet = new HashSet<ExternalId>();
        }
        this.externalIdSet.clear();
        if (externalIdSet != null) {
            for (ExternalId externalId : externalIdSet) {
                if (externalId.getDataElement() != null) continue;
                externalId.setDataElement(this);
            }
            this.externalIdSet.addAll(externalIdSet);
        }
    }

    public MeasuringUnit getMeasuringUnit() {
        return this.measuringUnit;
    }

    public void setMeasuringUnit(MeasuringUnit measuringUnit) {
        this.measuringUnit = measuringUnit;
    }

    @Override
    public String getMeasurementType() {
        return this.measurementType;
    }

    @Override
    public void setMeasurementType(String measurementType) {
        this.measurementType = measurementType;
    }

    @Override
    public InputRestrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    public void setRestrictions(InputRestrictions restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public Long getMapElementId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public ValidationPlugin getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(ValidationPlugin validator) {
        this.validator = validator;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setValueRangeList(Set<ValueRange> newValueRangeList) {
        if (this.valueRangeList == null) {
            this.valueRangeList = new HashSet<ValueRange>();
        }
        this.valueRangeList.clear();
        if (newValueRangeList != null) {
            this.valueRangeList.addAll(newValueRangeList);
        }
    }

    @Override
    public Set<ValueRange> getValueRangeList() {
        if (this.valueRangeList == null) {
            this.valueRangeList = new LinkedHashSet<ValueRange>();
        }
        return this.valueRangeList;
    }

    @Override
    public void setKeywordList(Set<KeywordElement> keywordList) {
        if (this.keywordList == null) {
            this.keywordList = new HashSet<KeywordElement>();
        }
        this.keywordList.clear();
        if (keywordList != null) {
            this.keywordList.addAll(keywordList);
        }
    }

    @Override
    public String getGuidelines() {
        return this.guidelines;
    }

    @Override
    public void setGuidelines(String guidelines) {
        this.guidelines = guidelines;
    }

    @Override
    public String getSuggestedQuestion() {
        return this.suggestedQuestion;
    }

    @Override
    public void setSuggestedQuestion(String suggestedQuestion) {
        this.suggestedQuestion = suggestedQuestion;
    }

    @Override
    public String getReferences() {
        return this.references;
    }

    @Override
    public void setReferences(String references) {
        this.references = references;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public Integer getSize() {
        if (this.size == null && DataType.ALPHANUMERIC.equals((Object)this.type) && !InputRestrictions.FREE_FORM.equals((Object)this.restrictions)) {
            int length = 0;
            if (this.getValueRangeList() != null) {
                for (ValueRange vr : this.getValueRangeList()) {
                    if (length >= vr.getValueRange().length()) continue;
                    length = vr.getValueRange().length();
                }
            }
            this.size = length;
        }
        return this.size;
    }

    @Override
    public Integer getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public void setMaximumValue(Integer maximumValue) {
        this.maximumValue = maximumValue;
    }

    @Override
    public Integer getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public void setMinimumValue(Integer minimumValue) {
        this.minimumValue = minimumValue;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public void setType(DataType type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getAliases() {
        throw new UnsupportedOperationException("Aliases field does not exist in DataElement");
    }

    public void setAliases(String aliases) {
        throw new UnsupportedOperationException("Aliases field does not exist in DataElement");
    }

    @Override
    public Classification getClassification() {
        return this.classification;
    }

    @Override
    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    @Override
    public Set<DiseaseElement> getDiseaseList() {
        return this.diseaseList;
    }

    @Override
    public void setDiseaseList(Set<DiseaseElement> diseaseList) {
        if (this.diseaseList == null) {
            this.diseaseList = new HashSet<DiseaseElement>();
        }
        this.diseaseList.clear();
        if (diseaseList != null) {
            this.diseaseList.addAll(diseaseList);
        }
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public SubDomain getSubdomain() {
        return this.subDomain;
    }

    @Override
    public void setSubdomain(SubDomain subDomain) {
        this.subDomain = subDomain;
    }

    @Override
    public Set<KeywordElement> getKeywordList() {
        if (this.keywordList == null) {
            this.keywordList = new HashSet<KeywordElement>();
        }
        return this.keywordList;
    }

    @Override
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Override
    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    @Override
    public Long getDocumentationFileId() {
        return this.documentationFileId;
    }

    @Override
    public void setDocumentationFileId(Long documentationFileId) {
        this.documentationFileId = documentationFileId;
    }

    @Override
    public Set<Alias> getAliasList() {
        if (this.aliasList == null) {
            this.aliasList = new LinkedHashSet<Alias>();
        }
        return this.aliasList;
    }

    @Override
    public void setAliasList(Set<Alias> aliasList) {
        this.aliasList = aliasList;
    }

    public String toString() {
        return "DataElement [description=" + this.description + ", format=" + this.format + ", id=" + this.getId() + ", ke ywordList=" + this.keywordList + ", name=" + this.getName() + ", notes=" + this.notes + ", shortDescription=" + this.shortDescription + ", size=" + this.getSize() + ", valueRange=" + this.valueRangeList + "]";
    }
}

