/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.model.hibernate;

import gov.nih.tbi.dictionary.model.AbstractDataStructure;
import gov.nih.tbi.dictionary.model.hibernate.DiseaseStructure;
import gov.nih.tbi.dictionary.model.hibernate.MapElement;
import gov.nih.tbi.dictionary.model.hibernate.RepeatableGroup;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DATA_STRUCTURE")
@XmlType(namespace="http://tbi.nih.gov/DictionarySchema")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataStructure
extends AbstractDataStructure
implements Serializable {
    private static final long serialVersionUID = 2830307803690132318L;
    static Logger logger = Logger.getLogger(DataStructure.class);
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataStructure", targetEntity=RepeatableGroup.class, orphanRemoval=true)
    @OrderBy(value="name")
    private Set<RepeatableGroup> repeatableGroups;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataStructure", targetEntity=DiseaseStructure.class, orphanRemoval=true)
    private Set<DiseaseStructure> diseaseList;

    public Set<RepeatableGroup> getRepeatableGroups() {
        if (this.repeatableGroups == null) {
            this.repeatableGroups = new LinkedHashSet<RepeatableGroup>();
        }
        return this.repeatableGroups;
    }

    public void setRepeatableGroups(Set<RepeatableGroup> repeatableGroups) {
        if (this.repeatableGroups == null) {
            this.repeatableGroups = new LinkedHashSet<RepeatableGroup>();
        }
        this.repeatableGroups.clear();
        if (repeatableGroups != null) {
            this.repeatableGroups.addAll(repeatableGroups);
        }
    }

    @Override
    public Set<DiseaseStructure> getDiseaseList() {
        return this.diseaseList;
    }

    @Override
    public void setDiseaseList(Set<DiseaseStructure> diseaseList) {
        this.diseaseList = diseaseList;
    }

    public Set<MapElement> getDataElements() {
        if (this.repeatableGroups == null) {
            this.repeatableGroups = new LinkedHashSet<RepeatableGroup>();
        }
        LinkedHashSet<MapElement> elements = new LinkedHashSet<MapElement>();
        for (RepeatableGroup group : this.repeatableGroups) {
            for (MapElement mapElement : group.getMapElements()) {
                elements.add(mapElement);
            }
        }
        return elements;
    }

    public Integer getSize() {
        return this.repeatableGroups.size();
    }
}

