/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.model.hibernate;

import gov.nih.tbi.commons.model.DataType;
import gov.nih.tbi.commons.model.InputRestrictions;
import gov.nih.tbi.commons.model.RequiredType;
import gov.nih.tbi.dictionary.model.AbstractDataElement;
import gov.nih.tbi.dictionary.model.hibernate.Alias;
import gov.nih.tbi.dictionary.model.hibernate.Classification;
import gov.nih.tbi.dictionary.model.hibernate.DataElement;
import gov.nih.tbi.dictionary.model.hibernate.DiseaseElement;
import gov.nih.tbi.dictionary.model.hibernate.Domain;
import gov.nih.tbi.dictionary.model.hibernate.ExternalId;
import gov.nih.tbi.dictionary.model.hibernate.KeywordElement;
import gov.nih.tbi.dictionary.model.hibernate.MeasuringUnit;
import gov.nih.tbi.dictionary.model.hibernate.RepeatableGroup;
import gov.nih.tbi.dictionary.model.hibernate.SubDomain;
import gov.nih.tbi.dictionary.model.hibernate.ValidationPlugin;
import gov.nih.tbi.dictionary.model.hibernate.ValueRange;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="MAP_ELEMENT")
@XmlType(namespace="http://tbi.nih.gov/DictionarySchema")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MapElement
extends AbstractDataElement
implements Serializable {
    private static final long serialVersionUID = 2352968968139244483L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MAP_ELEMENT_SEQ")
    @SequenceGenerator(name="MAP_ELEMENT_SEQ", sequenceName="MAP_ELEMENT_SEQ", allocationSize=1)
    private Long id;
    @XmlTransient
    @ManyToOne(targetEntity=RepeatableGroup.class)
    @JoinColumn(name="REPEATABLE_GROUP_ID")
    private RepeatableGroup repeatableGroup;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="DATA_ELEMENT_ID")
    private DataElement dataElement;
    @Column(name="POSITION")
    private Integer position;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="REQUIRED_TYPE_ID")
    private RequiredType requiredTypeId;

    public MapElement(MapElement mapElement) {
        this.repeatableGroup = mapElement.getRepeatableGroup();
        this.dataElement = mapElement.getDataElement();
        this.position = mapElement.getPosition();
        this.requiredTypeId = mapElement.getRequiredType();
    }

    public MapElement() {
    }

    public MapElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public RepeatableGroup getRepeatableGroup() {
        return this.repeatableGroup;
    }

    public void setRepeatableGroup(RepeatableGroup repeatableGroup) {
        this.repeatableGroup = repeatableGroup;
    }

    public DataElement getDataElement() {
        return this.dataElement;
    }

    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer position) {
        this.position = position;
    }

    @Override
    public RequiredType getRequiredType() {
        return this.requiredTypeId;
    }

    @Override
    public void setRequiredType(RequiredType requiredType) {
        this.requiredTypeId = requiredType;
    }

    @Override
    public ValidationPlugin getValidator() {
        return this.dataElement.getValidator();
    }

    @Override
    public void setValidator(ValidationPlugin validator) {
        this.dataElement.setValidator(validator);
    }

    @Override
    public String getDescription() {
        return this.dataElement.getDescription();
    }

    @Override
    public String getFormat() {
        return this.dataElement.getFormat();
    }

    @Override
    public String getNotes() {
        return this.dataElement.getNotes();
    }

    @Override
    public String getShortDescription() {
        return this.dataElement.getShortDescription();
    }

    @Override
    public Integer getSize() {
        return this.dataElement.getSize();
    }

    @Override
    public Integer getMaximumValue() {
        return this.dataElement.getMaximumValue();
    }

    @Override
    public Integer getMinimumValue() {
        return this.dataElement.getMinimumValue();
    }

    @Override
    public Set<ValueRange> getValueRangeList() {
        return this.dataElement.getValueRangeList();
    }

    @Override
    public void setDescription(String description) {
        this.dataElement.setDescription(description);
    }

    @Override
    public void setFormat(String format) {
        this.dataElement.setFormat(format);
    }

    @Override
    public void setNotes(String notes) {
        this.dataElement.setNotes(notes);
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.dataElement.setShortDescription(shortDescription);
    }

    @Override
    public void setSize(Integer size) {
        this.dataElement.setSize(size);
    }

    @Override
    public void setMaximumValue(Integer maximumValue) {
        this.dataElement.setMaximumValue(maximumValue);
    }

    @Override
    public void setMinimumValue(Integer minimumValue) {
        this.dataElement.setMinimumValue(minimumValue);
    }

    @Override
    public void setValueRangeList(Set<ValueRange> valueRangeList) {
        this.dataElement.setValueRangeList(valueRangeList);
    }

    @Override
    public void setType(DataType type) {
        this.dataElement.setType(type);
    }

    @Override
    public DataType getType() {
        return this.dataElement.getType();
    }

    @Override
    public Long getDataElementId() {
        return this.dataElement.getDataElementId();
    }

    @Override
    public Long getMapElementId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.dataElement.getName();
    }

    @Override
    public void setName(String name) {
        this.dataElement.setName(name);
    }

    @Override
    public Set<KeywordElement> getKeywordList() {
        return this.dataElement.getKeywordList();
    }

    @Override
    public void setKeywordList(Set<KeywordElement> keywordList) {
        this.dataElement.setKeywordList(keywordList);
    }

    @Override
    public String getGuidelines() {
        return this.dataElement.getGuidelines();
    }

    @Override
    public void setGuidelines(String guidelines) {
        this.dataElement.setGuidelines(guidelines);
    }

    @Override
    public String getReferences() {
        return this.dataElement.getReferences();
    }

    @Override
    public void setReferences(String references) {
        this.dataElement.setReferences(references);
    }

    @Override
    public String getTitle() {
        return this.dataElement.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.dataElement.setTitle(title);
    }

    @Override
    public Classification getClassification() {
        return this.dataElement.getClassification();
    }

    @Override
    public void setClassification(Classification classification) {
        this.dataElement.setClassification(classification);
    }

    @Override
    public Set<DiseaseElement> getDiseaseList() {
        return this.dataElement.getDiseaseList();
    }

    @Override
    public void setDiseaseList(Set<DiseaseElement> disease) {
        this.dataElement.setDiseaseList(disease);
    }

    @Override
    public Domain getDomain() {
        return this.dataElement.getDomain();
    }

    @Override
    public void setDomain(Domain domain) {
        this.dataElement.setDomain(domain);
    }

    @Override
    public SubDomain getSubdomain() {
        return this.dataElement.getSubdomain();
    }

    @Override
    public void setSubdomain(SubDomain subdomain) {
        this.dataElement.setSubdomain(subdomain);
    }

    @Override
    public String getDocumentationUrl() {
        return this.dataElement.getDocumentationUrl();
    }

    @Override
    public void setDocumentationUrl(String documentationUrl) {
        this.dataElement.setDocumentationUrl(documentationUrl);
    }

    @Override
    public Long getDocumentationFileId() {
        return this.dataElement.getDocumentationFileId();
    }

    @Override
    public void setDocumentationFileId(Long documentationFileId) {
        this.dataElement.setDocumentationFileId(documentationFileId);
    }

    public String toString() {
        return "MapElement [dataElement=" + this.dataElement + ", repeatableGroup=" + this.repeatableGroup + ", id=" + this.id + ", position=" + this.position + ", requiredTypeId=" + (Object)((Object)this.requiredTypeId) + "]";
    }

    @Override
    public String getMeasurementType() {
        return this.dataElement.getMeasurementType();
    }

    @Override
    public void setMeasurementType(String measurementType) {
        this.dataElement.setMeasurementType(measurementType);
    }

    @Override
    public InputRestrictions getRestrictions() {
        return this.dataElement.getRestrictions();
    }

    @Override
    public void setRestrictions(InputRestrictions restrictions) {
        this.dataElement.setRestrictions(restrictions);
    }

    @Override
    public Set<ExternalId> getExternalIdSet() {
        return this.dataElement.getExternalIdSet();
    }

    @Override
    public void setExternalIdSet(Set<ExternalId> externalIdSet) {
        this.dataElement.setExternalIdSet(externalIdSet);
    }

    public ExternalId getLoinc() {
        return this.dataElement.getLoinc();
    }

    public void setLoinc(String loincId) {
        this.dataElement.setLoinc(loincId);
    }

    public ExternalId getSnomed() {
        return this.dataElement.getSnomed();
    }

    public void setSnomed(String snomedId) {
        this.dataElement.setSnomed(snomedId);
    }

    public ExternalId getCadsr() {
        return this.dataElement.getCadsr();
    }

    public void setCadsr(String cadsrId) {
        this.dataElement.setCadsr(cadsrId);
    }

    @Override
    public void setCommonFlag(Boolean commonFlag) {
        this.dataElement.setCommonFlag(commonFlag);
    }

    @Override
    public Boolean getCommonFlag() {
        return this.dataElement.getCommonFlag();
    }

    public void setMeasuringUnit(MeasuringUnit measuringUnit) {
        this.dataElement.setMeasuringUnit(measuringUnit);
    }

    public MeasuringUnit getMeasuringUnit() {
        return this.dataElement.getMeasuringUnit();
    }

    @Override
    public String getSuggestedQuestion() {
        return this.dataElement.getSuggestedQuestion();
    }

    @Override
    public void setSuggestedQuestion(String suggestedQuestion) {
        this.dataElement.setSuggestedQuestion(suggestedQuestion);
    }

    @Override
    public Set<Alias> getAliasList() {
        return this.dataElement.getAliasList();
    }

    @Override
    public void setAliasList(Set<Alias> aliasList) {
        this.dataElement.setAliasList(aliasList);
    }
}

