/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.repository.model.hibernate;

import gov.nih.tbi.dictionary.model.AbstractDataStructure;
import gov.nih.tbi.dictionary.model.hibernate.BasicDataStructure;
import gov.nih.tbi.repository.model.AbstractDataStoreInfo;
import gov.nih.tbi.repository.model.hibernate.DataStoreBinaryInfo;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="DATASTORE_INFO")
public class BasicDataStoreInfo
extends AbstractDataStoreInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATASTORE_INFO_SEQ")
    @SequenceGenerator(name="DATASTORE_INFO_SEQ", sequenceName="DATASTORE_INFO_SEQ", allocationSize=1)
    private long id;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="DATA_STRUCTURE_ID")
    private BasicDataStructure dataStructure;
    @Column(name="TABULAR")
    private boolean tabular;
    @Column(name="FEDERATED")
    private boolean federated;
    @OneToOne
    @JoinColumn(name="DATASTORE_BINARY_INFO_ID")
    private DataStoreBinaryInfo binaryDataStore;
    @Column(name="ARCHIVED")
    private boolean archived;

    public AbstractDataStructure getDataStructure() {
        return this.dataStructure;
    }

    public void setDataStructure(AbstractDataStructure dataStructure) {
        if (!(dataStructure instanceof BasicDataStructure)) {
            throw new ClassCastException("Cannot cast DataStructure to BasicDataStructure.");
        }
        this.dataStructure = (BasicDataStructure)dataStructure;
    }

    public BasicDataStoreInfo() {
        this.archived = false;
    }

    public BasicDataStoreInfo(BasicDataStructure dataStructure, boolean tabular, boolean federated) {
        this.dataStructure = dataStructure;
        this.tabular = tabular;
        this.federated = federated;
        this.binaryDataStore = null;
        this.archived = false;
    }

    public BasicDataStoreInfo(DataStoreBinaryInfo binaryDataStore, boolean tabular, boolean federated) {
        this.dataStructure = null;
        this.tabular = tabular;
        this.federated = federated;
        this.binaryDataStore = binaryDataStore;
        this.archived = false;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isTabular() {
        return this.tabular;
    }

    public void setTabular(boolean tabular) {
        this.tabular = tabular;
    }

    public boolean isFederated() {
        return this.federated;
    }

    public void setFederated(boolean federated) {
        this.federated = federated;
    }

    public DataStoreBinaryInfo getBinaryDataStore() {
        return this.binaryDataStore;
    }

    public void setBinaryDataStore(DataStoreBinaryInfo binaryDataStore) {
        this.binaryDataStore = binaryDataStore;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }
}

