/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.repository.model.hibernate;

import gov.nih.tbi.commons.model.RecruitmentStatus;
import gov.nih.tbi.commons.model.StudyStatus;
import gov.nih.tbi.repository.model.AbstractStudy;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="STUDY")
public class BasicStudy
extends AbstractStudy
implements Serializable {
    private static final long serialVersionUID = -3963107794602437604L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDY_SEQ")
    @SequenceGenerator(name="STUDY_SEQ", sequenceName="STUDY_SEQ", allocationSize=1)
    private Long id;
    @Column(name="TITLE")
    private String title;
    @Column(name="STUDY_ID")
    private String studyId;
    @Column(name="ABSTRACT")
    private String abstractText;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="RECRUITMENT_STATUS_ID")
    private RecruitmentStatus recruitmentStatus;
    @Column(name="PRINCIPAL_INVESTIGATOR")
    private String principalInvestigator;
    @Column(name="PRINCIPAL_INVESTIGATOR_EMAIL")
    private String principalInvestigatorEmail;
    @Column(name="DATA_MANAGER")
    private String dataManager;
    @Column(name="DATA_MANAGER_EMAIL")
    private String dataManagerEmail;
    @Column(name="DATE_CREATED")
    private Date dateCreated;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STUDY_STATUS_ID")
    private StudyStatus studyStatus;

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getStudyId() {
        return this.studyId;
    }

    public String getReadableStudyId() {
        return "FITBIRSDY" + this.studyId;
    }

    public String getAbstractText() {
        return this.abstractText;
    }

    public RecruitmentStatus getRecruitmentStatus() {
        return this.recruitmentStatus;
    }

    public String getPrincipalInvestigator() {
        return this.principalInvestigator;
    }

    public String getDataManager() {
        return this.dataManager;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStudyId(String studyId) {
        this.studyId = studyId;
    }

    public void setAbstractText(String abstractText) {
        this.abstractText = abstractText;
    }

    public void setRecruitmentStatus(RecruitmentStatus recruitmentStatus) {
        this.recruitmentStatus = recruitmentStatus;
    }

    public void setPrincipalInvestigator(String principalInvestigator) {
        this.principalInvestigator = principalInvestigator;
    }

    public void setDataManager(String dataManager) {
        this.dataManager = dataManager;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getPrincipalInvestigatorEmail() {
        return this.principalInvestigatorEmail;
    }

    public String getDataManagerEmail() {
        return this.dataManagerEmail;
    }

    public void setPrincipalInvestigatorEmail(String principalInvestigatorEmail) {
        this.principalInvestigatorEmail = principalInvestigatorEmail;
    }

    public void setDataManagerEmail(String dataManagerEmail) {
        this.dataManagerEmail = dataManagerEmail;
    }

    public StudyStatus getStudyStatus() {
        return this.studyStatus;
    }

    public void setStudyStatus(StudyStatus studyStatus) {
        this.studyStatus = studyStatus;
    }

    public boolean getIsPrivate() {
        return StudyStatus.PRIVATE.equals((Object)this.studyStatus);
    }

    public boolean getIsPublic() {
        return StudyStatus.PUBLIC.equals((Object)this.studyStatus);
    }
}

