/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.repository.model.hibernate;

import gov.nih.tbi.dictionary.model.AbstractDataStructure;
import gov.nih.tbi.dictionary.model.hibernate.DataStructure;
import gov.nih.tbi.repository.model.AbstractDataStoreInfo;
import gov.nih.tbi.repository.model.hibernate.DataStoreBinaryInfo;
import gov.nih.tbi.repository.model.hibernate.DataStoreTabularInfo;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DATASTORE_INFO")
public class DataStoreInfo
extends AbstractDataStoreInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATASTORE_INFO_SEQ")
    @SequenceGenerator(name="DATASTORE_INFO_SEQ", sequenceName="DATASTORE_INFO_SEQ", allocationSize=1)
    private long id;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="DATA_STRUCTURE_ID")
    private DataStructure dataStructure;
    @Column(name="TABULAR")
    private boolean tabular;
    @Column(name="FEDERATED")
    private boolean federated;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataStoreInfo", targetEntity=DataStoreTabularInfo.class)
    private Set<DataStoreTabularInfo> dataStoreTabularInfos;
    @OneToOne
    @JoinColumn(name="DATASTORE_BINARY_INFO_ID")
    private DataStoreBinaryInfo binaryDataStore;
    @Column(name="ARCHIVED")
    private boolean archived;

    @Override
    public AbstractDataStructure getDataStructure() {
        return this.dataStructure;
    }

    @Override
    public void setDataStructure(AbstractDataStructure dataStructure) {
        if (!(dataStructure instanceof DataStructure)) {
            throw new ClassCastException("Cannot cast BasicDataStructure to DataStructure.");
        }
        this.dataStructure = (DataStructure)dataStructure;
    }

    public DataStoreInfo() {
        this.archived = false;
    }

    public DataStoreInfo(DataStructure dataStructure, boolean tabular, boolean federated) {
        this.dataStructure = dataStructure;
        this.tabular = tabular;
        this.federated = federated;
        this.binaryDataStore = null;
        this.archived = false;
    }

    public DataStoreInfo(DataStoreBinaryInfo binaryDataStore, boolean tabular, boolean federated) {
        this.dataStructure = null;
        this.tabular = tabular;
        this.federated = federated;
        this.binaryDataStore = binaryDataStore;
        this.archived = false;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public boolean isTabular() {
        return this.tabular;
    }

    @Override
    public void setTabular(boolean tabular) {
        this.tabular = tabular;
    }

    @Override
    public boolean isFederated() {
        return this.federated;
    }

    @Override
    public void setFederated(boolean federated) {
        this.federated = federated;
    }

    public Set<DataStoreTabularInfo> getDataStoreTabularInfos() {
        if (this.dataStoreTabularInfos == null) {
            this.dataStoreTabularInfos = new HashSet<DataStoreTabularInfo>();
        }
        return this.dataStoreTabularInfos;
    }

    public void setDataStoreTabularInfos(Set<DataStoreTabularInfo> dataStoreTabularInfos) {
        this.dataStoreTabularInfos = dataStoreTabularInfos;
    }

    @Override
    public DataStoreBinaryInfo getBinaryDataStore() {
        return this.binaryDataStore;
    }

    @Override
    public void setBinaryDataStore(DataStoreBinaryInfo binaryDataStore) {
        this.binaryDataStore = binaryDataStore;
    }

    @Override
    public boolean isArchived() {
        return this.archived;
    }

    @Override
    public void setArchived(boolean archived) {
        this.archived = archived;
    }
}

