/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.repository.model.hibernate;

import gov.nih.tbi.commons.model.DatasetFileStatus;
import gov.nih.tbi.commons.model.DatasetStatus;
import gov.nih.tbi.commons.model.hibernate.User;
import gov.nih.tbi.repository.model.AbstractDataset;
import gov.nih.tbi.repository.model.SubmissionType;
import gov.nih.tbi.repository.model.hibernate.BasicStudy;
import gov.nih.tbi.repository.model.hibernate.DatasetFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DATASET")
public class Dataset
extends AbstractDataset
implements Serializable {
    private static final long serialVersionUID = -2627365259205294466L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATASET_SEQ")
    @SequenceGenerator(name="DATASET_SEQ", sequenceName="DATASET_SEQ", allocationSize=1)
    private Long id;
    @Column(name="NAME")
    private String name;
    @ManyToOne
    @JoinColumn(name="SUBMITTER_ID")
    private User submitter;
    @Column(name="SUBMIT_DATE")
    private Date submitDate;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="DATASET_STATUS_ID")
    private DatasetStatus datasetStatus;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="DATASET_REQUEST_STATUS_ID")
    private DatasetStatus datasetRequestStatus;
    @Column(name="DATASET_ID")
    private String datasetId;
    @ManyToOne
    @JoinColumn(name="STUDY_ID")
    private BasicStudy study;
    @ManyToOne
    @JoinColumn(name="REVIEWER_ID")
    private User reviewer;
    @ManyToOne
    @JoinColumn(name="VERIFIER_ID")
    private User verifier;
    @Column(name="PUBLICATION_DATE")
    private Date publicationDate;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="dataset", targetEntity=DatasetFile.class, orphanRemoval=true)
    @XmlTransient
    private Set<DatasetFile> datasetFileSet = new HashSet<DatasetFile>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public User getSubmitter() {
        return this.submitter;
    }

    @Override
    public Date getSubmitDate() {
        return this.submitDate;
    }

    @Override
    public DatasetStatus getDatasetStatus() {
        if (DatasetStatus.UPLOADING.equals((Object)this.datasetStatus) && this.getPendingDatasetFile().isEmpty()) {
            this.datasetStatus = DatasetStatus.LOADING;
        }
        return this.datasetStatus;
    }

    @Override
    public BasicStudy getStudy() {
        return this.study;
    }

    public Set<DatasetFile> getDatasetFileSet() {
        return this.datasetFileSet;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setSubmitter(User submitter) {
        this.submitter = submitter;
    }

    @Override
    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    @Override
    public void setDatasetStatus(DatasetStatus datasetStatus) {
        this.datasetStatus = datasetStatus;
    }

    @Override
    public void setStudy(BasicStudy study) {
        this.study = study;
    }

    public void setDatasetFileSet(Set<DatasetFile> datasetFileSet) {
        if (this.datasetFileSet == null) {
            this.datasetFileSet = new HashSet<DatasetFile>();
        }
        this.datasetFileSet.clear();
        if (datasetFileSet != null) {
            this.datasetFileSet.addAll(datasetFileSet);
        }
    }

    @Override
    public String getDatasetId() {
        return this.datasetId;
    }

    @Override
    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getReadableDatasetId() {
        return "FITBIRDATA" + this.datasetId;
    }

    @Override
    public Date getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public void setPublicationDate(Date publicationDate) {
        this.publicationDate = publicationDate;
    }

    @Override
    public DatasetStatus getDatasetRequestStatus() {
        return this.datasetRequestStatus;
    }

    @Override
    public void setDatasetRequestStatus(DatasetStatus datasetRequestStatus) {
        this.datasetRequestStatus = datasetRequestStatus;
    }

    public List<SubmissionType> getFileTypeList() {
        ArrayList<SubmissionType> out = new ArrayList<SubmissionType>();
        for (DatasetFile file : this.datasetFileSet) {
            if (file.getFileType() == null || out.contains((Object)file.getFileType())) continue;
            out.add(file.getFileType());
        }
        return out;
    }

    public String getFileTypeString() {
        List<SubmissionType> fileTypeList = this.getFileTypeList();
        String out = "";
        if (fileTypeList != null) {
            for (int i = 0; i < fileTypeList.size(); ++i) {
                if (i != 0) {
                    out = out + ", ";
                }
                out = out + fileTypeList.get(i).getType();
            }
        }
        return out;
    }

    @Override
    public User getReviewer() {
        return this.reviewer;
    }

    @Override
    public User getVerifier() {
        return this.verifier;
    }

    @Override
    public void setReviewer(User reviewer) {
        this.reviewer = reviewer;
    }

    @Override
    public void setVerifier(User verifier) {
        this.verifier = verifier;
    }

    public List<DatasetFile> getPendingDatasetFile() {
        ArrayList<DatasetFile> fileList = new ArrayList<DatasetFile>();
        for (DatasetFile datasetFile : this.datasetFileSet) {
            if (!DatasetFileStatus.PENDING.equals((Object)datasetFile.getDatasetFileStatus())) continue;
            fileList.add(datasetFile);
        }
        return fileList;
    }
}

