/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ArrayTypePrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ArrayTypePrinter();

    protected ArrayTypePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST child = node.getFirstChild();
        boolean bracketsAfterIdentifier = AbstractPrinter.settings.getBoolean(ConventionKeys.ARRAY_BRACKETS_AFTER_IDENT, false);
        if (child != null) {
            while (child != null) {
                switch (child.getType()) {
                    case 33: {
                        if (AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_BRACKETS, false)) {
                            out.print("[ ", 77);
                            PrinterFactory.create(child, out).print(child, out);
                            out.print(" ]", 78);
                            break;
                        }
                        out.print("[", 77);
                        PrinterFactory.create(child, out).print(child, out);
                        out.print("]", 78);
                        break;
                    }
                    case 22: {
                        this.print(child, out);
                        if (child.getNextSibling() != null) break;
                        if (bracketsAfterIdentifier && this.canMoveBrackets(node)) {
                            ++out.state.arrayBrackets;
                            break;
                        }
                        out.print("[]", 78);
                        break;
                    }
                    default: {
                        PrinterFactory.create(child, out).print(child, out);
                        if (bracketsAfterIdentifier && this.canMoveBrackets(node)) {
                            ++out.state.arrayBrackets;
                            break;
                        }
                        if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) {
                            out.print(" []", 22);
                            break;
                        }
                        out.print("[]", 78);
                    }
                }
                child = child.getNextSibling();
            }
        } else if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) {
            out.print(" []", 22);
        } else {
            out.print("[]", 78);
        }
        out.last = 22;
    }

    private boolean canMoveBrackets(AST node) {
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            case 18: {
                switch (parent.getParent().getType()) {
                    case 14: 
                    case 28: 
                    case 155: {
                        return false;
                    }
                }
                break;
            }
            case 28: 
            case 168: {
                return false;
            }
            case 22: {
                return this.canMoveBrackets(parent);
            }
        }
        AST next = node.getNextSibling();
        if (next != null) {
            switch (next.getType()) {
                case 111: {
                    return false;
                }
            }
        }
        return true;
    }
}

