/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibApplications.OpenGLApplication;

import WildMagic.LibApplications.OpenGLApplication.Application;
import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibGraphics.Rendering.FrameBuffer;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Shaders.PixelProgramCatalog;
import WildMagic.LibGraphics.Shaders.VertexProgramCatalog;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;

public abstract class JavaApplication
extends Application
implements KeyListener,
Serializable {
    private static final long serialVersionUID = 1996577376043628196L;
    protected String m_acWindowTitle;
    protected int m_iXPosition;
    protected int m_iYPosition;
    protected int m_iWidth;
    protected int m_iHeight;
    protected ColorRGBA m_kBackgroundColor;
    protected FrameBuffer.FormatType m_eFormat = FrameBuffer.FormatType.FT_FORMAT_RGBA;
    protected FrameBuffer.DepthType m_eDepth = FrameBuffer.DepthType.DT_DEPTH_24;
    protected FrameBuffer.StencilType m_eStencil = FrameBuffer.StencilType.ST_STENCIL_8;
    protected FrameBuffer.BufferingType m_eBuffering = FrameBuffer.BufferingType.BT_BUFFERED_DOUBLE;
    protected FrameBuffer.MultisamplingType m_eMultisampling = FrameBuffer.MultisamplingType.MT_SAMPLING_NONE;
    protected Renderer m_pkRenderer = null;

    public JavaApplication(String acWindowTitle, int iXPosition, int iYPosition, int iWidth, int iHeight, ColorRGBA rkBackgroundColor) {
        this.m_acWindowTitle = new String(acWindowTitle);
        this.m_iXPosition = iXPosition;
        this.m_iYPosition = iYPosition;
        this.m_iWidth = iWidth;
        this.m_iHeight = iHeight;
        this.m_kBackgroundColor = new ColorRGBA(rkBackgroundColor);
    }

    public void dispose() {
        this.m_acWindowTitle = null;
        this.m_kBackgroundColor = null;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.dispose();
            this.m_pkRenderer = null;
        }
    }

    public int GetHeight() {
        return this.m_iHeight;
    }

    public Renderer GetRenderer() {
        return this.m_pkRenderer;
    }

    public int GetWidth() {
        return this.m_iWidth;
    }

    public String GetWindowTitle() {
        return this.m_acWindowTitle;
    }

    public int GetXPosition() {
        return this.m_iXPosition;
    }

    public int GetYPosition() {
        return this.m_iYPosition;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void OnDisplay() {
    }

    public void OnIdle() {
    }

    public boolean OnInitialize() {
        this.m_pkRenderer.SetBackgroundColor(this.m_kBackgroundColor);
        return true;
    }

    public void OnMove(int iX, int iY) {
        this.m_iXPosition = iX;
        this.m_iYPosition = iY;
    }

    public boolean OnPrecreate() {
        return true;
    }

    public void OnResize(int iWidth, int iHeight) {
        if (iWidth > 0 && iHeight > 0) {
            if (this.m_pkRenderer != null) {
                this.m_pkRenderer.Resize(iWidth, iHeight);
            }
            this.m_iWidth = iWidth;
            this.m_iHeight = iHeight;
        }
    }

    public void OnTerminate() {
        assert (VertexProgramCatalog.GetActive() != null);
        VertexProgramCatalog.GetActive().SetInformation(this.m_pkRenderer, "", '\u0000');
        assert (PixelProgramCatalog.GetActive() != null);
        PixelProgramCatalog.GetActive().SetInformation(this.m_pkRenderer, "", '\u0000');
        this.m_pkRenderer = null;
    }

    public void SetRenderer(Renderer pkRenderer) {
        this.m_pkRenderer = pkRenderer;
    }
}

