/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibApplications.OpenGLApplication;

import WildMagic.LibApplications.OpenGLApplication.JavaApplication;
import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibFoundation.Mathematics.Mathf;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Rendering.Camera;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.Date;

public abstract class JavaApplication3D
extends JavaApplication
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Serializable {
    private static final long serialVersionUID = 2071922140567685883L;
    protected Camera m_spkCamera;
    protected Vector3f[] m_akWorldAxis = new Vector3f[]{new Vector3f(Vector3f.ZERO), new Vector3f(Vector3f.ZERO), new Vector3f(Vector3f.ZERO)};
    protected float m_fTrnSpeed = 0.0f;
    protected float m_fRotSpeed = 0.0f;
    protected boolean m_bLInsertPressed = false;
    protected boolean m_bRDeletePressed = false;
    protected float m_fTrnSpeedFactor = 2.0f;
    protected float m_fRotSpeedFactor = 2.0f;
    protected boolean m_bUArrowPressed = false;
    protected boolean m_bDArrowPressed = false;
    protected boolean m_bLArrowPressed = false;
    protected boolean m_bRArrowPressed = false;
    protected boolean m_bPgUpPressed = false;
    protected boolean m_bPgDnPressed = false;
    protected boolean m_bHomePressed = false;
    protected boolean m_bEndPressed = false;
    protected boolean m_bCameraMoveable = false;
    protected int m_iMouseButton = 0;
    protected float zCameraMove;
    private float yCameraMove;
    private float xCameraMove;
    private float xCameraTurn;
    private float yCameraTurn;
    private float[] cameraParams;
    protected Spatial m_spkMotionObject = null;
    protected int m_iDoRoll = 0;
    protected int m_iDoYaw = 0;
    protected int m_iDoPitch = 0;
    protected float rollRotationAngle = 0.0f;
    protected float yawRotationAngle = 0.0f;
    protected float pitchRotationAngle = 0.0f;
    private float[] objectParams;
    protected float m_fXTrack0 = 0.0f;
    protected float m_fYTrack0 = 0.0f;
    protected float m_fXTrack1 = 0.0f;
    protected float m_fYTrack1 = 0.0f;
    protected float m_fXDrag0 = 0.0f;
    protected float m_fYDrag0 = 0.0f;
    protected Matrix3f m_kSaveRotate;
    protected boolean m_bUseTrackBall = true;
    protected boolean m_bTrackBallDown = false;
    protected double m_dLastTime = -1.0;
    protected double m_dAccumulatedTime = 0.0;
    protected double m_dFrameRate = 0.0;
    protected int m_iFrameCount = 0;
    protected int m_iAccumulatedFrameCount = 0;
    protected int m_iTimer = 30;
    protected int m_iMaxTimer = 30;

    public JavaApplication3D(String acWindowTitle, int iXPosition, int iYPosition, int iWidth, int iHeight, ColorRGBA rkBackgroundColor) {
        super(acWindowTitle, iXPosition, iYPosition, iWidth, iHeight, rkBackgroundColor);
    }

    @Override
    public void dispose() {
        this.m_kSaveRotate = null;
        this.m_spkCamera = null;
        super.dispose();
    }

    public Vector3f getCameraLocation() {
        return this.m_spkCamera.GetLocation();
    }

    public float[] getCameraParameters() {
        if (this.cameraParams == null) {
            this.cameraParams = new float[5];
        }
        this.cameraParams[0] = this.xCameraMove;
        this.cameraParams[1] = this.yCameraMove;
        this.cameraParams[2] = this.zCameraMove;
        this.cameraParams[3] = this.xCameraTurn;
        this.cameraParams[4] = this.yCameraTurn;
        return this.cameraParams;
    }

    public float[] getObjectParameters() {
        if (this.objectParams == null) {
            this.objectParams = new float[3];
        }
        this.objectParams[0] = this.rollRotationAngle;
        this.objectParams[1] = this.yawRotationAngle;
        this.objectParams[2] = this.pitchRotationAngle;
        return this.objectParams;
    }

    public Matrix3f getObjectRotation() {
        return this.m_spkMotionObject.Local.GetRotate();
    }

    @Override
    public void keyPressed(KeyEvent kKey) {
        int iKey;
        super.keyPressed(kKey);
        char ucKey = kKey.getKeyChar();
        switch (ucKey) {
            case 't': {
                if (this.m_bCameraMoveable) {
                    this.m_fTrnSpeed /= this.m_fTrnSpeedFactor;
                }
                return;
            }
            case 'T': {
                if (this.m_bCameraMoveable) {
                    this.m_fTrnSpeed *= this.m_fTrnSpeedFactor;
                }
                return;
            }
            case 'r': {
                if (this.m_bCameraMoveable) {
                    this.m_fRotSpeed /= this.m_fRotSpeedFactor;
                }
                return;
            }
            case 'R': {
                if (this.m_bCameraMoveable) {
                    this.m_fRotSpeed *= this.m_fRotSpeedFactor;
                }
                return;
            }
            case '?': {
                this.ResetTime();
                return;
            }
        }
        if (this.m_bCameraMoveable) {
            iKey = kKey.getKeyCode();
            if (iKey == 155) {
                this.m_bLInsertPressed = true;
            }
            if (iKey == 127) {
                this.m_bRDeletePressed = true;
            }
            if (iKey == 37 || iKey == 226) {
                this.m_bLArrowPressed = true;
                return;
            }
            if (iKey == 39 || iKey == 227) {
                this.m_bRArrowPressed = true;
                return;
            }
            if (iKey == 38 || iKey == 224) {
                this.m_bUArrowPressed = true;
                return;
            }
            if (iKey == 40 || iKey == 225) {
                this.m_bDArrowPressed = true;
                return;
            }
            if (iKey == 33) {
                this.m_bPgUpPressed = true;
                return;
            }
            if (iKey == 34) {
                this.m_bPgDnPressed = true;
                return;
            }
            if (iKey == 36) {
                this.m_bHomePressed = true;
                return;
            }
            if (iKey == 35) {
                this.m_bEndPressed = true;
                return;
            }
        }
        if (this.m_spkMotionObject != null) {
            iKey = kKey.getKeyCode();
            if (iKey == 112) {
                this.m_iDoRoll = -1;
                return;
            }
            if (iKey == 113) {
                this.m_iDoRoll = 1;
                return;
            }
            if (iKey == 114) {
                this.m_iDoYaw = -1;
                return;
            }
            if (iKey == 115) {
                this.m_iDoYaw = 1;
                return;
            }
            if (iKey == 116) {
                this.m_iDoPitch = -1;
                return;
            }
            if (iKey == 117) {
                this.m_iDoPitch = 1;
                return;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent kKey) {
        int iKey = kKey.getKeyCode();
        if (this.m_bCameraMoveable) {
            if (iKey == 155) {
                this.m_bLInsertPressed = false;
            }
            if (iKey == 127) {
                this.m_bRDeletePressed = false;
            }
            if (iKey == 37 || iKey == 226) {
                this.m_bLArrowPressed = false;
                return;
            }
            if (iKey == 39 || iKey == 227) {
                this.m_bRArrowPressed = false;
                return;
            }
            if (iKey == 38 || iKey == 224) {
                this.m_bUArrowPressed = false;
                return;
            }
            if (iKey == 40 || iKey == 225) {
                this.m_bDArrowPressed = false;
                return;
            }
            if (iKey == 33) {
                this.m_bPgUpPressed = false;
                return;
            }
            if (iKey == 34) {
                this.m_bPgDnPressed = false;
                return;
            }
            if (iKey == 36) {
                this.m_bHomePressed = false;
                return;
            }
            if (iKey == 35) {
                this.m_bEndPressed = false;
                return;
            }
        }
        if (this.m_spkMotionObject != null) {
            if (iKey == 112) {
                this.m_iDoRoll = 0;
                return;
            }
            if (iKey == 113) {
                this.m_iDoRoll = 0;
                return;
            }
            if (iKey == 114) {
                this.m_iDoYaw = 0;
                return;
            }
            if (iKey == 115) {
                this.m_iDoYaw = 0;
                return;
            }
            if (iKey == 116) {
                this.m_iDoPitch = 0;
                return;
            }
            if (iKey == 117) {
                this.m_iDoPitch = 0;
                return;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int iX;
        float fMult;
        if (this.m_iMouseButton == 2 || this.m_iMouseButton == 3) {
            int iY = e.getY();
            float fYDrag1 = (float)(2 * (this.m_iHeight - 1 - iY) - this.m_iHeight) * (fMult = 1.0f / (float)(this.m_iWidth >= this.m_iHeight ? this.m_iHeight : this.m_iWidth));
            if (fYDrag1 > this.m_fYDrag0) {
                if (this.m_iMouseButton == 3) {
                    this.MoveDown();
                } else {
                    this.MoveBackward();
                }
            } else if (fYDrag1 < this.m_fYDrag0) {
                if (this.m_iMouseButton == 3) {
                    this.MoveUp();
                } else {
                    this.MoveForward();
                }
            }
            this.m_fYDrag0 = fYDrag1;
        }
        if (this.m_iMouseButton == 3) {
            iX = e.getX();
            float fXDrag1 = (float)(2 * iX - this.m_iWidth) * (fMult = 1.0f / (float)(this.m_iWidth >= this.m_iHeight ? this.m_iHeight : this.m_iWidth));
            if (fXDrag1 > this.m_fXDrag0) {
                this.MoveLeft();
            } else if (fXDrag1 < this.m_fXDrag0) {
                this.MoveRight();
            }
            this.m_fXDrag0 = fXDrag1;
        }
        if (!this.m_bUseTrackBall || this.m_iMouseButton != 1 || !this.m_bTrackBallDown || this.m_spkMotionObject == null) {
            return;
        }
        iX = e.getX();
        int iY = e.getY();
        float fMult2 = 1.0f / (float)(this.m_iWidth >= this.m_iHeight ? this.m_iHeight : this.m_iWidth);
        this.m_fXTrack1 = (float)(2 * iX - this.m_iWidth) * fMult2;
        this.m_fYTrack1 = (float)(2 * (this.m_iHeight - 1 - iY) - this.m_iHeight) * fMult2;
        this.RotateTrackBall(this.m_fXTrack0, this.m_fYTrack0, this.m_fXTrack1, this.m_fYTrack1);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int iX = e.getX();
        int iY = e.getY();
        float fMult = 1.0f / (float)(this.m_iWidth >= this.m_iHeight ? this.m_iHeight : this.m_iWidth);
        this.m_fXDrag0 = (float)(2 * iX - this.m_iWidth) * fMult;
        this.m_fYDrag0 = (float)(2 * (this.m_iHeight - 1 - iY) - this.m_iHeight) * fMult;
        this.m_iMouseButton = e.getButton();
        if (!this.m_bUseTrackBall || e.getButton() != 1 || this.m_spkMotionObject == null) {
            return;
        }
        this.m_bTrackBallDown = true;
        this.m_kSaveRotate = new Matrix3f(this.m_spkMotionObject.Local.GetRotate());
        this.m_fXTrack0 = (float)(2 * iX - this.m_iWidth) * fMult;
        this.m_fYTrack0 = (float)(2 * (this.m_iHeight - 1 - iY) - this.m_iHeight) * fMult;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.m_iMouseButton = 0;
        if (!this.m_bUseTrackBall || e.getButton() != 1 || this.m_spkMotionObject == null) {
            return;
        }
        this.m_bTrackBallDown = false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() == 1) {
            this.MoveForward();
        } else {
            this.MoveBackward();
        }
    }

    @Override
    public void OnDisplay() {
        if (this.m_pkRenderer != null) {
            this.OnIdle();
        }
    }

    @Override
    public boolean OnInitialize() {
        if (!super.OnInitialize()) {
            return false;
        }
        this.m_spkCamera = new Camera();
        this.m_pkRenderer.SetCamera(this.m_spkCamera);
        this.m_spkMotionObject = null;
        return true;
    }

    @Override
    public void OnTerminate() {
        this.m_pkRenderer.SetCamera(null);
        this.m_spkCamera = null;
        this.m_spkMotionObject = null;
        super.OnTerminate();
    }

    public void setCameraLocation(Vector3f v) {
        this.m_spkCamera.SetLocation(v);
    }

    public void setCameraParameters(float[] cameraParams) {
        if (cameraParams == null || cameraParams.length < 5) {
            return;
        }
        this.xCameraMove = cameraParams[0];
        this.yCameraMove = cameraParams[1];
        this.zCameraMove = cameraParams[2];
        this.xCameraTurn = cameraParams[3];
        this.yCameraTurn = cameraParams[4];
    }

    public void setObjectRotation(Matrix3f rot) {
        this.m_spkMotionObject.Local.SetRotate(rot);
        this.m_bTrackBallDown = true;
    }

    public void setObjectParameters(float[] objectParams) {
        if (objectParams == null || objectParams.length < 3) {
            return;
        }
        this.rollRotationAngle = objectParams[0];
        this.yawRotationAngle = objectParams[1];
        this.pitchRotationAngle = objectParams[2];
    }

    protected void DrawFrameRate(int iX, int iY, ColorRGBA rkColor) {
        String kMessage = new String("fps: " + this.m_dFrameRate);
        int iLength = kMessage.length();
        if (iLength > 10) {
            kMessage = kMessage.substring(0, 10);
        }
        this.m_pkRenderer.Draw(iX, iY, rkColor, kMessage.toCharArray());
    }

    protected void InitializeCameraMotion(float fTrnSpeed, float fRotSpeed) {
        this.InitializeCameraMotion(fTrnSpeed, fRotSpeed, 2.0f, 2.0f);
    }

    protected void InitializeCameraMotion(float fTrnSpeed, float fRotSpeed, float fTrnSpeedFactor, float fRotSpeedFactor) {
        this.m_bCameraMoveable = true;
        this.m_fTrnSpeed = fTrnSpeed;
        this.m_fRotSpeed = fRotSpeed;
        this.m_fTrnSpeedFactor = fTrnSpeedFactor;
        this.m_fRotSpeedFactor = fRotSpeedFactor;
        this.m_akWorldAxis[0] = this.m_spkCamera.GetDVector();
        this.m_akWorldAxis[1] = this.m_spkCamera.GetUVector();
        this.m_akWorldAxis[2] = this.m_spkCamera.GetRVector();
    }

    protected void InitializeObjectMotion(Spatial pkMotionObject) {
        this.m_spkMotionObject = pkMotionObject;
    }

    protected void LookDown() {
        Matrix3f kIncr = new Matrix3f(this.m_akWorldAxis[2], -this.m_fRotSpeed);
        this.yCameraTurn -= this.m_fRotSpeed;
        Vector3f kDVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetDVector(), kDVector);
        Vector3f kUVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetUVector(), kUVector);
        Vector3f kRVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetRVector(), kRVector);
        this.m_spkCamera.SetAxes(kDVector, kUVector, kRVector);
        kIncr = null;
    }

    protected void LookUp() {
        Matrix3f kIncr = new Matrix3f(this.m_akWorldAxis[2], this.m_fRotSpeed);
        this.yCameraTurn += this.m_fRotSpeed;
        Vector3f kDVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetDVector(), kDVector);
        Vector3f kUVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetUVector(), kUVector);
        Vector3f kRVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetRVector(), kRVector);
        this.m_spkCamera.SetAxes(kDVector, kUVector, kRVector);
        kIncr = null;
    }

    protected void MeasureTime() {
        Date kDate = new Date();
        if (this.m_dLastTime == -1.0) {
            this.m_dLastTime = (double)kDate.getTime() / 1000.0;
            this.m_dAccumulatedTime = 0.0;
            this.m_iFrameCount = 0;
            this.m_iAccumulatedFrameCount = 0;
            this.m_iTimer = this.m_iMaxTimer;
        }
        if (--this.m_iTimer == 0) {
            double dCurrentTime = (double)kDate.getTime() / 1000.0;
            double dDelta = dCurrentTime - this.m_dLastTime;
            this.m_dLastTime = dCurrentTime;
            this.m_dAccumulatedTime += dDelta;
            this.m_iAccumulatedFrameCount += this.m_iFrameCount;
            this.m_iFrameCount = 0;
            this.m_iTimer = this.m_iMaxTimer;
            this.m_dFrameRate = (double)this.m_iAccumulatedFrameCount / this.m_dAccumulatedTime;
            this.ResetTime();
        }
        kDate = null;
    }

    protected void MoveBackward() {
        Vector3f oldLoc = new Vector3f();
        Vector3f newLoc = new Vector3f();
        Vector3f kLoc = new Vector3f(this.m_akWorldAxis[0]);
        kLoc.Scale(this.m_fTrnSpeed);
        oldLoc.Copy(this.m_spkCamera.GetLocation());
        kLoc.Sub(this.m_spkCamera.GetLocation(), kLoc);
        this.m_spkCamera.SetLocation(kLoc);
        newLoc.Copy(this.m_spkCamera.GetLocation());
        newLoc.Sub(oldLoc);
        this.zCameraMove -= newLoc.Length();
    }

    protected boolean MoveCamera() {
        if (!this.m_bCameraMoveable) {
            return false;
        }
        boolean bMoved = false;
        if (this.m_bLInsertPressed) {
            this.MoveLeft();
            bMoved = true;
        }
        if (this.m_bRDeletePressed) {
            this.MoveRight();
            bMoved = true;
        }
        if (this.m_bUArrowPressed) {
            this.MoveForward();
            bMoved = true;
        }
        if (this.m_bDArrowPressed) {
            this.MoveBackward();
            bMoved = true;
        }
        if (this.m_bHomePressed) {
            this.MoveUp();
            bMoved = true;
        }
        if (this.m_bEndPressed) {
            this.MoveDown();
            bMoved = true;
        }
        if (this.m_bLArrowPressed) {
            this.TurnLeft();
            bMoved = true;
        }
        if (this.m_bRArrowPressed) {
            this.TurnRight();
            bMoved = true;
        }
        if (this.m_bPgUpPressed) {
            this.LookUp();
            bMoved = true;
        }
        if (this.m_bPgDnPressed) {
            this.LookDown();
            bMoved = true;
        }
        return bMoved;
    }

    protected void MoveDown() {
        Vector3f oldLoc = new Vector3f();
        Vector3f newLoc = new Vector3f();
        Vector3f kLoc = new Vector3f(this.m_akWorldAxis[1]);
        kLoc.Scale(this.m_fTrnSpeed);
        oldLoc.Copy(this.m_spkCamera.GetLocation());
        kLoc.Sub(this.m_spkCamera.GetLocation(), kLoc);
        this.m_spkCamera.SetLocation(kLoc);
        newLoc.Copy(this.m_spkCamera.GetLocation());
        newLoc.Sub(oldLoc);
        this.yCameraMove -= newLoc.Length();
    }

    protected void MoveForward() {
        Vector3f oldLoc = new Vector3f();
        Vector3f newLoc = new Vector3f();
        Vector3f kLoc = new Vector3f(this.m_akWorldAxis[0]);
        kLoc.Scale(this.m_fTrnSpeed);
        oldLoc.Copy(this.m_spkCamera.GetLocation());
        kLoc.Add(this.m_spkCamera.GetLocation());
        this.m_spkCamera.SetLocation(kLoc);
        newLoc.Copy(this.m_spkCamera.GetLocation());
        newLoc.Sub(oldLoc);
        this.zCameraMove += newLoc.Length();
    }

    protected void MoveLeft() {
        Vector3f oldLoc = new Vector3f();
        Vector3f newLoc = new Vector3f();
        Vector3f kLoc = new Vector3f(this.m_akWorldAxis[2]);
        kLoc.Scale(this.m_fTrnSpeed);
        oldLoc.Copy(this.m_spkCamera.GetLocation());
        kLoc.Sub(this.m_spkCamera.GetLocation(), kLoc);
        this.m_spkCamera.SetLocation(kLoc);
        newLoc.Copy(this.m_spkCamera.GetLocation());
        newLoc.Sub(oldLoc);
        this.xCameraMove -= newLoc.Length();
    }

    protected boolean MoveObject() {
        if (!this.m_bCameraMoveable || this.m_spkMotionObject == null) {
            return false;
        }
        if (this.m_bTrackBallDown) {
            return true;
        }
        Spatial pkParent = this.m_spkMotionObject.GetParent();
        Vector3f kAxis = new Vector3f(Vector3f.UNIT_X);
        Matrix3f kIncr = new Matrix3f();
        if (this.m_iDoRoll != 0) {
            Matrix3f kRot = this.m_spkMotionObject.Local.GetRotate();
            float fAngle = (float)this.m_iDoRoll * this.m_fRotSpeed;
            this.rollRotationAngle += fAngle;
            if (pkParent != null) {
                pkParent.World.GetRotate().GetColumn(0, kAxis);
            }
            kIncr.FromAxisAngle(kAxis, fAngle);
            kRot.MultLeft(kIncr);
            kRot.Orthonormalize();
            this.m_spkMotionObject.Local.SetRotate(kRot);
            kIncr = null;
            kAxis = null;
            return true;
        }
        kAxis.Copy(Vector3f.UNIT_Y);
        if (this.m_iDoYaw != 0) {
            Matrix3f kRot = this.m_spkMotionObject.Local.GetRotate();
            float fAngle = (float)this.m_iDoYaw * this.m_fRotSpeed;
            this.yawRotationAngle += fAngle;
            if (pkParent != null) {
                pkParent.World.GetRotate().GetColumn(1, kAxis);
            }
            kIncr.FromAxisAngle(kAxis, fAngle);
            kRot.MultLeft(kIncr);
            kRot.Orthonormalize();
            this.m_spkMotionObject.Local.SetRotate(kRot);
            kIncr = null;
            kAxis = null;
            return true;
        }
        kAxis.Copy(Vector3f.UNIT_Z);
        if (this.m_iDoPitch != 0) {
            Matrix3f kRot = this.m_spkMotionObject.Local.GetRotate();
            float fAngle = (float)this.m_iDoPitch * this.m_fRotSpeed;
            this.pitchRotationAngle += fAngle;
            if (pkParent != null) {
                pkParent.World.GetRotate().GetColumn(2, kAxis);
            }
            kIncr.FromAxisAngle(kAxis, fAngle);
            kRot.MultLeft(kIncr);
            kRot.Orthonormalize();
            this.m_spkMotionObject.Local.SetRotate(kRot);
            kIncr = null;
            kAxis = null;
            return true;
        }
        kIncr = null;
        kAxis = null;
        return false;
    }

    protected void MoveRight() {
        Vector3f oldLoc = new Vector3f();
        Vector3f newLoc = new Vector3f();
        Vector3f kLoc = new Vector3f(this.m_akWorldAxis[2]);
        kLoc.Scale(this.m_fTrnSpeed);
        oldLoc.Copy(this.m_spkCamera.GetLocation());
        kLoc.Add(this.m_spkCamera.GetLocation());
        this.m_spkCamera.SetLocation(kLoc);
        newLoc.Copy(this.m_spkCamera.GetLocation());
        newLoc.Sub(oldLoc);
        this.xCameraMove += newLoc.Length();
    }

    protected void MoveUp() {
        Vector3f oldLoc = new Vector3f();
        Vector3f newLoc = new Vector3f();
        Vector3f kLoc = new Vector3f(this.m_akWorldAxis[1]);
        kLoc.Scale(this.m_fTrnSpeed);
        oldLoc.Copy(this.m_spkCamera.GetLocation());
        kLoc.Add(this.m_spkCamera.GetLocation());
        this.m_spkCamera.SetLocation(kLoc);
        newLoc.Copy(this.m_spkCamera.GetLocation());
        newLoc.Sub(oldLoc);
        this.yCameraMove += newLoc.Length();
    }

    protected void ResetTime() {
        this.m_dLastTime = -1.0;
    }

    protected void RotateTrackBall(float fX0, float fY0, float fX1, float fY1) {
        float fAngle;
        float fZ1;
        float fZ0;
        float fInvLength;
        if (fX0 == fX1 && fY0 == fY1 || this.m_spkCamera == null) {
            return;
        }
        float fLength = (float)Math.sqrt(fX0 * fX0 + fY0 * fY0);
        if (fLength > 1.0f) {
            fInvLength = 1.0f / fLength;
            fX0 *= fInvLength;
            fY0 *= fInvLength;
            fZ0 = 0.0f;
        } else {
            fZ0 = 1.0f - fX0 * fX0 - fY0 * fY0;
            fZ0 = fZ0 <= 0.0f ? 0.0f : (float)Math.sqrt(fZ0);
        }
        Vector3f kVec0 = new Vector3f(fZ0 *= -1.0f, fY0, fX0);
        fLength = (float)Math.sqrt(fX1 * fX1 + fY1 * fY1);
        if (fLength > 1.0f) {
            fInvLength = 1.0f / fLength;
            fX1 *= fInvLength;
            fY1 *= fInvLength;
            fZ1 = 0.0f;
        } else {
            fZ1 = 1.0f - fX1 * fX1 - fY1 * fY1;
            fZ1 = fZ1 <= 0.0f ? 0.0f : (float)Math.sqrt(fZ1);
        }
        Vector3f kVec1 = new Vector3f(fZ1 *= -1.0f, fY1, fX1);
        Vector3f kAxis = new Vector3f();
        kAxis.Cross(kVec0, kVec1);
        float fDot = kVec0.Dot(kVec1);
        if (kAxis.Normalize() > 1.0E-6f) {
            fAngle = (float)Math.acos(kVec0.Dot(kVec1));
        } else if (fDot < 0.0f) {
            fInvLength = Mathf.InvSqrt(fX0 * fX0 + fY0 * fY0);
            kAxis.X = fY0 * fInvLength;
            kAxis.Y = -fX0 * fInvLength;
            kAxis.Z = 0.0f;
            fAngle = (float)Math.PI;
        } else {
            kAxis = Vector3f.UNIT_X;
            fAngle = 0.0f;
        }
        Vector3f kWorldAxis = new Vector3f(this.m_spkCamera.GetDVector());
        kWorldAxis.Scale(kAxis.X);
        Vector3f kTempU = new Vector3f(this.m_spkCamera.GetUVector());
        kTempU.Scale(kAxis.Y);
        Vector3f kTempR = new Vector3f(this.m_spkCamera.GetRVector());
        kTempR.Scale(kAxis.Z);
        kWorldAxis.Add(kTempU);
        kWorldAxis.Add(kTempR);
        kTempU = null;
        kTempR = null;
        Matrix3f kTrackRotate = new Matrix3f(kWorldAxis, fAngle);
        Spatial pkParent = this.m_spkMotionObject.GetParent();
        Matrix3f kLocalRot = new Matrix3f();
        if (pkParent != null) {
            Matrix3f rkPRotate = pkParent.World.GetRotate();
            kLocalRot.Copy(rkPRotate);
            kLocalRot.TransposeTimes(kTrackRotate);
            kLocalRot.Mult(rkPRotate);
            kLocalRot.Mult(this.m_kSaveRotate);
        } else {
            kLocalRot.Copy(kTrackRotate);
            kLocalRot.Mult(this.m_kSaveRotate);
        }
        kLocalRot.Orthonormalize();
        this.m_spkMotionObject.Local.SetRotateCopy(kLocalRot);
        Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f yAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f zAxis = new Vector3f(0.0f, 0.0f, 1.0f);
        xAxis.Copy(Vector3f.UNIT_X);
        yAxis.Copy(Vector3f.UNIT_Y);
        zAxis.Copy(Vector3f.UNIT_Z);
        kWorldAxis.Normalize();
        this.rollRotationAngle = (float)Math.acos(kWorldAxis.Dot(xAxis));
        this.yawRotationAngle = (float)Math.acos(kWorldAxis.Dot(yAxis));
        this.pitchRotationAngle = (float)Math.acos(kWorldAxis.Dot(zAxis));
        kAxis = null;
        kVec0 = null;
        kVec1 = null;
        kTrackRotate = null;
    }

    protected void TurnLeft() {
        Matrix3f kIncr = new Matrix3f(this.m_akWorldAxis[1], this.m_fRotSpeed);
        this.xCameraTurn += this.m_fRotSpeed;
        kIncr.Mult(this.m_akWorldAxis[0], this.m_akWorldAxis[0]);
        kIncr.Mult(this.m_akWorldAxis[2], this.m_akWorldAxis[2]);
        Vector3f kDVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetDVector(), kDVector);
        Vector3f kUVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetUVector(), kUVector);
        Vector3f kRVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetRVector(), kRVector);
        this.m_spkCamera.SetAxes(kDVector, kUVector, kRVector);
        kIncr = null;
    }

    protected void TurnRight() {
        Matrix3f kIncr = new Matrix3f(this.m_akWorldAxis[1], -this.m_fRotSpeed);
        this.xCameraTurn -= this.m_fRotSpeed;
        kIncr.Mult(this.m_akWorldAxis[0], this.m_akWorldAxis[0]);
        kIncr.Mult(this.m_akWorldAxis[2], this.m_akWorldAxis[2]);
        Vector3f kDVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetDVector(), kDVector);
        Vector3f kUVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetUVector(), kUVector);
        Vector3f kRVector = new Vector3f();
        kIncr.Mult(this.m_spkCamera.GetRVector(), kRVector);
        this.m_spkCamera.SetAxes(kDVector, kUVector, kRVector);
        kIncr = null;
    }

    protected void UpdateFrameCount() {
        ++this.m_iFrameCount;
    }
}

