/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Approximation;

import WildMagic.LibFoundation.Containment.ContBox3f;
import WildMagic.LibFoundation.Distance.DistanceVector3Ellipsoid3;
import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Ellipsoid3f;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.NumericalAnalysis.MinimizeN;
import WildMagic.LibFoundation.NumericalAnalysis.PowellCostFunction;
import java.util.Vector;

public class ApprEllipsoidFit3f
implements PowellCostFunction {
    private int m_iQuantity;
    private Vector<Vector3f> m_akPoint;
    private double[] m_fError = new double[1];

    public ApprEllipsoidFit3f(int iQuantity, Vector<Vector3f> akPoint, Vector3f rkU, Matrix3f rkR, float[] afD) {
        this.m_iQuantity = iQuantity;
        this.m_akPoint = akPoint;
        MinimizeN kMinimizer = new MinimizeN(9, this, 8, 8, 32, null);
        ApprEllipsoidFit3f.InitialGuess(iQuantity, akPoint, rkU, rkR, afD);
        float[] afAngle = new float[3];
        ApprEllipsoidFit3f.MatrixToAngles(rkR, afAngle);
        float[] afExtent = new float[]{afD[0] * Math.abs(rkR.Get(0, 0)) + afD[1] * Math.abs(rkR.Get(0, 1)) + afD[2] * Math.abs(rkR.Get(0, 2)), afD[0] * Math.abs(rkR.Get(1, 0)) + afD[1] * Math.abs(rkR.Get(1, 1)) + afD[2] * Math.abs(rkR.Get(1, 2)), afD[0] * Math.abs(rkR.Get(2, 0)) + afD[1] * Math.abs(rkR.Get(2, 1)) + afD[2] * Math.abs(rkR.Get(2, 2))};
        double[] afV0 = new double[]{0.5 * (double)afD[0], 0.5 * (double)afD[1], 0.5 * (double)afD[2], rkU.X - afExtent[0], rkU.Y - afExtent[1], rkU.Z - afExtent[2], -Math.PI, 0.0, 0.0};
        double[] afV1 = new double[]{2.0 * (double)afD[0], 2.0 * (double)afD[1], 2.0 * (double)afD[2], rkU.X + afExtent[0], rkU.Y + afExtent[1], rkU.Z + afExtent[2], Math.PI, Math.PI, Math.PI};
        double[] afVInitial = new double[]{afD[0], afD[1], afD[2], rkU.X, rkU.Y, rkU.Z, afAngle[0], afAngle[1], afAngle[2]};
        double[] afVMin = new double[9];
        kMinimizer.GetMinimum(afV0, afV1, afVInitial, afVMin, this.m_fError);
        afD[0] = (float)afVMin[0];
        afD[1] = (float)afVMin[1];
        afD[2] = (float)afVMin[2];
        rkU.X = (float)afVMin[3];
        rkU.Y = (float)afVMin[4];
        rkU.Z = (float)afVMin[5];
        float[] angles = new float[]{(float)afVMin[6], (float)afVMin[7], (float)afVMin[8]};
        ApprEllipsoidFit3f.AnglesToMatrix(angles, rkR);
    }

    private static void InitialGuess(int iQuantity, Vector<Vector3f> akPoint, Vector3f rkU, Matrix3f rkR, float[] afD) {
        Box3f kBox = ContBox3f.ContOrientedBox(iQuantity, akPoint);
        rkU.Copy(kBox.Center);
        rkR.Set(0, 0, kBox.Axis[0].X);
        rkR.Set(0, 1, kBox.Axis[0].Y);
        rkR.Set(0, 2, kBox.Axis[0].Z);
        rkR.Set(1, 0, kBox.Axis[1].X);
        rkR.Set(1, 1, kBox.Axis[1].Y);
        rkR.Set(1, 2, kBox.Axis[1].Z);
        rkR.Set(2, 0, kBox.Axis[2].X);
        rkR.Set(2, 1, kBox.Axis[2].Y);
        rkR.Set(2, 2, kBox.Axis[2].Z);
        afD[0] = kBox.Extent[0];
        afD[1] = kBox.Extent[1];
        afD[2] = kBox.Extent[2];
    }

    public float Energy(double[] afV) {
        Matrix3f kRot = new Matrix3f();
        float[] angles = new float[]{(float)afV[6], (float)afV[7], (float)afV[8]};
        ApprEllipsoidFit3f.AnglesToMatrix(angles, kRot);
        float fMax = (float)afV[0];
        if (afV[1] > (double)fMax) {
            fMax = (float)afV[1];
        }
        if (afV[2] > (double)fMax) {
            fMax = (float)afV[2];
        }
        float fInvMax = 1.0f / fMax;
        Ellipsoid3f kEllipsoid = new Ellipsoid3f(Vector3f.ZERO, Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z, fInvMax * (float)afV[0], fInvMax * (float)afV[1], fInvMax * (float)afV[2]);
        float fEnergy = 0.0f;
        Vector3f kDiff = new Vector3f();
        Vector3f kResult = new Vector3f();
        for (int i = 0; i < this.m_iQuantity; ++i) {
            Vector3f current = this.m_akPoint.elementAt(i);
            kDiff.Set(current.X - (float)afV[3], current.Y - (float)afV[4], current.Z - (float)afV[5]);
            kRot.MultLeft(kDiff, kResult);
            kResult.Scale(fInvMax);
            DistanceVector3Ellipsoid3 kDist = new DistanceVector3Ellipsoid3(kResult, kEllipsoid);
            float fDist = kDist.Get();
            fEnergy += fMax * fDist;
        }
        return fEnergy;
    }

    private static void MatrixToAngles(Matrix3f rkR, float[] afAngle) {
        Vector3f kAxis = new Vector3f();
        afAngle[2] = rkR.ToAxisAngle(kAxis);
        if (-1.0 < (double)kAxis.Z) {
            if ((double)kAxis.Z < 1.0) {
                afAngle[0] = (float)Math.atan2(kAxis.Y, kAxis.X);
                afAngle[1] = (float)Math.acos(kAxis.Z);
            } else {
                afAngle[0] = 0.0f;
                afAngle[1] = 0.0f;
            }
        } else {
            afAngle[0] = 0.0f;
            afAngle[1] = (float)Math.PI;
        }
    }

    private static void AnglesToMatrix(float[] afAngle, Matrix3f rkR) {
        double fCos0 = Math.cos(afAngle[0]);
        double fSin0 = Math.sin(afAngle[0]);
        double fCos1 = Math.cos(afAngle[1]);
        double fSin1 = Math.sin(afAngle[1]);
        Vector3f kAxis = new Vector3f((float)(fCos0 * fSin1), (float)(fSin0 * fSin1), (float)fCos1);
        rkR.FromAxisAngle(kAxis, afAngle[2]);
    }

    @Override
    public double cost(double fT, double[] afData) {
        return 0.0;
    }

    @Override
    public double cost(double[] fT, double[] afData) {
        return this.Energy(fT);
    }
}

