/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Approximation;

import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.NumericalAnalysis.Eigenf;
import WildMagic.LibFoundation.NumericalAnalysis.LinearSystem;
import java.util.Vector;

public class ApprPlaneFit3f {
    public static boolean HeightPlaneFit3(int iQuantity, Vector3f[] akPoint, float[] result) {
        float fSumX = 0.0f;
        float fSumY = 0.0f;
        float fSumZ = 0.0f;
        float fSumXX = 0.0f;
        float fSumXY = 0.0f;
        float fSumXZ = 0.0f;
        float fSumYY = 0.0f;
        float fSumYZ = 0.0f;
        for (int i = 0; i < iQuantity; ++i) {
            fSumX += akPoint[i].X;
            fSumY += akPoint[i].Y;
            fSumZ += akPoint[i].Z;
            fSumXX += akPoint[i].X * akPoint[i].X;
            fSumXY += akPoint[i].X * akPoint[i].Y;
            fSumXZ += akPoint[i].X * akPoint[i].Z;
            fSumYY += akPoint[i].Y * akPoint[i].Y;
            fSumYZ += akPoint[i].Y * akPoint[i].Z;
        }
        float[][] aafA = new float[][]{{fSumXX, fSumXY, fSumX}, {fSumXY, fSumYY, fSumY}, {fSumX, fSumY, iQuantity}};
        float[] afB = new float[]{fSumXZ, fSumYZ, fSumZ};
        float[] afX = new float[3];
        boolean bNonsingular = LinearSystem.Solve3(aafA, afB, afX);
        if (bNonsingular) {
            result[0] = afX[0];
            result[1] = afX[1];
            result[2] = afX[2];
        } else {
            result[0] = Float.MAX_VALUE;
            result[1] = Float.MAX_VALUE;
            result[2] = Float.MAX_VALUE;
        }
        return bNonsingular;
    }

    public static Plane3f OrthogonalPlaneFit3(int iQuantity, Vector<Vector3f> akPoint) {
        Vector3f kOrigin = new Vector3f(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < iQuantity; ++i) {
            kOrigin.Add(akPoint.get(i));
        }
        float fInvQuantity = 1.0f / (float)iQuantity;
        kOrigin.Scale(fInvQuantity);
        float fSumXX = 0.0f;
        float fSumXY = 0.0f;
        float fSumXZ = 0.0f;
        float fSumYY = 0.0f;
        float fSumYZ = 0.0f;
        float fSumZZ = 0.0f;
        Vector3f kDiff = new Vector3f();
        for (int i = 0; i < iQuantity; ++i) {
            kDiff.Sub(akPoint.get(i), kOrigin);
            fSumXX += kDiff.X * kDiff.X;
            fSumXY += kDiff.X * kDiff.Y;
            fSumXZ += kDiff.X * kDiff.Z;
            fSumYY += kDiff.Y * kDiff.Y;
            fSumYZ += kDiff.Y * kDiff.Z;
            fSumZZ += kDiff.Z * kDiff.Z;
        }
        fSumXX *= fInvQuantity;
        fSumXY *= fInvQuantity;
        fSumXZ *= fInvQuantity;
        fSumYY *= fInvQuantity;
        fSumYZ *= fInvQuantity;
        fSumZZ *= fInvQuantity;
        Eigenf kES = new Eigenf(3);
        kES.SetData(0, 0, fSumXX);
        kES.SetData(0, 1, fSumXY);
        kES.SetData(0, 2, fSumXZ);
        kES.SetData(1, 0, fSumXY);
        kES.SetData(1, 1, fSumYY);
        kES.SetData(1, 2, fSumYZ);
        kES.SetData(2, 0, fSumXZ);
        kES.SetData(2, 1, fSumYZ);
        kES.SetData(2, 2, fSumZZ);
        kES.DecrSortEigenStuff3();
        Vector3f kNormal = new Vector3f();
        kES.GetEigenvector(2, kNormal);
        return new Plane3f(kNormal, kOrigin);
    }
}

