/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Containment;

import WildMagic.LibFoundation.Approximation.ApprGaussPointsFit3f;
import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Mathf;
import WildMagic.LibFoundation.Mathematics.Quaternion;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;
import java.util.Vector;

public class ContBox3f
implements Serializable {
    private static final long serialVersionUID = -1627068627977778409L;

    public static Box3f ContAlignedBox(int iQuantity, Vector3f[] akPoint) {
        Vector3f kMin = new Vector3f();
        Vector3f kMax = new Vector3f();
        Vector3f.ComputeExtremes(iQuantity, akPoint, kMin, kMax);
        Box3f kBox = new Box3f(Vector3f.ZERO, Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z, 1.0f, 1.0f, 1.0f);
        kBox.Center = new Vector3f();
        kBox.Center.Add(kMin, kMax);
        kBox.Center.Scale(0.5f);
        Vector3f kHalfDiagonal = new Vector3f();
        kHalfDiagonal.Sub(kMax, kMin);
        kHalfDiagonal.Scale(0.5f);
        kBox.Extent[0] = kHalfDiagonal.X;
        kBox.Extent[1] = kHalfDiagonal.Y;
        kBox.Extent[2] = kHalfDiagonal.Z;
        return kBox;
    }

    public static Box3f ContOrientedBox(int iQuantity, Vector<Vector3f> kMeshVertices) {
        Box3f kBox = ApprGaussPointsFit3f.GaussPointsFit3f(iQuantity, kMeshVertices);
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(kMeshVertices.get(0), kBox.Center);
        Vector3f kMin = new Vector3f(kDiff.Dot(kBox.Axis[0]), kDiff.Dot(kBox.Axis[1]), kDiff.Dot(kBox.Axis[2]));
        Vector3f kMax = new Vector3f(kMin);
        Vector3f kDot = new Vector3f();
        for (int i = 1; i < iQuantity; ++i) {
            kDiff.Sub(kMeshVertices.get(i), kBox.Center);
            kDot.Set(kDiff.Dot(kBox.Axis[0]), kDiff.Dot(kBox.Axis[1]), kDiff.Dot(kBox.Axis[2]));
            kMin.Min(kDot);
            kMax.Max(kDot);
        }
        Vector3f kTemp0 = new Vector3f();
        Vector3f kTemp1 = new Vector3f();
        Vector3f kTemp2 = new Vector3f();
        kTemp0.Scale(0.5f * (kMin.X + kMax.X), kBox.Axis[0]);
        kTemp1.Scale(0.5f * (kMin.Y + kMax.Y), kBox.Axis[1]);
        kTemp2.Scale(0.5f * (kMin.Z + kMax.Z), kBox.Axis[2]);
        kTemp0.Add(kTemp1);
        kTemp0.Add(kTemp2);
        kBox.Center.Add(kTemp0);
        kBox.Extent[0] = 0.5f * (kMax.X - kMin.X);
        kBox.Extent[1] = 0.5f * (kMax.Y - kMin.Y);
        kBox.Extent[2] = 0.5f * (kMax.Z - kMin.Z);
        return kBox;
    }

    public static boolean InBox(Vector3f rkPoint, Box3f rkBox) {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(rkPoint, rkBox.Center);
        for (int i = 0; i < 3; ++i) {
            float fCoeff = kDiff.Dot(rkBox.Axis[i]);
            if (!(Math.abs(fCoeff) - rkBox.Extent[i] > 1.0E-6f)) continue;
            return false;
        }
        return true;
    }

    public static Box3f MergeBoxes(Box3f rkBox0, Box3f rkBox1) {
        int i;
        Box3f kBox = new Box3f();
        kBox.Center = new Vector3f();
        kBox.Center.Add(rkBox0.Center, rkBox1.Center);
        kBox.Center.Scale(0.5f);
        Quaternion kQ0 = new Quaternion();
        Quaternion kQ1 = new Quaternion();
        kQ0.FromRotationMatrix(rkBox0.Axis);
        kQ1.FromRotationMatrix(rkBox1.Axis);
        if (kQ0.Dot(kQ1) < 0.0f) {
            kQ1 = kQ1.Neg();
        }
        Quaternion kQ = kQ0.Add(kQ1);
        float fInvLength = Mathf.InvSqrt(kQ.Dot(kQ));
        kQ = kQ.Scale(fInvLength);
        kQ.ToRotationMatrix(kBox.Axis);
        Vector3f[] akVertex = new Vector3f[8];
        Vector3f kDiff = new Vector3f();
        Vector3f kMin = new Vector3f(Vector3f.ZERO);
        Vector3f kMax = new Vector3f(Vector3f.ZERO);
        Vector3f kDot = new Vector3f();
        rkBox0.ComputeVertices(akVertex);
        for (i = 0; i < 8; ++i) {
            kDiff.Sub(akVertex[i], kBox.Center);
            kDot.Set(kDiff.Dot(kBox.Axis[0]), kDiff.Dot(kBox.Axis[1]), kDiff.Dot(kBox.Axis[2]));
            kMin.Min(kDot);
            kMax.Max(kDot);
        }
        rkBox1.ComputeVertices(akVertex);
        for (i = 0; i < 8; ++i) {
            kDiff.Sub(akVertex[i], kBox.Center);
            kDot.Set(kDiff.Dot(kBox.Axis[0]), kDiff.Dot(kBox.Axis[1]), kDiff.Dot(kBox.Axis[2]));
            kMin.Min(kDot);
            kMax.Max(kDot);
        }
        Vector3f kMaxpMin = new Vector3f();
        kMaxpMin.Add(kMax, kMin);
        kMaxpMin.Scale(0.5f);
        Vector3f kMaxmMin = new Vector3f();
        kMaxmMin.Sub(kMax, kMin);
        kMaxmMin.Scale(0.5f);
        Vector3f kTemp = new Vector3f();
        kTemp.Scale(kMaxpMin.X, kBox.Axis[0]);
        kBox.Center.Add(kTemp);
        kTemp.Scale(kMaxpMin.Y, kBox.Axis[1]);
        kBox.Center.Add(kTemp);
        kTemp.Scale(kMaxpMin.Z, kBox.Axis[2]);
        kBox.Center.Add(kTemp);
        kBox.Extent[0] = kMaxmMin.X;
        kBox.Extent[1] = kMaxmMin.Y;
        kBox.Extent[2] = kMaxmMin.Z;
        return kBox;
    }
}

