/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Curves;

import WildMagic.LibFoundation.Curves.BSplineBasisDiscretef;
import WildMagic.LibFoundation.Curves.BSplineBasisf;
import WildMagic.LibFoundation.Curves.SingleCurve3f;
import WildMagic.LibFoundation.Mathematics.GMatrixf;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class BSplineCurve3f
extends SingleCurve3f
implements Serializable {
    private static final long serialVersionUID = -1817753487527306834L;
    protected int m_iNumCtrlPoints;
    protected Vector3f[] m_akCtrlPoint;
    protected boolean m_bLoop;
    protected BSplineBasisf m_kBasis = new BSplineBasisf();
    protected int m_iReplicate;

    public BSplineCurve3f(int iNumCtrlPoints, Vector3f[] akCtrlPoint, int iDegree, boolean bLoop, boolean bOpen) {
        super(0.0f, 1.0f);
        this.m_bLoop = bLoop;
        assert (iNumCtrlPoints >= 2);
        assert (1 <= iDegree && iDegree <= iNumCtrlPoints - 1);
        this.m_iNumCtrlPoints = iNumCtrlPoints;
        this.m_iReplicate = bLoop ? (bOpen ? 1 : iDegree) : 0;
        this.CreateControl(akCtrlPoint);
        this.m_kBasis.Create(this.m_iNumCtrlPoints + this.m_iReplicate, iDegree, bOpen);
    }

    public BSplineCurve3f(int iNumCtrlPoints, Vector3f[] akCtrlPoint, int iDegree, boolean bLoop, float[] afKnot) {
        super(0.0f, 1.0f);
        this.m_bLoop = bLoop;
        assert (iNumCtrlPoints >= 2);
        assert (1 <= iDegree && iDegree <= iNumCtrlPoints - 1);
        this.m_iNumCtrlPoints = iNumCtrlPoints;
        this.m_iReplicate = bLoop ? 1 : 0;
        this.CreateControl(akCtrlPoint);
        this.m_kBasis.Create(this.m_iNumCtrlPoints + this.m_iReplicate, iDegree, afKnot);
    }

    public static BSplineCurve3f CreateApproximation(float[] akValue, int iNumControlPoints, int iDegree) {
        int iNumSamples = akValue.length;
        BSplineBasisDiscretef kBasis = new BSplineBasisDiscretef(iNumControlPoints, iDegree, iNumSamples);
        GMatrixf kA = new GMatrixf(iNumControlPoints, iNumControlPoints);
        float[] kB = new float[iNumControlPoints];
        for (int iControl = 0; iControl < iNumControlPoints; ++iControl) {
            kB[iControl] = 0.0f;
        }
        for (int iSample = 0; iSample < iNumSamples; ++iSample) {
            for (int iRow = 0; iRow < iNumControlPoints; ++iRow) {
                int n = iRow;
                kB[n] = kB[n] + kBasis.GetD0(iRow, iSample) * akValue[iSample];
                for (int iCol = 0; iCol < iNumControlPoints; ++iCol) {
                    float dAij = kA.Get(iRow, iCol) + kBasis.GetD0(iRow, iSample) * kBasis.GetD0(iCol, iSample);
                    kA.Set(iRow, iCol, dAij);
                }
            }
        }
        kA.Inverse();
        Vector3f[] akControl = new Vector3f[iNumControlPoints];
        for (int iControl = 0; iControl < iNumControlPoints; ++iControl) {
            akControl[iControl] = new Vector3f(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < iNumControlPoints; ++i) {
                akControl[iControl].X += kA.Get(iControl, i) * kB[i];
            }
        }
        return new BSplineCurve3f(akControl.length, akControl, iDegree, false, true);
    }

    public static BSplineCurve3f CreateApproximation(Vector3f[] akPoint, int iNumControlPoints, int iDegree) {
        int iNumSamples = akPoint.length;
        BSplineBasisDiscretef kBasis = new BSplineBasisDiscretef(iNumControlPoints, iDegree, iNumSamples);
        GMatrixf kA = new GMatrixf(iNumControlPoints, iNumControlPoints);
        Vector3f[] kB = new Vector3f[iNumControlPoints];
        for (int iControl = 0; iControl < iNumControlPoints; ++iControl) {
            kB[iControl] = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        Vector3f kScale = new Vector3f();
        for (int iSample = 0; iSample < iNumSamples; ++iSample) {
            for (int iRow = 0; iRow < iNumControlPoints; ++iRow) {
                kScale.Scale(kBasis.GetD0(iRow, iSample), akPoint[iSample]);
                kB[iRow].Add(kScale, kB[iRow]);
                for (int iCol = 0; iCol < iNumControlPoints; ++iCol) {
                    float dAij = kA.Get(iRow, iCol) + kBasis.GetD0(iRow, iSample) * kBasis.GetD0(iCol, iSample);
                    kA.Set(iRow, iCol, dAij);
                }
            }
        }
        kA.Inverse();
        Vector3f[] akControl = new Vector3f[iNumControlPoints];
        for (int iControl = 0; iControl < iNumControlPoints; ++iControl) {
            akControl[iControl] = new Vector3f(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < iNumControlPoints; ++i) {
                kScale.Scale(kA.Get(iControl, i), kB[i]);
                akControl[iControl].Add(kScale, akControl[iControl]);
            }
        }
        return new BSplineCurve3f(akControl.length, akControl, iDegree, false, true);
    }

    public void dispose() {
        this.m_akCtrlPoint = null;
    }

    public void Get(float fTime, Vector3f pkPos, Vector3f pkDer1, Vector3f pkDer2, Vector3f pkDer3) {
        int i;
        int[] iMin = new int[1];
        int[] iMax = new int[1];
        if (pkDer3 != null) {
            this.m_kBasis.Compute(fTime, 3, iMin, iMax);
        } else if (pkDer2 != null) {
            this.m_kBasis.Compute(fTime, 2, iMin, iMax);
        } else if (pkDer1 != null) {
            this.m_kBasis.Compute(fTime, 1, iMin, iMax);
        } else {
            this.m_kBasis.Compute(fTime, 0, iMin, iMax);
        }
        if (pkPos != null) {
            pkPos.Copy(Vector3f.ZERO);
            for (i = iMin[0]; i <= iMax[0]; ++i) {
                pkPos.X += this.m_kBasis.GetD0(i) * this.m_akCtrlPoint[i].X;
                pkPos.Y += this.m_kBasis.GetD0(i) * this.m_akCtrlPoint[i].Y;
                pkPos.Z += this.m_kBasis.GetD0(i) * this.m_akCtrlPoint[i].Z;
            }
        }
        if (pkDer1 != null) {
            pkDer1.Copy(Vector3f.ZERO);
            for (i = iMin[0]; i <= iMax[0]; ++i) {
                pkDer1.X += this.m_kBasis.GetD1(i) * this.m_akCtrlPoint[i].X;
                pkDer1.Y += this.m_kBasis.GetD1(i) * this.m_akCtrlPoint[i].Y;
                pkDer1.Z += this.m_kBasis.GetD1(i) * this.m_akCtrlPoint[i].Z;
            }
        }
        if (pkDer2 != null) {
            pkDer2.Copy(Vector3f.ZERO);
            for (i = iMin[0]; i <= iMax[0]; ++i) {
                pkDer2.X += this.m_kBasis.GetD2(i) * this.m_akCtrlPoint[i].X;
                pkDer2.Y += this.m_kBasis.GetD2(i) * this.m_akCtrlPoint[i].Y;
                pkDer2.Z += this.m_kBasis.GetD2(i) * this.m_akCtrlPoint[i].Z;
            }
        }
        if (pkDer3 != null) {
            pkDer3.Copy(Vector3f.ZERO);
            for (i = iMin[0]; i <= iMax[0]; ++i) {
                pkDer3.X += this.m_kBasis.GetD3(i) * this.m_akCtrlPoint[i].X;
                pkDer3.Y += this.m_kBasis.GetD3(i) * this.m_akCtrlPoint[i].Y;
                pkDer3.Z += this.m_kBasis.GetD3(i) * this.m_akCtrlPoint[i].Z;
            }
        }
    }

    public BSplineBasisf GetBasis() {
        return this.m_kBasis;
    }

    public Vector3f GetControlPoint(int i) {
        if (0 <= i && i < this.m_iNumCtrlPoints) {
            return this.m_akCtrlPoint[i];
        }
        return new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    }

    public int GetDegree() {
        return this.m_kBasis.GetDegree();
    }

    @Override
    public Vector3f GetFirstDerivative(float fTime) {
        Vector3f kDer1 = new Vector3f();
        this.Get(fTime, null, kDer1, null, null);
        return kDer1;
    }

    public float GetKnot(int i) {
        return this.m_kBasis.GetKnot(i);
    }

    public int GetNumCtrlPoints() {
        return this.m_iNumCtrlPoints;
    }

    @Override
    public Vector3f GetPosition(float fTime) {
        Vector3f kPos = new Vector3f();
        this.Get(fTime, kPos, null, null, null);
        return kPos;
    }

    @Override
    public Vector3f GetSecondDerivative(float fTime) {
        Vector3f kDer2 = new Vector3f();
        this.Get(fTime, null, null, kDer2, null);
        return kDer2;
    }

    @Override
    public Vector3f GetThirdDerivative(float fTime) {
        Vector3f kDer3 = new Vector3f();
        this.Get(fTime, null, null, null, kDer3);
        return kDer3;
    }

    @Override
    public float GetVariation(float fT0, float fT1, Vector3f pkP0, Vector3f pkP1) {
        return 0.0f;
    }

    public boolean IsLoop() {
        return this.m_bLoop;
    }

    public boolean IsOpen() {
        return this.m_kBasis.IsOpen();
    }

    public boolean IsUniform() {
        return this.m_kBasis.IsUniform();
    }

    public void SetControlPoint(int i, Vector3f rkCtrl) {
        if (0 <= i && i < this.m_iNumCtrlPoints) {
            this.m_akCtrlPoint[i] = new Vector3f(rkCtrl);
            if (i < this.m_iReplicate) {
                this.m_akCtrlPoint[this.m_iNumCtrlPoints + i] = new Vector3f(rkCtrl);
            }
        }
    }

    public void SetKnot(int i, float fKnot) {
        this.m_kBasis.SetKnot(i, fKnot);
    }

    private void CreateControl(Vector3f[] akCtrlPoint) {
        int i;
        int iNewNumCtrlPoints = this.m_iNumCtrlPoints + this.m_iReplicate;
        this.m_akCtrlPoint = new Vector3f[iNewNumCtrlPoints];
        for (i = 0; i < this.m_iNumCtrlPoints; ++i) {
            this.m_akCtrlPoint[i] = new Vector3f(akCtrlPoint[i]);
        }
        for (i = 0; i < this.m_iReplicate; ++i) {
            this.m_akCtrlPoint[this.m_iNumCtrlPoints + i] = new Vector3f(akCtrlPoint[i]);
        }
    }
}

