/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Curves;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public abstract class Curve3f
implements Serializable {
    private static final long serialVersionUID = 7498576726527924547L;
    protected float m_fTMin;
    protected float m_fTMax;

    public Curve3f(float fTMin, float fTMax) {
        this.m_fTMin = fTMin;
        this.m_fTMax = fTMax;
    }

    public Vector3f GetBinormal(float fTime) {
        Vector3f kVelocity = this.GetFirstDerivative(fTime);
        Vector3f kAcceleration = this.GetSecondDerivative(fTime);
        float fVDotV = kVelocity.Dot(kVelocity);
        float fVDotA = kVelocity.Dot(kAcceleration);
        Vector3f kVdVmA = new Vector3f();
        kVdVmA.Scale(fVDotV, kAcceleration);
        Vector3f kVdAmV = new Vector3f();
        kVdAmV.Scale(fVDotA, kVelocity);
        Vector3f kNormal = new Vector3f();
        kNormal.Sub(kVdVmA, kVdAmV);
        kNormal.Normalize();
        kVelocity.Normalize();
        Vector3f kBinormal = new Vector3f();
        kBinormal.Cross(kVelocity, kNormal);
        return kBinormal;
    }

    public float GetCurvature(float fTime) {
        Vector3f kVelocity = this.GetFirstDerivative(fTime);
        float fSpeedSqr = kVelocity.SquaredLength();
        if (fSpeedSqr >= 1.0E-6f) {
            Vector3f kAcceleration = this.GetSecondDerivative(fTime);
            Vector3f kCross = new Vector3f();
            kCross.Cross(kVelocity, kAcceleration);
            float fNumer = kCross.Length();
            float fDenom = (float)Math.pow(fSpeedSqr, 1.5);
            return fNumer / fDenom;
        }
        return 0.0f;
    }

    public abstract Vector3f GetFirstDerivative(float var1);

    public void GetFrame(float fTime, Vector3f rkPosition, Vector3f rkTangent, Vector3f rkNormal, Vector3f rkBinormal) {
        rkPosition = this.GetPosition(fTime);
        Vector3f kVelocity = this.GetFirstDerivative(fTime);
        Vector3f kAcceleration = this.GetSecondDerivative(fTime);
        float fVDotV = kVelocity.Dot(kVelocity);
        float fVDotA = kVelocity.Dot(kAcceleration);
        Vector3f kVdVmA = new Vector3f();
        kVdVmA.Scale(fVDotV, kAcceleration);
        Vector3f kVdAmV = new Vector3f();
        kVdAmV.Scale(fVDotA, kVelocity);
        Vector3f kNormal = new Vector3f();
        kNormal.Sub(kVdVmA, kVdAmV);
        rkNormal.Normalize();
        rkTangent = kVelocity;
        rkTangent.Normalize();
        rkBinormal.Cross(rkTangent, rkNormal);
    }

    public abstract float GetLength(float var1, float var2);

    public float GetMaxTime() {
        return this.m_fTMax;
    }

    public float GetMinTime() {
        return this.m_fTMin;
    }

    public Vector3f GetNormal(float fTime) {
        Vector3f kVelocity = this.GetFirstDerivative(fTime);
        Vector3f kAcceleration = this.GetSecondDerivative(fTime);
        float fVDotV = kVelocity.Dot(kVelocity);
        float fVDotA = kVelocity.Dot(kAcceleration);
        Vector3f kVdVmA = new Vector3f();
        kVdVmA.Scale(fVDotV, kAcceleration);
        Vector3f kVdAmV = new Vector3f();
        kVdAmV.Scale(fVDotA, kVelocity);
        Vector3f kNormal = new Vector3f();
        kNormal.Sub(kVdVmA, kVdAmV);
        kNormal.Normalize();
        return kNormal;
    }

    public abstract Vector3f GetPosition(float var1);

    public abstract Vector3f GetSecondDerivative(float var1);

    public float GetSpeed(float fTime) {
        Vector3f kVelocity = this.GetFirstDerivative(fTime);
        float fSpeed = kVelocity.Length();
        return fSpeed;
    }

    public Vector3f GetTangent(float fTime) {
        Vector3f kVelocity = this.GetFirstDerivative(fTime);
        kVelocity.Normalize();
        return kVelocity;
    }

    public abstract Vector3f GetThirdDerivative(float var1);

    public float GetTime(float fLength) {
        return this.GetTime(fLength, 32, 1.0E-6f);
    }

    public abstract float GetTime(float var1, int var2, float var3);

    public float GetTorsion(float fTime) {
        Vector3f kVelocity = this.GetFirstDerivative(fTime);
        Vector3f kAcceleration = this.GetSecondDerivative(fTime);
        Vector3f kCross = new Vector3f();
        kCross.Cross(kVelocity, kAcceleration);
        float fDenom = kCross.SquaredLength();
        if (fDenom >= 1.0E-6f) {
            Vector3f kJerk = this.GetThirdDerivative(fTime);
            float fNumer = kCross.Dot(kJerk);
            return fNumer / fDenom;
        }
        return 0.0f;
    }

    public float GetTotalLength() {
        return this.GetLength(this.m_fTMin, this.m_fTMax);
    }

    public abstract float GetVariation(float var1, float var2, Vector3f var3, Vector3f var4);

    public void SetTimeInterval(float fTMin, float fTMax) {
        assert (fTMin < fTMax);
        this.m_fTMin = fTMin;
        this.m_fTMax = fTMax;
    }

    public void SubdivideByLength(int iNumPoints, Vector3f[] rakPoint) {
        assert (iNumPoints >= 2);
        rakPoint = new Vector3f[iNumPoints];
        float fDelta = this.GetTotalLength() / (float)(iNumPoints - 1);
        for (int i = 0; i < iNumPoints; ++i) {
            float fLength = fDelta * (float)i;
            float fTime = this.GetTime(fLength);
            rakPoint[i] = this.GetPosition(fTime);
        }
    }

    public void SubdivideByTime(int iNumPoints, Vector3f[] rakPoint) {
        assert (iNumPoints >= 2);
        rakPoint = new Vector3f[iNumPoints];
        float fDelta = (this.m_fTMax - this.m_fTMin) / (float)(iNumPoints - 1);
        for (int i = 0; i < iNumPoints; ++i) {
            float fTime = this.m_fTMin + fDelta * (float)i;
            rakPoint[i] = this.GetPosition(fTime);
        }
    }

    public void SubdivideByVariation(float fMinVariation, int iMaxLevel, int riNumPoints, Vector3f[] rakPoint) {
        Vector3f kPMin = this.GetPosition(this.m_fTMin);
        Vector3f kPMax = this.GetPosition(this.m_fTMax);
        PointList pkList = new PointList(kPMin, null);
        riNumPoints = 1;
        this.SubdivideByVariation(this.m_fTMin, kPMin, this.m_fTMax, kPMax, fMinVariation, iMaxLevel, riNumPoints, pkList.m_kNext);
        assert (riNumPoints >= 2);
        rakPoint = new Vector3f[riNumPoints];
        for (int i = 0; i < riNumPoints; ++i) {
            assert (pkList != null);
            rakPoint[i] = pkList.m_kPoint;
            pkList = pkList.m_kNext;
        }
        assert (pkList == null);
    }

    protected void SubdivideByVariation(float fT0, Vector3f rkP0, float fT1, Vector3f rkP1, float fMinVariation, int iLevel, int riNumPoints, PointList rpkList) {
        if (iLevel > 0 && this.GetVariation(fT0, fT1, rkP0, rkP1) > fMinVariation) {
            float fTMid = 0.5f * (fT0 + fT1);
            Vector3f kPMid = this.GetPosition(fTMid);
            this.SubdivideByVariation(fT0, rkP0, fTMid, kPMid, fMinVariation, --iLevel, riNumPoints, rpkList);
            this.SubdivideByVariation(fTMid, kPMid, fT1, rkP1, fMinVariation, iLevel, riNumPoints, rpkList);
        } else {
            rpkList = new PointList(rkP1, rpkList);
            ++riNumPoints;
        }
    }

    protected class PointList {
        Vector3f m_kPoint;
        PointList m_kNext;

        public PointList(Vector3f rkPoint, PointList pkNext) {
            this.m_kPoint = rkPoint;
            this.m_kNext = pkNext;
        }
    }
}

