/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Curves;

import WildMagic.LibFoundation.Curves.MultipleCurve3;
import WildMagic.LibFoundation.Mathematics.GMatrixf;
import WildMagic.LibFoundation.Mathematics.Polynomial1f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.NumericalAnalysis.Integrate1;
import WildMagic.LibFoundation.NumericalAnalysis.IntegrateInterface;
import WildMagic.LibFoundation.NumericalAnalysis.LinearSystem;
import java.io.Serializable;

public class NaturalSpline3
extends MultipleCurve3
implements Serializable {
    private static final long serialVersionUID = -1914640151532622635L;
    protected Vector3f[] m_akA;
    protected Vector3f[] m_akB;
    protected Vector3f[] m_akC;
    protected Vector3f[] m_akD;

    public NaturalSpline3(BoundaryType eType, int iSegments, float[] afTime, Vector3f[] akPoint) {
        super(iSegments, afTime);
        this.m_akA = akPoint;
        switch (eType) {
            case BT_FREE: {
                this.CreateFreeSpline();
                break;
            }
            case BT_CLAMPED: {
                this.CreateClampedSpline();
                break;
            }
            case BT_CLOSED: {
                this.CreateClosedSpline();
            }
        }
    }

    @Override
    public Vector3f GetFirstDerivative(float fTime) {
        int[] iKey = new int[1];
        float[] fDt = new float[12];
        this.GetKeyInfo(fTime, iKey, fDt);
        Vector3f kResult = new Vector3f();
        kResult.X = this.m_akB[iKey[0]].X + fDt[0] * (2.0f * this.m_akC[iKey[0]].X + 3.0f * fDt[0] * this.m_akD[iKey[0]].X);
        kResult.Y = this.m_akB[iKey[0]].Y + fDt[0] * (2.0f * this.m_akC[iKey[0]].Y + 3.0f * fDt[0] * this.m_akD[iKey[0]].Y);
        kResult.Z = this.m_akB[iKey[0]].Z + fDt[0] * (2.0f * this.m_akC[iKey[0]].Z + 3.0f * fDt[0] * this.m_akD[iKey[0]].Z);
        return kResult;
    }

    @Override
    public float GetLengthKey(int iKey, float fT0, float fT1) {
        ThisPlusKey kData = new ThisPlusKey(this, iKey);
        return Integrate1.RombergIntegral(8, fT0, fT1, kData);
    }

    public Vector3f[] GetPoints() {
        return this.m_akA;
    }

    @Override
    public Vector3f GetPosition(float fTime) {
        int[] iKey = new int[1];
        float[] fDt = new float[12];
        this.GetKeyInfo(fTime, iKey, fDt);
        Vector3f kResult = new Vector3f();
        kResult.X = this.m_akA[iKey[0]].X + fDt[0] * (this.m_akB[iKey[0]].X + fDt[0] * (this.m_akC[iKey[0]].X + fDt[0] * this.m_akD[iKey[0]].X));
        kResult.Y = this.m_akA[iKey[0]].Y + fDt[0] * (this.m_akB[iKey[0]].Y + fDt[0] * (this.m_akC[iKey[0]].Y + fDt[0] * this.m_akD[iKey[0]].Y));
        kResult.Z = this.m_akA[iKey[0]].Z + fDt[0] * (this.m_akB[iKey[0]].Z + fDt[0] * (this.m_akC[iKey[0]].Z + fDt[0] * this.m_akD[iKey[0]].Z));
        return kResult;
    }

    @Override
    public Vector3f GetSecondDerivative(float fTime) {
        int[] iKey = new int[1];
        float[] fDt = new float[12];
        this.GetKeyInfo(fTime, iKey, fDt);
        Vector3f kResult = new Vector3f();
        kResult.X = 2.0f * this.m_akC[iKey[0]].X + 6.0f * fDt[0] * this.m_akD[iKey[0]].X;
        kResult.Y = 2.0f * this.m_akC[iKey[0]].Y + 6.0f * fDt[0] * this.m_akD[iKey[0]].Y;
        kResult.Z = 2.0f * this.m_akC[iKey[0]].Z + 6.0f * fDt[0] * this.m_akD[iKey[0]].Z;
        return kResult;
    }

    @Override
    public float GetSpeedKey(int iKey, float fTime) {
        Vector3f kVelocity = new Vector3f();
        kVelocity.X = this.m_akB[iKey].X + fTime * (2.0f * this.m_akC[iKey].X + 3.0f * fTime * this.m_akD[iKey].X);
        kVelocity.Y = this.m_akB[iKey].Y + fTime * (2.0f * this.m_akC[iKey].Y + 3.0f * fTime * this.m_akD[iKey].Y);
        kVelocity.Z = this.m_akB[iKey].Z + fTime * (2.0f * this.m_akC[iKey].Z + 3.0f * fTime * this.m_akD[iKey].Z);
        return kVelocity.Length();
    }

    @Override
    public Vector3f GetThirdDerivative(float fTime) {
        int[] iKey = new int[1];
        float[] fDt = new float[12];
        this.GetKeyInfo(fTime, iKey, fDt);
        Vector3f kResult = new Vector3f(this.m_akD[iKey[0]]);
        kResult.Scale(6.0f);
        return kResult;
    }

    @Override
    public float GetVariationKey(int iKey, float fT0, float fT1, Vector3f rkA, Vector3f rkB) {
        Polynomial1f kXPoly = new Polynomial1f(3);
        kXPoly.SetCoeff(0, this.m_akA[iKey].X);
        kXPoly.SetCoeff(1, this.m_akB[iKey].X);
        kXPoly.SetCoeff(2, this.m_akC[iKey].X);
        kXPoly.SetCoeff(3, this.m_akD[iKey].X);
        Polynomial1f kYPoly = new Polynomial1f(3);
        kYPoly.SetCoeff(0, this.m_akA[iKey].Y);
        kYPoly.SetCoeff(1, this.m_akB[iKey].Y);
        kYPoly.SetCoeff(2, this.m_akC[iKey].Y);
        kYPoly.SetCoeff(3, this.m_akD[iKey].Y);
        Polynomial1f kZPoly = new Polynomial1f(3);
        kZPoly.SetCoeff(0, this.m_akA[iKey].Z);
        kZPoly.SetCoeff(1, this.m_akB[iKey].Z);
        kZPoly.SetCoeff(2, this.m_akC[iKey].Z);
        kZPoly.SetCoeff(3, this.m_akD[iKey].Z);
        Polynomial1f kLx = new Polynomial1f(1);
        Polynomial1f kLy = new Polynomial1f(1);
        Polynomial1f kLz = new Polynomial1f(1);
        kLx.SetCoeff(0, rkA.X);
        kLx.SetCoeff(1, rkB.X);
        kLy.SetCoeff(0, rkA.Y);
        kLy.SetCoeff(1, rkB.Y);
        kLz.SetCoeff(0, rkA.Z);
        kLz.SetCoeff(1, rkB.Z);
        Polynomial1f kDx = new Polynomial1f();
        kDx.Sub(kXPoly, kLx);
        kDx.Mult(kDx, kDx);
        Polynomial1f kDy = new Polynomial1f();
        kDy.Sub(kYPoly, kLy);
        kDy.Mult(kDy, kDy);
        Polynomial1f kDz = new Polynomial1f();
        kDz.Sub(kZPoly, kLz);
        kDz.Mult(kDz, kDz);
        Polynomial1f kNormSqr = new Polynomial1f();
        kNormSqr.Add(kDx, kDy);
        kNormSqr.Add(kNormSqr, kDz);
        Polynomial1f kIntegral = new Polynomial1f(kNormSqr.GetDegree() + 1);
        kIntegral.SetCoeff(0, 0.0f);
        for (int i = 1; i <= kIntegral.GetDegree(); ++i) {
            kIntegral.SetCoeff(i, kNormSqr.GetCoeff(i - 1) / (float)i);
        }
        float fResult = kIntegral.Eval(fT1) - kIntegral.Eval(fT0);
        return fResult;
    }

    protected void CreateClampedSpline() {
        int i;
        float[] afDt = new float[this.m_iSegments];
        for (i = 0; i < this.m_iSegments; ++i) {
            afDt[i] = this.m_afTime[i + 1] - this.m_afTime[i];
        }
        float[] afD2t = new float[this.m_iSegments];
        for (i = 1; i < this.m_iSegments; ++i) {
            afD2t[i] = this.m_afTime[i + 1] - this.m_afTime[i - 1];
        }
        Vector3f[] akAlpha = new Vector3f[this.m_iSegments + 1];
        float fInv = 1.0f / afDt[0];
        akAlpha[0] = new Vector3f();
        akAlpha[0].X = 3.0f * (fInv - 1.0f) * (this.m_akA[1].X - this.m_akA[0].X);
        akAlpha[0].Y = 3.0f * (fInv - 1.0f) * (this.m_akA[1].Y - this.m_akA[0].Y);
        akAlpha[0].Z = 3.0f * (fInv - 1.0f) * (this.m_akA[1].Z - this.m_akA[0].Z);
        fInv = 1.0f / afDt[this.m_iSegments - 1];
        akAlpha[this.m_iSegments] = new Vector3f();
        akAlpha[this.m_iSegments].X = 3.0f * (1.0f - fInv) * (this.m_akA[this.m_iSegments].X - this.m_akA[this.m_iSegments - 1].X);
        akAlpha[this.m_iSegments].Y = 3.0f * (1.0f - fInv) * (this.m_akA[this.m_iSegments].Y - this.m_akA[this.m_iSegments - 1].Y);
        akAlpha[this.m_iSegments].Z = 3.0f * (1.0f - fInv) * (this.m_akA[this.m_iSegments].Z - this.m_akA[this.m_iSegments - 1].Z);
        Vector3f kNumer = new Vector3f();
        for (i = 1; i < this.m_iSegments; ++i) {
            kNumer.X = 3.0f * (afDt[i - 1] * this.m_akA[i + 1].X - afD2t[i] * this.m_akA[i].X + afDt[i] * this.m_akA[i - 1].X);
            kNumer.Y = 3.0f * (afDt[i - 1] * this.m_akA[i + 1].Y - afD2t[i] * this.m_akA[i].Y + afDt[i] * this.m_akA[i - 1].Y);
            kNumer.Z = 3.0f * (afDt[i - 1] * this.m_akA[i + 1].Z - afD2t[i] * this.m_akA[i].Z + afDt[i] * this.m_akA[i - 1].Z);
            float fInvDenom = 1.0f / (afDt[i - 1] * afDt[i]);
            akAlpha[i] = new Vector3f();
            akAlpha[i].Scale(fInvDenom, kNumer);
        }
        float[] afEll = new float[this.m_iSegments + 1];
        float[] afMu = new float[this.m_iSegments];
        Vector3f[] akZ = new Vector3f[this.m_iSegments + 1];
        afEll[0] = 2.0f * afDt[0];
        afMu[0] = 0.5f;
        fInv = 1.0f / afEll[0];
        akZ[0] = new Vector3f();
        akZ[0].Scale(fInv, akAlpha[0]);
        for (i = 1; i < this.m_iSegments; ++i) {
            afEll[i] = 2.0f * afD2t[i] - afDt[i - 1] * afMu[i - 1];
            fInv = 1.0f / afEll[i];
            afMu[i] = fInv * afDt[i];
            akZ[i] = new Vector3f();
            akZ[i].X = fInv * (akAlpha[i].X - afDt[i - 1] * akZ[i - 1].X);
            akZ[i].Y = fInv * (akAlpha[i].Y - afDt[i - 1] * akZ[i - 1].Y);
            akZ[i].Z = fInv * (akAlpha[i].Z - afDt[i - 1] * akZ[i - 1].Z);
        }
        afEll[this.m_iSegments] = afDt[this.m_iSegments - 1] * (2.0f - afMu[this.m_iSegments - 1]);
        fInv = 1.0f / afEll[this.m_iSegments];
        akZ[this.m_iSegments] = new Vector3f();
        akZ[this.m_iSegments].X = fInv * (akAlpha[this.m_iSegments].X - afDt[this.m_iSegments - 1] * akZ[this.m_iSegments - 1].X);
        akZ[this.m_iSegments].Y = fInv * (akAlpha[this.m_iSegments].Y - afDt[this.m_iSegments - 1] * akZ[this.m_iSegments - 1].Y);
        akZ[this.m_iSegments].Z = fInv * (akAlpha[this.m_iSegments].Z - afDt[this.m_iSegments - 1] * akZ[this.m_iSegments - 1].Z);
        this.m_akB = new Vector3f[this.m_iSegments];
        this.m_akC = new Vector3f[this.m_iSegments + 1];
        this.m_akD = new Vector3f[this.m_iSegments];
        this.m_akC[this.m_iSegments].Copy(akZ[this.m_iSegments]);
        float fOneThird = 0.33333334f;
        for (i = this.m_iSegments - 1; i >= 0; --i) {
            fInv = 1.0f / afDt[i];
            this.m_akC[i].X = akZ[i].X - afMu[i] * this.m_akC[i + 1].X;
            this.m_akC[i].Y = akZ[i].Y - afMu[i] * this.m_akC[i + 1].Y;
            this.m_akC[i].Z = akZ[i].Z - afMu[i] * this.m_akC[i + 1].Z;
            this.m_akB[i].X = fInv * (this.m_akA[i + 1].X - this.m_akA[i].X) - 0.33333334f * afDt[i] * (this.m_akC[i + 1].X + 2.0f * this.m_akC[i].X);
            this.m_akB[i].Y = fInv * (this.m_akA[i + 1].Y - this.m_akA[i].Y) - 0.33333334f * afDt[i] * (this.m_akC[i + 1].Y + 2.0f * this.m_akC[i].Y);
            this.m_akB[i].Z = fInv * (this.m_akA[i + 1].Z - this.m_akA[i].Z) - 0.33333334f * afDt[i] * (this.m_akC[i + 1].Z + 2.0f * this.m_akC[i].Z);
            this.m_akD[i].X = 0.33333334f * fInv * (this.m_akC[i + 1].X - this.m_akC[i].X);
            this.m_akD[i].Y = 0.33333334f * fInv * (this.m_akC[i + 1].Y - this.m_akC[i].Y);
            this.m_akD[i].Z = 0.33333334f * fInv * (this.m_akC[i + 1].Z - this.m_akC[i].Z);
        }
        afDt = null;
        afD2t = null;
        akAlpha = null;
        afEll = null;
        afMu = null;
        akZ = null;
    }

    protected void CreateClosedSpline() {
        float fInv1;
        float fInv0;
        int i;
        float[] afDt = new float[this.m_iSegments];
        for (i = 0; i < this.m_iSegments; ++i) {
            afDt[i] = this.m_afTime[i + 1] - this.m_afTime[i];
        }
        GMatrixf kMat = new GMatrixf(this.m_iSegments + 1, this.m_iSegments + 1);
        kMat.Set(0, 0, 1.0f);
        kMat.Set(0, this.m_iSegments, -1.0f);
        for (i = 1; i <= this.m_iSegments - 1; ++i) {
            kMat.Set(i, i - 1, afDt[i - 1]);
            kMat.Set(i, i, 2.0f * (afDt[i - 1] + afDt[i]));
            kMat.Set(i, i + 1, afDt[i]);
        }
        kMat.Set(this.m_iSegments, this.m_iSegments - 1, afDt[this.m_iSegments - 1]);
        kMat.Set(this.m_iSegments, 0, 2.0f * (afDt[this.m_iSegments - 1] + afDt[0]));
        kMat.Set(this.m_iSegments, 1, afDt[0]);
        this.m_akC = new Vector3f[this.m_iSegments + 1];
        this.m_akC[0].Copy(Vector3f.ZERO);
        for (i = 1; i <= this.m_iSegments - 1; ++i) {
            fInv0 = 1.0f / afDt[i];
            fInv1 = 1.0f / afDt[i - 1];
            this.m_akC[i].X = 3.0f * (fInv0 * (this.m_akA[i + 1].X - this.m_akA[i].X) - fInv1 * (this.m_akA[i].X - this.m_akA[i - 1].X));
            this.m_akC[i].Y = 3.0f * (fInv0 * (this.m_akA[i + 1].Y - this.m_akA[i].Y) - fInv1 * (this.m_akA[i].Y - this.m_akA[i - 1].Y));
            this.m_akC[i].Z = 3.0f * (fInv0 * (this.m_akA[i + 1].Z - this.m_akA[i].Z) - fInv1 * (this.m_akA[i].Z - this.m_akA[i - 1].Z));
        }
        fInv0 = 1.0f / afDt[0];
        fInv1 = 1.0f / afDt[this.m_iSegments - 1];
        this.m_akC[this.m_iSegments].X = 3.0f * (fInv0 * (this.m_akA[1].X - this.m_akA[0].X) - fInv1 * (this.m_akA[0].X - this.m_akA[this.m_iSegments - 1].X));
        this.m_akC[this.m_iSegments].Y = 3.0f * (fInv0 * (this.m_akA[1].Y - this.m_akA[0].Y) - fInv1 * (this.m_akA[0].Y - this.m_akA[this.m_iSegments - 1].Y));
        this.m_akC[this.m_iSegments].Z = 3.0f * (fInv0 * (this.m_akA[1].Z - this.m_akA[0].Z) - fInv1 * (this.m_akA[0].Z - this.m_akA[this.m_iSegments - 1].Z));
        float[] afInput = new float[this.m_iSegments + 1];
        float[] afOutput = new float[this.m_iSegments + 1];
        for (i = 0; i <= this.m_iSegments; ++i) {
            afInput[i] = this.m_akC[i].X;
        }
        LinearSystem.Solve(kMat, afInput, afOutput);
        for (i = 0; i <= this.m_iSegments; ++i) {
            this.m_akC[i].X = afOutput[i];
        }
        for (i = 0; i <= this.m_iSegments; ++i) {
            afInput[i] = this.m_akC[i].Y;
        }
        LinearSystem.Solve(kMat, afInput, afOutput);
        for (i = 0; i <= this.m_iSegments; ++i) {
            this.m_akC[i].Y = afOutput[i];
        }
        for (i = 0; i <= this.m_iSegments; ++i) {
            afInput[i] = this.m_akC[i].Z;
        }
        LinearSystem.Solve(kMat, afInput, afOutput);
        for (i = 0; i <= this.m_iSegments; ++i) {
            this.m_akC[i].Z = afOutput[i];
        }
        afInput = null;
        afOutput = null;
        float fOneThird = 0.33333334f;
        this.m_akB = new Vector3f[this.m_iSegments];
        this.m_akD = new Vector3f[this.m_iSegments];
        for (i = 0; i < this.m_iSegments; ++i) {
            fInv0 = 1.0f / afDt[i];
            this.m_akB[i].X = fInv0 * (this.m_akA[i + 1].X - this.m_akA[i].X) - 0.33333334f * (this.m_akC[i + 1].X + 2.0f * this.m_akC[i].X) * afDt[i];
            this.m_akB[i].Y = fInv0 * (this.m_akA[i + 1].Y - this.m_akA[i].Y) - 0.33333334f * (this.m_akC[i + 1].Y + 2.0f * this.m_akC[i].Y) * afDt[i];
            this.m_akB[i].Z = fInv0 * (this.m_akA[i + 1].Z - this.m_akA[i].Z) - 0.33333334f * (this.m_akC[i + 1].Z + 2.0f * this.m_akC[i].Z) * afDt[i];
            this.m_akD[i].X = 0.33333334f * fInv0 * (this.m_akC[i + 1].X - this.m_akC[i].X);
            this.m_akD[i].Y = 0.33333334f * fInv0 * (this.m_akC[i + 1].Y - this.m_akC[i].Y);
            this.m_akD[i].Z = 0.33333334f * fInv0 * (this.m_akC[i + 1].Z - this.m_akC[i].Z);
        }
        afDt = null;
    }

    protected void CreateFreeSpline() {
        float fInv;
        int i;
        float[] afDt = new float[this.m_iSegments];
        for (i = 0; i < this.m_iSegments; ++i) {
            afDt[i] = this.m_afTime[i + 1] - this.m_afTime[i];
        }
        float[] afD2t = new float[this.m_iSegments];
        for (i = 1; i < this.m_iSegments; ++i) {
            afD2t[i] = this.m_afTime[i + 1] - this.m_afTime[i - 1];
        }
        Vector3f[] akAlpha = new Vector3f[this.m_iSegments];
        Vector3f kNumer = new Vector3f();
        for (i = 1; i < this.m_iSegments; ++i) {
            kNumer.X = 3.0f * (afDt[i - 1] * this.m_akA[i + 1].X - afD2t[i] * this.m_akA[i].X + afDt[i] * this.m_akA[i - 1].X);
            kNumer.Y = 3.0f * (afDt[i - 1] * this.m_akA[i + 1].Y - afD2t[i] * this.m_akA[i].Y + afDt[i] * this.m_akA[i - 1].Y);
            kNumer.Z = 3.0f * (afDt[i - 1] * this.m_akA[i + 1].Z - afD2t[i] * this.m_akA[i].Z + afDt[i] * this.m_akA[i - 1].Z);
            float fInvDenom = 1.0f / (afDt[i - 1] * afDt[i]);
            akAlpha[i].Scale(fInvDenom, kNumer);
        }
        float[] afEll = new float[this.m_iSegments + 1];
        float[] afMu = new float[this.m_iSegments];
        Vector3f[] akZ = new Vector3f[this.m_iSegments + 1];
        afEll[0] = 1.0f;
        afMu[0] = 0.0f;
        akZ[0].Copy(Vector3f.ZERO);
        for (i = 1; i < this.m_iSegments; ++i) {
            afEll[i] = 2.0f * afD2t[i] - afDt[i - 1] * afMu[i - 1];
            fInv = 1.0f / afEll[i];
            afMu[i] = fInv * afDt[i];
            akZ[i].X = fInv * (akAlpha[i].X - afDt[i - 1] * akZ[i - 1].X);
            akZ[i].Y = fInv * (akAlpha[i].Y - afDt[i - 1] * akZ[i - 1].Y);
            akZ[i].Z = fInv * (akAlpha[i].Z - afDt[i - 1] * akZ[i - 1].Z);
        }
        afEll[this.m_iSegments] = 1.0f;
        akZ[this.m_iSegments].Copy(Vector3f.ZERO);
        this.m_akB = new Vector3f[this.m_iSegments];
        this.m_akC = new Vector3f[this.m_iSegments + 1];
        this.m_akD = new Vector3f[this.m_iSegments];
        this.m_akC[this.m_iSegments].Copy(Vector3f.ZERO);
        float fOneThird = 0.33333334f;
        for (i = this.m_iSegments - 1; i >= 0; --i) {
            this.m_akC[i].X = akZ[i].X - afMu[i] * this.m_akC[i + 1].X;
            this.m_akC[i].Y = akZ[i].Y - afMu[i] * this.m_akC[i + 1].Y;
            this.m_akC[i].Z = akZ[i].Z - afMu[i] * this.m_akC[i + 1].Z;
            fInv = 1.0f / afDt[i];
            this.m_akB[i].X = fInv * (this.m_akA[i + 1].X - this.m_akA[i].X) - 0.33333334f * afDt[i] * (this.m_akC[i + 1].X + 2.0f * this.m_akC[i].X);
            this.m_akB[i].Y = fInv * (this.m_akA[i + 1].Y - this.m_akA[i].Y) - 0.33333334f * afDt[i] * (this.m_akC[i + 1].Y + 2.0f * this.m_akC[i].Y);
            this.m_akB[i].Z = fInv * (this.m_akA[i + 1].Z - this.m_akA[i].Z) - 0.33333334f * afDt[i] * (this.m_akC[i + 1].Z + 2.0f * this.m_akC[i].Z);
            this.m_akD[i].X = 0.33333334f * fInv * (this.m_akC[i + 1].X - this.m_akC[i].X);
            this.m_akD[i].Y = 0.33333334f * fInv * (this.m_akC[i + 1].Y - this.m_akC[i].Y);
            this.m_akD[i].Z = 0.33333334f * fInv * (this.m_akC[i + 1].Z - this.m_akC[i].Z);
        }
        afDt = null;
        afD2t = null;
        akAlpha = null;
        afEll = null;
        afMu = null;
        akZ = null;
    }

    protected class ThisPlusKey
    implements IntegrateInterface {
        final NaturalSpline3 This;
        int Key;

        public ThisPlusKey(NaturalSpline3 pkThis, int iKey) {
            this.This = pkThis;
            this.Key = iKey;
        }

        @Override
        public float Integrate(float fTime) {
            return this.This.GetSpeedWithData(fTime, this.This);
        }
    }

    public static enum BoundaryType {
        BT_FREE,
        BT_CLAMPED,
        BT_CLOSED;

    }
}

