/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Distance;

import WildMagic.LibFoundation.Mathematics.Vector3f;

public abstract class Distance {
    public int MaximumIterations = 8;
    public float ZeroThreshold = 1.0E-6f;
    protected float m_fContactTime;
    protected Vector3f m_kClosestPoint0 = new Vector3f();
    protected Vector3f m_kClosestPoint1 = new Vector3f();
    protected boolean m_bHasMultipleClosestPoints0;
    protected boolean m_bHasMultipleClosestPoints1;
    protected float m_fDifferenceStep;
    protected float m_fInvTwoDifferenceStep;

    public Distance() {
        this.SetDifferenceStep(0.001f);
        this.m_fContactTime = Float.MAX_VALUE;
        this.m_bHasMultipleClosestPoints0 = false;
        this.m_bHasMultipleClosestPoints1 = false;
    }

    public void dispose() {
        this.m_kClosestPoint0 = null;
        this.m_kClosestPoint1 = null;
    }

    public abstract float Get();

    public abstract float GetSquared();

    public abstract float Get(float var1, Vector3f var2, Vector3f var3);

    public abstract float GetSquared(float var1, Vector3f var2, Vector3f var3);

    public float GetDerivative(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        float fFp = this.Get(fT + this.m_fDifferenceStep, rkVelocity0, rkVelocity1);
        float fFm = this.Get(fT - this.m_fDifferenceStep, rkVelocity0, rkVelocity1);
        float fDFApprox = this.m_fInvTwoDifferenceStep * (fFp - fFm);
        return fDFApprox;
    }

    public float GetDerivativeSquared(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        float fDistance = this.Get(fT, rkVelocity0, rkVelocity1);
        float fDerivative = this.GetDerivative(fT, rkVelocity0, rkVelocity1);
        return 2.0f * fDistance * fDerivative;
    }

    public float Get(float fTMin, float fTMax, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        float fT;
        int i;
        float fT0 = fTMin;
        float fF0 = this.Get(fT0, rkVelocity0, rkVelocity1);
        if (fF0 <= this.ZeroThreshold) {
            this.m_fContactTime = fT0;
            return 0.0f;
        }
        float fDF0 = this.GetDerivative(fT0, rkVelocity0, rkVelocity1);
        if (fDF0 >= 0.0f) {
            this.m_fContactTime = fT0;
            return fF0;
        }
        float fT1 = fTMax;
        float fF1 = this.Get(fT1, rkVelocity0, rkVelocity1);
        if (fF1 <= this.ZeroThreshold) {
            this.m_fContactTime = fT1;
            return 0.0f;
        }
        float fDF1 = this.GetDerivative(fT1, rkVelocity0, rkVelocity1);
        if (fDF1 <= 0.0f) {
            this.m_fContactTime = fT1;
            return fF1;
        }
        for (i = 0; i < this.MaximumIterations && !((fT = fT0 - fF0 / fDF0) >= fTMax); ++i) {
            float fF = this.Get(fT, rkVelocity0, rkVelocity1);
            if (fF <= this.ZeroThreshold) {
                this.m_fContactTime = fT;
                return 0.0f;
            }
            float fDF = this.GetDerivative(fT, rkVelocity0, rkVelocity1);
            if (fDF >= 0.0f) break;
            fT0 = fT;
            fF0 = fF;
            fDF0 = fDF;
        }
        if (i == this.MaximumIterations) {
            this.m_fContactTime = fT0;
            return fF0;
        }
        float fTm = fT0;
        for (i = 0; i < this.MaximumIterations; ++i) {
            fTm = 0.5f * (fT0 + fT1);
            float fDFm = this.GetDerivative(fTm, rkVelocity0, rkVelocity1);
            float fProduct = fDFm * fDF0;
            if (fProduct < -this.ZeroThreshold) {
                fT1 = fTm;
                fDF1 = fDFm;
                continue;
            }
            if (!(fProduct > this.ZeroThreshold)) break;
            fT0 = fTm;
            fDF0 = fDFm;
        }
        this.m_fContactTime = fTm;
        float fFm = this.Get(fTm, rkVelocity0, rkVelocity1);
        return fFm;
    }

    public float GetSquared(float fTMin, float fTMax, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        float fT;
        int i;
        float fT0 = fTMin;
        float fF0 = this.GetSquared(fT0, rkVelocity0, rkVelocity1);
        if (fF0 <= this.ZeroThreshold) {
            this.m_fContactTime = fT0;
            return 0.0f;
        }
        float fDF0 = this.GetDerivativeSquared(fT0, rkVelocity0, rkVelocity1);
        if (fDF0 >= 0.0f) {
            this.m_fContactTime = fT0;
            return fF0;
        }
        float fT1 = fTMax;
        float fF1 = this.GetSquared(fT1, rkVelocity0, rkVelocity1);
        if (fF1 <= this.ZeroThreshold) {
            this.m_fContactTime = fT1;
            return 0.0f;
        }
        float fDF1 = this.GetDerivativeSquared(fT1, rkVelocity0, rkVelocity1);
        if (fDF1 <= 0.0f) {
            this.m_fContactTime = fT1;
            return fF1;
        }
        for (i = 0; i < this.MaximumIterations && !((fT = fT0 - fF0 / fDF0) >= fTMax); ++i) {
            float fF = this.GetSquared(fT, rkVelocity0, rkVelocity1);
            if (fF <= this.ZeroThreshold) {
                this.m_fContactTime = fT;
                return 0.0f;
            }
            float fDF = this.GetDerivativeSquared(fT, rkVelocity0, rkVelocity1);
            if (fDF >= 0.0f) break;
            fT0 = fT;
            fF0 = fF;
            fDF0 = fDF;
        }
        if (i == this.MaximumIterations) {
            this.m_fContactTime = fT0;
            return fF0;
        }
        float fTm = fT0;
        for (i = 0; i < this.MaximumIterations; ++i) {
            fTm = 0.5f * (fT0 + fT1);
            float fDFm = this.GetDerivativeSquared(fTm, rkVelocity0, rkVelocity1);
            float fProduct = fDFm * fDF0;
            if (fProduct < -this.ZeroThreshold) {
                fT1 = fTm;
                fDF1 = fDFm;
                continue;
            }
            if (!(fProduct > this.ZeroThreshold)) break;
            fT0 = fTm;
            fDF0 = fDFm;
        }
        this.m_fContactTime = fTm;
        float fFm = this.GetSquared(fTm, rkVelocity0, rkVelocity1);
        return fFm;
    }

    public void SetDifferenceStep(float fDifferenceStep) {
        assert (fDifferenceStep > 0.0f);
        this.m_fDifferenceStep = fDifferenceStep > 0.0f ? fDifferenceStep : 0.001f;
        this.m_fInvTwoDifferenceStep = 0.5f / this.m_fDifferenceStep;
    }

    public float GetDifferenceStep() {
        return this.m_fDifferenceStep;
    }

    public float GetContactTime() {
        return this.m_fContactTime;
    }

    public Vector3f GetClosestPoint0() {
        return this.m_kClosestPoint0;
    }

    public Vector3f GetClosestPoint1() {
        return this.m_kClosestPoint1;
    }

    public boolean HasMultipleClosestPoints0() {
        return this.m_bHasMultipleClosestPoints0;
    }

    public boolean HasMultipleClosestPoints1() {
        return this.m_bHasMultipleClosestPoints1;
    }
}

