/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Distance;

import WildMagic.LibFoundation.Distance.Distance;
import WildMagic.LibFoundation.Mathematics.Ellipsoid3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;

public class DistanceVector3Ellipsoid3
extends Distance {
    private final Vector3f m_pkVector;
    private final Ellipsoid3f m_pkEllipsoid;

    public DistanceVector3Ellipsoid3(Vector3f rkVector, Ellipsoid3f rkEllipsoid) {
        this.m_pkVector = rkVector;
        this.m_pkEllipsoid = rkEllipsoid;
    }

    public Vector3f GetVector() {
        return this.m_pkVector;
    }

    public Ellipsoid3f GetEllipsoid() {
        return this.m_pkEllipsoid;
    }

    @Override
    public float Get() {
        return (float)Math.sqrt(this.GetSquared());
    }

    @Override
    public float GetSquared() {
        float fR2;
        float fQ2;
        float fP2;
        float fS;
        float fT;
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_pkVector, this.m_pkEllipsoid.Center);
        Vector3f kEPoint = new Vector3f(kDiff.Dot(this.m_pkEllipsoid.Axis[0]), kDiff.Dot(this.m_pkEllipsoid.Axis[1]), kDiff.Dot(this.m_pkEllipsoid.Axis[2]));
        float[] afExtent = this.m_pkEllipsoid.Extent;
        float fA2 = afExtent[0] * afExtent[0];
        float fB2 = afExtent[1] * afExtent[1];
        float fC2 = afExtent[2] * afExtent[2];
        float fU2 = kEPoint.X * kEPoint.X;
        float fV2 = kEPoint.Y * kEPoint.Y;
        float fW2 = kEPoint.Z * kEPoint.Z;
        float fA2U2 = fA2 * fU2;
        float fB2V2 = fB2 * fV2;
        float fC2W2 = fC2 * fW2;
        float fURatio = kEPoint.X / afExtent[0];
        float fVRatio = kEPoint.Y / afExtent[1];
        float fWRatio = kEPoint.Z / afExtent[2];
        if (fURatio * fURatio + fVRatio * fVRatio + fWRatio * fWRatio < 1.0f) {
            fT = 0.0f;
        } else {
            float fMax = afExtent[0];
            if (afExtent[1] > fMax) {
                fMax = afExtent[1];
            }
            if (afExtent[2] > fMax) {
                fMax = afExtent[2];
            }
            fT = fMax * kEPoint.Length();
        }
        int iMaxIteration = 64;
        float fP = 1.0f;
        float fQ = 1.0f;
        float fR = 1.0f;
        for (int i = 0; i < 64 && !(Math.abs(fS = (fP2 = (fP = fT + fA2) * fP) * (fQ2 = (fQ = fT + fB2) * fQ) * (fR2 = (fR = fT + fC2) * fR) - fA2U2 * fQ2 * fR2 - fB2V2 * fP2 * fR2 - fC2W2 * fP2 * fQ2) < 1.0E-6f); ++i) {
            float fPQ = fP * fQ;
            float fPR = fP * fR;
            float fQR = fQ * fR;
            float fPQR = fP * fQ * fR;
            float fDS = 2.0f * (fPQR * (fQR + fPR + fPQ) - fA2U2 * fQR * (fQ + fR) - fB2V2 * fPR * (fP + fR) - fC2W2 * fPQ * (fP + fQ));
            fT -= fS / fDS;
        }
        Vector3f kClosest = new Vector3f(fA2 * kEPoint.X / fP, fB2 * kEPoint.Y / fQ, fC2 * kEPoint.Z / fR);
        kDiff.Sub(kClosest, kEPoint);
        float fSqrDistance = kDiff.SquaredLength();
        this.m_kClosestPoint0 = new Vector3f(this.m_pkVector);
        Vector3f kScale0 = new Vector3f(this.m_pkEllipsoid.Axis[0]);
        kScale0.Scale(kClosest.X);
        Vector3f kScale1 = new Vector3f(this.m_pkEllipsoid.Axis[1]);
        kScale0.Scale(kClosest.Y);
        Vector3f kScale2 = new Vector3f(this.m_pkEllipsoid.Axis[2]);
        kScale0.Scale(kClosest.Z);
        this.m_kClosestPoint1 = new Vector3f(this.m_pkEllipsoid.Center);
        this.m_kClosestPoint1.Add(kScale0, kScale1);
        this.m_kClosestPoint1.Add(kScale2);
        return fSqrDistance;
    }

    @Override
    public float Get(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        Vector3f kMVector = new Vector3f(rkVelocity0);
        kMVector.Scale(fT);
        kMVector.Add(this.m_pkVector);
        Vector3f kMCenter = new Vector3f(rkVelocity1);
        kMCenter.Scale(fT);
        kMCenter.Add(this.m_pkEllipsoid.Center);
        Ellipsoid3f kMEllipsoid = new Ellipsoid3f(kMCenter, this.m_pkEllipsoid.Axis, this.m_pkEllipsoid.Extent);
        DistanceVector3Ellipsoid3 kDist = new DistanceVector3Ellipsoid3(kMVector, kMEllipsoid);
        return kDist.Get();
    }

    @Override
    public float GetSquared(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        Vector3f kMVector = new Vector3f(rkVelocity0);
        kMVector.Scale(fT);
        kMVector.Add(this.m_pkVector);
        Vector3f kMCenter = new Vector3f(rkVelocity1);
        kMCenter.Scale(fT);
        kMCenter.Add(this.m_pkEllipsoid.Center);
        Ellipsoid3f kMEllipsoid = new Ellipsoid3f(kMCenter, this.m_pkEllipsoid.Axis, this.m_pkEllipsoid.Extent);
        DistanceVector3Ellipsoid3 kDist = new DistanceVector3Ellipsoid3(kMVector, kMEllipsoid);
        return kDist.GetSquared();
    }
}

