/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Distance;

import WildMagic.LibFoundation.Distance.Distance;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;

public class DistanceVector3Plane3
extends Distance {
    private Vector3f m_kPoint;
    private Plane3f m_kPlane;

    public DistanceVector3Plane3(Vector3f point, Plane3f plane) {
        this.m_kPoint = point;
        this.m_kPlane = plane;
    }

    public Vector3f GetPoint() {
        return this.m_kPoint;
    }

    public Plane3f GetPlane() {
        return this.m_kPlane;
    }

    @Override
    public float Get() {
        float signedDistance = this.m_kPlane.Normal.Dot(this.m_kPoint) - this.m_kPlane.Constant;
        this.m_kClosestPoint0 = new Vector3f(this.m_kPoint);
        this.m_kClosestPoint1 = new Vector3f();
        Vector3f kTemp = new Vector3f(this.m_kPlane.Normal);
        kTemp.Scale(signedDistance);
        this.m_kClosestPoint1.Sub(this.m_kPoint, kTemp);
        return Math.abs(signedDistance);
    }

    @Override
    public float GetSquared() {
        float signedDistance = this.m_kPlane.Normal.Dot(this.m_kPoint) - this.m_kPlane.Constant;
        this.m_kClosestPoint0 = new Vector3f(this.m_kPoint);
        this.m_kClosestPoint1 = new Vector3f();
        Vector3f kTemp = new Vector3f(this.m_kPlane.Normal);
        kTemp.Scale(signedDistance);
        this.m_kClosestPoint1.Sub(this.m_kPoint, kTemp);
        return signedDistance * signedDistance;
    }

    @Override
    public float Get(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        Vector3f movedPoint = new Vector3f(rkVelocity0);
        movedPoint.Scale(fT);
        movedPoint.Add(this.m_kPoint);
        Vector3f kTemp = new Vector3f(this.m_kPlane.Normal);
        kTemp.Scale(fT);
        float movedConstant = this.m_kPlane.Constant + kTemp.Dot(rkVelocity1);
        Plane3f movedPlane = new Plane3f(this.m_kPlane.Normal, movedConstant);
        DistanceVector3Plane3 dist = new DistanceVector3Plane3(movedPoint, movedPlane);
        return dist.Get();
    }

    @Override
    public float GetSquared(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        Vector3f movedPoint = new Vector3f(rkVelocity0);
        movedPoint.Scale(fT);
        movedPoint.Add(this.m_kPoint);
        Vector3f kTemp = new Vector3f(this.m_kPlane.Normal);
        kTemp.Scale(fT);
        float movedConstant = this.m_kPlane.Constant + kTemp.Dot(rkVelocity1);
        Plane3f movedPlane = new Plane3f(this.m_kPlane.Normal, movedConstant);
        DistanceVector3Plane3 dist = new DistanceVector3Plane3(movedPoint, movedPlane);
        return dist.GetSquared();
    }
}

