/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Distance;

import WildMagic.LibFoundation.Distance.Distance;
import WildMagic.LibFoundation.Mathematics.Segment3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;

public class DistanceVector3Segment3
extends Distance {
    private Vector3f m_pkVector;
    private Segment3f m_pkSegment;
    float m_fSegmentParameter;

    public DistanceVector3Segment3(Vector3f rkVector, Segment3f rkSegment) {
        this.m_pkVector = rkVector;
        this.m_pkSegment = rkSegment;
    }

    public Vector3f GetVector() {
        return this.m_pkVector;
    }

    public Segment3f GetSegment() {
        return this.m_pkSegment;
    }

    @Override
    public float Get() {
        float fSqrDist = this.GetSquared();
        return (float)Math.sqrt(fSqrDist);
    }

    @Override
    public float GetSquared() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_pkVector, this.m_pkSegment.Center);
        this.m_fSegmentParameter = this.m_pkSegment.Direction.Dot(kDiff);
        if (-this.m_pkSegment.Extent < this.m_fSegmentParameter) {
            if (this.m_fSegmentParameter < this.m_pkSegment.Extent) {
                Vector3f kTemp = new Vector3f(this.m_pkSegment.Direction);
                kTemp.Scale(this.m_fSegmentParameter);
                this.m_kClosestPoint1.Add(this.m_pkSegment.Center, kTemp);
            } else {
                Vector3f kTemp = new Vector3f(this.m_pkSegment.Direction);
                kTemp.Scale(this.m_pkSegment.Extent);
                this.m_kClosestPoint1.Add(this.m_pkSegment.Center, kTemp);
                this.m_fSegmentParameter = this.m_pkSegment.Extent;
            }
        } else {
            Vector3f kTemp = new Vector3f(this.m_pkSegment.Direction);
            kTemp.Scale(this.m_pkSegment.Extent);
            this.m_kClosestPoint1.Sub(this.m_pkSegment.Center, kTemp);
            this.m_fSegmentParameter = -this.m_pkSegment.Extent;
        }
        this.m_kClosestPoint0 = this.m_pkVector;
        kDiff.Sub(this.m_kClosestPoint1, this.m_kClosestPoint0);
        return kDiff.SquaredLength();
    }

    @Override
    public float Get(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        Vector3f kMVector = new Vector3f(rkVelocity0);
        kMVector.Scale(fT);
        kMVector.Add(this.m_pkVector);
        Vector3f kMOrigin = new Vector3f(rkVelocity1);
        kMOrigin.Scale(fT);
        kMOrigin.Add(this.m_pkSegment.Center);
        Segment3f kMSegment = new Segment3f(kMOrigin, this.m_pkSegment.Direction, this.m_pkSegment.Extent);
        DistanceVector3Segment3 kDist = new DistanceVector3Segment3(kMVector, kMSegment);
        return kDist.Get();
    }

    @Override
    public float GetSquared(float fT, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        Vector3f kMVector = new Vector3f(rkVelocity0);
        kMVector.Scale(fT);
        kMVector.Add(this.m_pkVector);
        Vector3f kMOrigin = new Vector3f(rkVelocity1);
        kMOrigin.Scale(fT);
        kMOrigin.Add(this.m_pkSegment.Center);
        Segment3f kMSegment = new Segment3f(kMOrigin, this.m_pkSegment.Direction, this.m_pkSegment.Extent);
        DistanceVector3Segment3 kDist = new DistanceVector3Segment3(kMVector, kMSegment);
        return kDist.GetSquared();
    }

    public float GetSegmentParameter() {
        return this.m_fSegmentParameter;
    }
}

