/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import java.io.Serializable;

public class IntrPlane3Box3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = -5392287033907685624L;
    private Plane3f m_kPlane;
    private Box3f m_kBox;

    public IntrPlane3Box3f(Plane3f kPlane, Box3f kBox) {
        this.m_kPlane = kPlane;
        this.m_kBox = kBox;
    }

    public Plane3f GetPlane() {
        return this.m_kPlane;
    }

    public Box3f GetBox() {
        return this.m_kBox;
    }

    @Override
    public boolean Test() {
        float[] tmp = new float[]{this.m_kBox.Extent[0] * this.m_kPlane.Normal.Dot(this.m_kBox.Axis[0]), this.m_kBox.Extent[1] * this.m_kPlane.Normal.Dot(this.m_kBox.Axis[1]), this.m_kBox.Extent[2] * this.m_kPlane.Normal.Dot(this.m_kBox.Axis[2])};
        float radius = Math.abs(tmp[0]) + Math.abs(tmp[1]) + Math.abs(tmp[2]);
        float signedDistance = this.m_kPlane.DistanceTo(this.m_kBox.Center);
        return Math.abs(signedDistance) <= radius;
    }

    public boolean BoxIsCulled() {
        float[] tmp = new float[]{this.m_kBox.Extent[0] * this.m_kPlane.Normal.Dot(this.m_kBox.Axis[0]), this.m_kBox.Extent[1] * this.m_kPlane.Normal.Dot(this.m_kBox.Axis[1]), this.m_kBox.Extent[2] * this.m_kPlane.Normal.Dot(this.m_kBox.Axis[2])};
        float radius = Math.abs(tmp[0]) + Math.abs(tmp[1]) + Math.abs(tmp[2]);
        float signedDistance = this.m_kPlane.DistanceTo(this.m_kBox.Center);
        return signedDistance <= -radius;
    }
}

