/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Mathematics.Ray2f;
import WildMagic.LibFoundation.Mathematics.Segment2f;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import java.io.Serializable;

public class IntrRay2Segment2f
implements Serializable {
    private static final long serialVersionUID = 6656697232966582636L;

    public static int FindIntersection(Ray2f kRay, Segment2f kSegment, float[] afT) {
        Vector2f kDiff = new Vector2f();
        float fD0SqrLen = kRay.Direction.SquaredLength();
        int iQuantity = IntrRay2Segment2f.Find(kRay.Origin, kRay.Direction, kSegment.Origin, kSegment.Direction, kDiff, afT);
        if (0 != iQuantity) {
            if (iQuantity == 1) {
                if (afT[0] < 0.0f || afT[1] < 0.0f || afT[1] > 1.0f) {
                    iQuantity = 0;
                }
            } else {
                float fDot1;
                float fDot0;
                float fDotRS = kRay.Direction.Dot(kSegment.Direction);
                if (fDotRS > 0.0f) {
                    fDot0 = kDiff.Dot(kRay.Direction);
                    fDot1 = fDot0 + fDotRS;
                } else {
                    fDot1 = kDiff.Dot(kRay.Direction);
                    fDot0 = fDot1 + fDotRS;
                }
                if (fDot0 >= 0.0f) {
                    float fInvLen = 1.0f / fD0SqrLen;
                    afT[0] = fDot0 * fInvLen;
                    afT[1] = fDot1 * fInvLen;
                } else if (fDot1 > 0.0f) {
                    afT[0] = 0.0f;
                    afT[1] = fDot1 / fD0SqrLen;
                } else if (fDot1 < 0.0f) {
                    iQuantity = 0;
                } else {
                    iQuantity = 1;
                    afT[0] = 0.0f;
                }
            }
        }
        return iQuantity;
    }

    private static int Find(Vector2f kP0, Vector2f kD0, Vector2f kP1, Vector2f kD1, Vector2f kDiff, float[] afT) {
        int iQuantity;
        float fDet = kD1.Cross(kD0);
        kDiff.Sub(kP1, kP0);
        float fD0SqrLen = kD0.SquaredLength();
        if (fDet * fDet > 1.1920929E-7f * fD0SqrLen * kD1.SquaredLength()) {
            float fInvDet = 1.0f / fDet;
            afT[0] = kD1.Cross(kDiff) * fInvDet;
            afT[1] = kD0.Cross(kDiff) * fInvDet;
            iQuantity = 1;
        } else {
            float fRHS;
            fDet = kD0.Cross(kDiff);
            iQuantity = fDet * fDet > (fRHS = 1.1920929E-7f * fD0SqrLen * kDiff.SquaredLength()) ? 0 : 2;
        }
        return iQuantity;
    }
}

