/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Intersection.IntrLine3Box3f;
import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Segment3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrSegment3Box3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = 8765331453395221923L;
    private Segment3f m_rkSegment;
    private Box3f m_rkBox;
    private boolean m_bSolid;
    private int m_iQuantity;
    private Vector3f[] m_akPoint = new Vector3f[2];

    public IntrSegment3Box3f(Segment3f rkSegment, Box3f rkBox, boolean bSolid) {
        this.m_rkSegment = rkSegment;
        this.m_rkBox = rkBox;
        this.m_bSolid = bSolid;
    }

    @Override
    public boolean Find() {
        float[] fT0 = new float[]{-this.m_rkSegment.Extent};
        float[] fT1 = new float[]{this.m_rkSegment.Extent};
        int[] aiQuantity = new int[]{this.m_iQuantity};
        Intersector.IntersectionInfo[] iIntersectionType = new Intersector.IntersectionInfo[]{this.m_iIntersectionType};
        boolean bResult = IntrLine3Box3f.DoClipping(fT0, fT1, this.m_rkSegment.Center, this.m_rkSegment.Direction, this.m_rkBox, this.m_bSolid, aiQuantity, this.m_akPoint, iIntersectionType);
        this.m_iQuantity = aiQuantity[0];
        this.m_iIntersectionType = iIntersectionType[0];
        return bResult;
    }

    public final Box3f GetBox() {
        return this.m_rkBox;
    }

    public final Vector3f GetPoint(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akPoint[i];
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    public final Segment3f GetSegment() {
        return this.m_rkSegment;
    }

    @Override
    public boolean Test() {
        float[] afAWdU = new float[3];
        float[] afADdU = new float[3];
        float[] afAWxDdU = new float[3];
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkSegment.Center, this.m_rkBox.Center);
        afAWdU[0] = Math.abs(this.m_rkSegment.Direction.Dot(this.m_rkBox.Axis[0]));
        afADdU[0] = Math.abs(kDiff.Dot(this.m_rkBox.Axis[0]));
        float fRhs = this.m_rkBox.Extent[0] + this.m_rkSegment.Extent * afAWdU[0];
        if (afADdU[0] > fRhs) {
            return false;
        }
        afAWdU[1] = Math.abs(this.m_rkSegment.Direction.Dot(this.m_rkBox.Axis[1]));
        afADdU[1] = Math.abs(kDiff.Dot(this.m_rkBox.Axis[1]));
        fRhs = this.m_rkBox.Extent[1] + this.m_rkSegment.Extent * afAWdU[1];
        if (afADdU[1] > fRhs) {
            return false;
        }
        afAWdU[2] = Math.abs(this.m_rkSegment.Direction.Dot(this.m_rkBox.Axis[2]));
        afADdU[2] = Math.abs(kDiff.Dot(this.m_rkBox.Axis[2]));
        fRhs = this.m_rkBox.Extent[2] + this.m_rkSegment.Extent * afAWdU[2];
        if (afADdU[2] > fRhs) {
            return false;
        }
        Vector3f kWxD = new Vector3f();
        kWxD.Cross(this.m_rkSegment.Direction, kDiff);
        afAWxDdU[0] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[0]));
        fRhs = this.m_rkBox.Extent[1] * afAWdU[2] + this.m_rkBox.Extent[2] * afAWdU[1];
        if (afAWxDdU[0] > fRhs) {
            return false;
        }
        afAWxDdU[1] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[1]));
        fRhs = this.m_rkBox.Extent[0] * afAWdU[2] + this.m_rkBox.Extent[2] * afAWdU[0];
        if (afAWxDdU[1] > fRhs) {
            return false;
        }
        afAWxDdU[2] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[2]));
        fRhs = this.m_rkBox.Extent[0] * afAWdU[1] + this.m_rkBox.Extent[1] * afAWdU[0];
        return !(afAWxDdU[2] > fRhs);
    }
}

