/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Intersection.IntrLine3Plane3f;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Segment3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrSegment3Plane3f
extends Intersector
implements Serializable {
    private Intersector.IntersectionInfo m_kIntersectionType;
    private Segment3f m_kSegment;
    private Plane3f m_kPlane;
    private float m_fSegmentParameter;

    public IntrSegment3Plane3f(Segment3f kSegment, Plane3f kPlane) {
        this.m_kSegment = new Segment3f(kSegment);
        this.m_kPlane = new Plane3f(kPlane);
    }

    public Segment3f GetSegment() {
        return this.m_kSegment;
    }

    public Plane3f GetPlane() {
        return this.m_kPlane;
    }

    @Override
    public boolean Test() {
        float prod;
        Vector3f P0 = this.m_kSegment.Center;
        float sdistance0 = this.m_kPlane.DistanceTo(P0);
        if (Math.abs(sdistance0) <= 1.0E-6f) {
            sdistance0 = 0.0f;
        }
        Vector3f P1 = new Vector3f();
        this.m_kSegment.GetPosEnd(P1);
        float sdistance1 = this.m_kPlane.DistanceTo(P1);
        if (Math.abs(sdistance1) <= 1.0E-6f) {
            sdistance1 = 0.0f;
        }
        if ((prod = sdistance0 * sdistance1) < 0.0f) {
            this.m_kIntersectionType = Intersector.IntersectionInfo.IT_POINT;
            return true;
        }
        if (prod > 0.0f) {
            this.m_kIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
            return false;
        }
        if (sdistance0 != 0.0f || sdistance1 != 0.0f) {
            this.m_kIntersectionType = Intersector.IntersectionInfo.IT_POINT;
            return true;
        }
        this.m_kIntersectionType = Intersector.IntersectionInfo.IT_SEGMENT;
        return true;
    }

    @Override
    public boolean Find() {
        Line3f kLine = new Line3f(this.m_kSegment.Center, this.m_kSegment.Direction);
        IntrLine3Plane3f intr = new IntrLine3Plane3f(kLine, this.m_kPlane);
        if (intr.Find()) {
            this.m_kIntersectionType = intr.GetIntersectionType();
            this.m_fSegmentParameter = intr.GetLineParameter();
            return this.m_fSegmentParameter >= 0.0f && this.m_fSegmentParameter <= this.m_kSegment.Extent;
        }
        this.m_kIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
        return false;
    }

    public float GetSegmentParameter() {
        return this.m_fSegmentParameter;
    }
}

